/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.calendar;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSaveVO;
import com.elitesland.scp.domain.convert.calendar.ScpStoreCalendarSetConvert;
import com.elitesland.scp.domain.entity.calendar.ScpStoreCalendarSetDO;
import com.elitesland.scp.domain.service.calendar.ScpStoreCalendarSetDomainService;
import com.elitesland.scp.infr.dto.calendar.ScpStoreCalendarSetDTO;
import com.elitesland.scp.infr.repo.calendar.ScpStoreCalendarSetLineRepoProc;
import com.elitesland.scp.infr.repo.calendar.ScpStoreCalendarSetRepo;
import com.elitesland.scp.infr.repo.calendar.ScpStoreCalendarSetRepoProc;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpStoreCalendarSetDomainServiceImpl
implements ScpStoreCalendarSetDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreCalendarSetDomainServiceImpl.class);
    private final ScpStoreCalendarSetRepoProc scpStoreCalendarSetRepoProc;
    private final ScpStoreCalendarSetRepo scpStoreCalendarSetRepo;
    private final ScpStoreCalendarSetLineRepoProc scpStoreCalendarSetLineRepoProc;
    private final UdcProvider udcProvider;

    @Override
    public PagingVO<ScpStoreCalendarSetPageRespVO> queryCalendarSetList(ScpStoreCalendarSetPageParamVO paramVO) {
        long count = this.scpStoreCalendarSetRepoProc.count(paramVO);
        if (count > 0L) {
            List<ScpStoreCalendarSetPageRespVO> demandSet = this.scpStoreCalendarSetRepoProc.queryCalendarSet(paramVO);
            if (CollectionUtil.isNotEmpty(demandSet)) {
                Map deliveryTypeMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2");
                demandSet.forEach(set -> {
                    if (StringUtils.isNotBlank((CharSequence)set.getDeliveryType())) {
                        set.setDeliveryTypeName(Stream.of(set.getDeliveryType().split(",")).filter(deliveryTypeMap::containsKey).map(deliveryTypeMap::get).collect(Collectors.joining(",")));
                    }
                });
            }
            return new PagingVO(count, demandSet);
        }
        return new PagingVO();
    }

    @Override
    public Optional<ScpStoreCalendarSetDTO> findCalendarSetById(Long id) {
        Optional<ScpStoreCalendarSetDTO> setOptional = this.scpStoreCalendarSetRepo.findById(id).map(ScpStoreCalendarSetConvert.INSTANCE::doToDTO);
        setOptional.ifPresent(set -> {
            Map deliveryTypeMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2");
            if (StringUtils.isNotBlank((CharSequence)set.getDeliveryType())) {
                set.setDeliveryTypeName(Stream.of(set.getDeliveryType().split(",")).filter(deliveryTypeMap::containsKey).map(deliveryTypeMap::get).collect(Collectors.joining(",")));
            }
        });
        return setOptional;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveCalendarSet(ScpStoreCalendarSetSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpStoreCalendarSetDO intentDO = ScpStoreCalendarSetConvert.INSTANCE.saveVOToDO(saveVO);
            Long masId = ((ScpStoreCalendarSetDO)this.scpStoreCalendarSetRepo.save(intentDO)).getId();
            return masId;
        }
        Optional<ScpStoreCalendarSetDO> option = this.scpStoreCalendarSetRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6eID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpStoreCalendarSetDO scpOrderSettingDO = option.get();
        ScpStoreCalendarSetConvert.INSTANCE.copySaveParamToDo(saveVO, scpOrderSettingDO);
        Long masId = ((ScpStoreCalendarSetDO)this.scpStoreCalendarSetRepo.save(scpOrderSettingDO)).getId();
        return masId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpStoreCalendarSetRepoProc.deleteByIds(ids);
        this.scpStoreCalendarSetLineRepoProc.deleteByMasIds(ids);
    }

    @Override
    public List<ScpStoreCalendarSetRespVO> findCalendarSet(ScpStoreCalendarSetParamVO paramVO) {
        return this.scpStoreCalendarSetRepoProc.findCalendarSet(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approveUpdateApplyAlter(List<Long> ids, String docStatus, ProcInstStatus procInstStatus, String approveComment, LocalDateTime apprTime) {
        this.scpStoreCalendarSetRepoProc.approveUpdateApplyAlter(ids, docStatus, procInstStatus, approveComment, apprTime);
    }

    @Override
    public void applyChangeUpdate(Long id, String docStatus, ProcInstStatus procInstStatus) {
        this.scpStoreCalendarSetRepoProc.applyChangeUpdate(id, docStatus, procInstStatus);
    }

    public ScpStoreCalendarSetDomainServiceImpl(ScpStoreCalendarSetRepoProc scpStoreCalendarSetRepoProc, ScpStoreCalendarSetRepo scpStoreCalendarSetRepo, ScpStoreCalendarSetLineRepoProc scpStoreCalendarSetLineRepoProc, UdcProvider udcProvider) {
        this.scpStoreCalendarSetRepoProc = scpStoreCalendarSetRepoProc;
        this.scpStoreCalendarSetRepo = scpStoreCalendarSetRepo;
        this.scpStoreCalendarSetLineRepoProc = scpStoreCalendarSetLineRepoProc;
        this.udcProvider = udcProvider;
    }
}

