package com.elitesland.scp.application.facade.vo.param.purLimit;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "订货强配活动查询参数")
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ScpPurLimitSettingPageParamVO extends AbstractOrderQueryParam {

    @ApiModelProperty("适用类型")
    private String docType;

    @ApiModelProperty("活动类型或编码")
    private String activityCodeName;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("生效开始时间")
    private LocalDateTime validFrom;

    @ApiModelProperty("生效结束时间")
    private LocalDateTime validTo;

    @ApiModelProperty("是否启用,false:禁用,true:启用")
    private Boolean status;

    @ApiModelProperty("主键ID")
    private List<Long> ids;
}
