package com.elitesland.scp.application.facade.vo.resp.authority;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.scp.domain.vo.survey.SurveyCheckRespVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 计划员权限分配VO
 * @author : wz
 * @date : 2024-3-18
 */
@Data
@ApiModel(value = "计划员权限分配公共方法", description = "计划员权限分配公共方法")
public class ScpsmanAuthorityComponentVO implements Serializable {
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /** 计划员id */
    @ApiModelProperty(name = "计划员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long scpsmanId ;

    /** 计划员编码 */
    @ApiModelProperty(name = "计划员编码")
    private String scpsmanNo ;

    /** 计划员姓名 */
    @ApiModelProperty(name = "计划员姓名")
    private String scpsman ;

    /** 公司id */
    @ApiModelProperty(name = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId ;

    /** 公司名称 */
    @ApiModelProperty(name = "公司名称")
    private String ouName ;

    /** 公司编码 */
    @ApiModelProperty(name = "公司编码")
    private String ouCode ;

    /** 启用状态 */
    @ApiModelProperty(name = "启用状态")
    private Boolean enableStatus ;

    /** 启用状态翻译*/
    @ApiModelProperty(name = "启用状态翻译")
    private String enableStatusName ;

    /** 所属租户ID */
    @ApiModelProperty(name = "所属租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId ;

    /** 所属组织ID */
    @ApiModelProperty(name = "所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long belongOrgId ;

    /** 租户组织ID */
    @ApiModelProperty(name = "租户组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantOrgId ;

    /** 备注 */
    @ApiModelProperty(name = "备注")
    private String remark ;

    /** 公司所属组织id */
    @ApiModelProperty(name = "公司所属组织id")
    private Long orgIdBelong ;

    /** 主表id */
    @ApiModelProperty(name = "主表id")
    private Long masId ;

    /** 类型 */
    @ApiModelProperty(name = "类型")
    @JsonSerialize(using = ToStringSerializer.class)
    @SysCode(sys = "yst-suplan", mod = "SCPSMAN_AUTHORITY_TYPE")
    private int type ;
    private String typeName;

    /** 门店id/仓库id */
    @ApiModelProperty(name = "门店id/仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stWhId ;

    /** 门店编码/仓库编码 */
    @ApiModelProperty(name = "门店编码/仓库编码")
    private String stWhCode ;

    /** 门店名称/仓库名称 */
    @ApiModelProperty(name = "门店名称/仓库名称")
    private String stWhName ;

    /** 门店类型 */
    @ApiModelProperty(name = "门店类型")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2 ;
    /** 门店类型名称 */
    @ApiModelProperty(name = "门店类型名称")
    private String storeType2Name ;


    /** 门店客户(子客户)编码*/
    @ApiModelProperty(name = "门店客户(子客户)编码")
    private String stCustCode ;
    /** 门店客户(子客户)名称 */
    @ApiModelProperty(name = "门店客户(子客户)名称")
    private String stCustName ;
    /** 门店客户的主客户编码*/
    @ApiModelProperty(name = "门店客户的主客户编码")
    private String storeCustCode ;
    /** 门店客户的主客户名称 */
    @ApiModelProperty(name = "门店客户的主客户名称")
    private String storeCustName ;

    /** 门店客户的主客户是否是外部客户*/
    @ApiModelProperty(name = "门店客户的主客户是否是外部客户")
    private Boolean storeCustType2Flag;

    @ApiModelProperty("品牌")
    private String brandCode;

    @ApiModelProperty("门店公司编码")
    private String storeOuCode;

    @ApiModelProperty("是否日结")
    private Boolean dailyFlag;

    @ApiModelProperty("是否预日结")
    private Boolean preDailyFlag;

    @ApiModelProperty("是否需要支付密码设置")
    private Boolean passwordSetFlag;

    @ApiModelProperty("计划员类型")
    private String scpsmanType;
    private String scpsmanTypeName;

    @ApiModelProperty("业务类型权限")
    private List<ScpManAuthorityBusinessTypeVO> businessTypeAuths;

    @ApiModelProperty("门店是否有可用地址")
    private Boolean hasAddress;

    @ApiModelProperty(value = "同意协议状态")
    private Boolean protocolAgreeStatus;

    @ApiModelProperty("同意协议人名")
    private String protocolAgreeUserName;

    @ApiModelProperty("同意协议人手机号(法人)")
    private String protocolAgreeUserPhone;

    @ApiModelProperty(value = "法人名称")
    private String legalName;

    @ApiModelProperty(value = "法人电话")
    private String legalPhone;

    @ApiModelProperty(value = "问卷信息")
    private SurveyCheckRespVO survey;
}
