package com.elitesland.scp.application.facade.vo.template;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: Mark
 * @Date: 2024/5/10 17:02
 * @Description:
 */
@Data
@ExcelIgnoreUnannotated
public class ScpDemandTemplateImportEntity implements Serializable {
    private static final long serialVersionUID = -8040142312464325406L;

    public Integer rowNo;

    @ExcelProperty(value = "序号", index = 1)
    private String seqNo;

    @ApiModelProperty("订货模板名称")
    private String demandTemName;

    @ApiModelProperty("单据类型名称")
    private String docTypeName;

    @ApiModelProperty("要货类型名称")
    private String demandTypeName;

    @ApiModelProperty("起始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    @ApiModelProperty("截止日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    @ApiModelProperty("详细日期")
    private String detailedTime;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private Integer demandTemStatus;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private String demandTemStatusName;

    @ApiModelProperty("备注")
    private String remark;

    //门店仓库区域信息
    /*@ApiModelProperty("类型")
    private String type;*/

    @ApiModelProperty("类型名称")
    private String typeName;

    @ApiModelProperty("门店/仓库/区域编号")
    private String whStZoCode;

    @ApiModelProperty("门店/仓库/区域名称")
    private String whStZoName;


    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("订货数量")
    private BigDecimal demandQuantity;

}
