package com.elitesland.scp.application.web.app;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.app.AppStorePasswordModifyParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppStorePasswordPaymentParamVO;
import com.elitesland.scp.application.service.app.AppStorePasswordPaymentService;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * @author jeesie
 * @description:
 * @datetime 2025年 06月 09日 15:35
 * @version: 1.0
 */

@RestController
@RequestMapping(value ="/app/store/payment",produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "移动端-门店支付密码管理", tags = {"移动端-门店支付密码管理"})
@AllArgsConstructor
public class AppStorePasswordPaymentController {

    private final AppStorePasswordPaymentService appStorePasswordPaymentService;

    @PostMapping("/set-password")
    public ApiResult<?> setPassword(@RequestBody AppStorePasswordPaymentParamVO paramVO) {
        appStorePasswordPaymentService.setPassword(paramVO);
        return ApiResult.ok();
    }

    @PostMapping("/modify-password")
    public ApiResult<?> modifyPassword(@RequestBody AppStorePasswordModifyParamVO paramVO) {
        appStorePasswordPaymentService.modifyPassword(paramVO);
        return ApiResult.ok();
    }


}
