package com.elitesland.scp.domain.entity.mrp;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;

import lombok.experimental.Accessors;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 千元用量商品关联
 *
 * @author wangly
 * @date 2025-03-29
 */
@Entity
@Table(name = "scp_thousand_use_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "scp_thousand_use_ref", comment = "千元用量商品关联")
@Getter
@Setter
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
public class ScpThousandUseRefDO extends BaseModel implements Serializable  {
    /** 主表id */
    @Comment("主表id")
    @Column()
    private Long masId;
    /** 商品id */
    @Comment("商品id")
    @Column()
    private Long itemId;
    /** 类型 */
    @Comment("类型")
    @Column()
    private String itemType;
    /** 商品编码 */
    @Comment("商品编码")
    @Column()
    private String itemCode;
    /** 商品名称 */
    @Comment("商品名称")
    @Column()
    private String itemName;
    /** 商品规格 */
    @Comment("商品规格")
    @Column()
    private String itemAttr;
    /** 商品状态 */
    @Comment("商品状态")
    @Column()
    private String itemStatus;
    /** 商品基本单位 */
    @ApiModelProperty("商品基本单位")
    private String uom;
    /** 商品辅助单位 [UDC]COM:UOM */
    @Comment("商品辅助单位 [UDC]COM:UOM")
    @Column()
    private String uom2;
    /** 预估千元用量 */
    @Comment("预估千元用量")
    @Column()
    private BigDecimal estimateThousNum;
    /** 调整千元用量 */
    @Comment("调整千元用量")
    @Column()
    private BigDecimal adjustThousNum;
    /** ext1 */
    @Comment("ext1")
    @Column()
    private String ext1;
    /** ext2 */
    @Comment("ext2")
    @Column()
    private String ext2;
    /** ext3 */
    @Comment("ext3")
    @Column()
    private String ext3;

    public void copy(ScpThousandUseRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
