package com.elitesland.scp.infr.repo.purLimit;

import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingRegionRespVO;
import com.elitesland.scp.domain.entity.purLimit.QScpPurLimitSettingRegionDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpPurLimitSettingRegionRepoProc {
    private static final QScpPurLimitSettingRegionDO scpPurLimitSettingRegionDO = QScpPurLimitSettingRegionDO.scpPurLimitSettingRegionDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<ScpPurLimitSettingRegionRespVO> pageList = Projections.bean(
            ScpPurLimitSettingRegionRespVO.class,
            scpPurLimitSettingRegionDO.id,
            scpPurLimitSettingRegionDO.masId,
            scpPurLimitSettingRegionDO.region,
            scpPurLimitSettingRegionDO.regionName

    );

    public long countPurLimitSettingRegion(ScpPurLimitSettingRegionPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpPurLimitSettingRegionDO.count())
                .from(scpPurLimitSettingRegionDO);
        jpaQuery.where(this.wherePurLimitSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpPurLimitSettingRegionRespVO> queryPurLimitSettingRegion(ScpPurLimitSettingRegionPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpPurLimitSettingRegionDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpPurLimitSettingRegionDO);
        jpaQuery.where(this.wherePurLimitSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate wherePurLimitSettingPage(ScpPurLimitSettingRegionPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getMasId() != null) {
            predicates.add(scpPurLimitSettingRegionDO.masId.eq(paramVO.getMasId()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findMasIdByRegionCode(String regionCode) {
        var jpaQuery = jpaQueryFactory.select(scpPurLimitSettingRegionDO.masId).distinct()
                .from(scpPurLimitSettingRegionDO);
        jpaQuery.where(scpPurLimitSettingRegionDO.region.eq(regionCode));
        return jpaQuery.fetch();
    }

}
