package com.elitesland.scp.job.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.utils.MessageDelyQueueService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpDemandOrderCloseJobServiceImpl implements ScpDemandOrderCloseJobService {

    private final MessageDelyQueueService delyQueueService;
    private final ScpDemandOrderService scpDemandOrderService;

    /**
     * 定时消费队列中的数据
     * zset会对score进行排序 让最早消费的数据位于最前
     * 拿最前的数据跟当前时间比较 时间到了则消费
     */
    @Override
    public void autoCloseDemandOrder() {
        log.info("订货单延时队列扫描已启动,启动时间:{}", LocalDateTime.now());
        StringBuilder flag = new StringBuilder();
        String message = delyQueueService.pull();
        if (StrUtil.isNotEmpty(message) && this.delyQueueService.remove(message)) {
            log.info("消费消息：{}:消息创建时间：{},消费时间：{}", message, LocalDateTime.now());
            handleMessage(message);
            flag.append("S");
        }
    }



    /**
     * 消息处理
     *
     * @param message
     */
    public void handleMessage(String message) {
        try {
            log.info("consumer message:{},date:{}", message, DateUtil.now());
            scpDemandOrderService.closeOrderByDocNo(message);
            log.info("订货单：{} 延时关闭成功", message);
        } catch (Exception e) {
            log.error("订货单延时关闭订单失败：{}", e);
        }
    }

}
