package com.elitesland.scp.application.facade.vo.resp.app;

import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("商品详情")
public class AppItmSkuRespVO implements Serializable {
    private static final long serialVersionUID = 5187411894221252125L;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "状态")
    private Boolean status;

    @ApiModelProperty(value = "订货单位")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "价格(总)")
    private BigDecimal price;

    @ApiModelProperty("销售单价（不含服务费）")
    private BigDecimal salePrice;

    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty(value = "类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty(value = "品牌")
    private String brand;
    private String brandName;

    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    @ApiModelProperty("spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty(value = "spuCode")
    private String spuCode;

    @ApiModelProperty(value = "spuName")
    private String spuName;

    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    @ApiModelProperty("基本单位")
    private String uom2;
    @ApiModelProperty(value = "基本单位名称")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty("有效位数")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "包装规格")
    private String itemAttrName;

    @ApiModelProperty("商品图片")
    private String url;

    @ApiModelProperty("moq")
    private BigDecimal moq;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("仓配结算价")
    private BigDecimal costPrice;

    @ApiModelProperty("采购价")
    private BigDecimal purPrice;

    @ApiModelProperty("科技费价格")
    private BigDecimal tefPrice;

    @ApiModelProperty("营销费价格")
    private BigDecimal mefPrice;

    @ApiModelProperty("运营费价格")
    private BigDecimal oefPrice;

    @ApiModelProperty("是否收取项目费用")
    private Boolean isProjFeeCharged;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuCode;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuCode;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuCode;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuName;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuName;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuName;


}
