package com.elitesland.scp.application.web.app;

import cn.hutool.json.JSONUtil;
import cn.zhxu.bs.param.Paging;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderAddItemParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderAppCountParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppRelateOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpOrderPayRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.*;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.application.service.app.AppDemandOrderService;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.utils.ValidatedList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


@Slf4j
@Api(tags = "移动端-订货订单接口")
@RestController
@RequestMapping(value = "/dbo/app/order", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class AppDboDemandOrderController {

    private final AppDemandOrderService appDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;
    private final ScpDemandOrderService scpDemandOrderService;

    @ApiOperation(value = "甲指乙采订货订单 - 分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpDemandOrderPageRespVO>> queryDboDemandOrderList(@RequestBody ScpDemandOrderPageParamVO paramVO) {
        log.info("[APP-SCP-DEMAND-ORDER] queryDboDemandOrderList  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpDemandOrderService.queryDemandOrderHeader(paramVO));
    }
    @ApiOperation(value = "甲指乙采监理验收 - 分页查询")
    @PostMapping(value = "/check")
    public ApiResult<PagingVO<ScpDemandOrderCheckRespVO>> queryDboDemandOrderCheckList(@RequestBody ScpDemandOrderPageParamVO paramVO) {
        log.info("[APP-SCP-DBO-DEMAND-ORDER] queryDboDemandOrderCheckList  paramVO ={}", JSONUtil.toJsonStr(paramVO));
//        return ApiResult.ok(scpDemandOrderService.queryDemandOrderHeader(paramVO));

        PagingVO<ScpDemandOrderCheckRespVO> pageVo = PagingVO.builder();

        return ApiResult.ok(pageVo);
    }
}
