package com.elitesland.scp.application.web.minOrder;


import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingStoreSaveVO;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingStoreDomainService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@Api(tags = "订货起订门店接口")
@RestController
@RequestMapping(value = "/minOrder/setting/store", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpMinOrderSettingStoreController {

    private final ScpMinOrderSettingStoreDomainService scpMinOrderSettingStoreDomainService;

    @ApiOperation(value = "订货起订门店 -  门店分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpMinOrderSettingStoreRespVO>> queryMinOrderSettingStore(@RequestBody @Validated ScpMinOrderSettingStorePageParamVO paramVO) {
        log.info("[SCP-MinOrder-SETTING] queryMinOrderSettingStore  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpMinOrderSettingStoreDomainService.page(paramVO));
    }

    @PostMapping("/batchSave")
    @ApiOperation("订货起订门店 - 批量新增")
    public ApiResult<Long> batchSaveMinOrderSettingStore(@RequestBody @Validated List<ScpMinOrderSettingStoreSaveVO> saveVOS) {
        log.info("[SCP-MinOrder-SETTING-STORE] batchSaveMinOrderSettingStore  saveVO ={}", JSONUtil.toJsonStr(saveVOS));
        scpMinOrderSettingStoreDomainService.batchSaveMinOrderSettingStore(saveVOS);
        return ApiResult.ok();
    }

    @PostMapping("/update")
    @ApiOperation("订货起订门店 - 修改")
    public ApiResult<Long> saveMinOrderSettingStore(@RequestBody @Validated ScpMinOrderSettingStoreSaveVO saveVO) {
        log.info("[SCP-MinOrder-SETTING-STORE] saveMinOrderSettingStore  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        scpMinOrderSettingStoreDomainService.updateMinOrderSettingStore(saveVO);
        return ApiResult.ok();
    }

    @ApiOperation("订货起订门店 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-MinOrder-SETTING-STORE] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpMinOrderSettingStoreDomainService.deleteByIds(ids);
        return ApiResult.ok();
    }

}
