package com.elitesland.scp.application.web.serviceconfig;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.*;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 项目服务配置
 *
 * @author chaofeng.xia
 * @since 2025/5/23
 */
@Slf4j
@Api(tags = "项目服务配置")
@RestController
@RequestMapping(value = "/serviceConfig", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpServiceConfigController {

    private final ScpServiceConfigService scpServiceConfigService;

    @PostMapping("/page")
    @ApiOperation("项目服务配置-分页")
    public ApiResult<PagingVO<ScpServiceConfigPageVO>> searchPage(@RequestBody ScpServiceConfigPageParamVO queryParam) {
        return ApiResult.ok(scpServiceConfigService.page(queryParam));
    }


    @PostMapping("/create")
    @ApiOperation("项目服务配置-新增")
    public ApiResult<Object> createServiceConfig(@RequestBody List<ScpServiceConfigSaveVO> createParams) {
        scpServiceConfigService.createServiceConfig(createParams);
        return ApiResult.ok();
    }

    @PostMapping("/modify")
    @ApiOperation("项目服务配置-修改")
    public ApiResult<Object> modifyServiceConfig(@RequestBody ScpServiceConfigSaveVO createParam) {
        scpServiceConfigService.modifyServiceConfig(createParam);
        return ApiResult.ok();
    }

    @GetMapping("/detail/{id}")
    @ApiOperation("项目服务配置-详情查询")
    public ApiResult<ScpServiceConfigRespVO> findWhNetList(@PathVariable Long id) {
        return ApiResult.ok(scpServiceConfigService.findDetailById(id));
    }


    @PutMapping("/delete")
    @ApiOperation("项目服务配置-删除")
    public ApiResult<Object> deleteServiceConfig(@RequestBody List<Long> ids) {
        scpServiceConfigService.deleteServiceConfig(ids);
        return ApiResult.ok();
    }

}
