package com.elitesland.scp.domain.entity.article;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

@Entity
@Table(name = "scp_article_category", indexes = {
})
@Comment("文章分类")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ArticleCategoryDO extends BaseModel implements Serializable {
    @Serial
    private static final long serialVersionUID = -3942085277160144202L;

    @Column(name = "category_name")
    private String categoryName;

    @Column(name = "sort_no")
    private Integer sortNo;

    @Column(name = "show_flag")
    private String showFlag;

    @Column(name = "pid")
    private Long pid;

    @Column(name = "root_id")
    private Long rootId;

}
