package com.elitesland.scp.infr.repo.calendar;

import com.elitesland.scp.domain.entity.calendar.ScpSuppDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpSuppDemandCalendarDTO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-28
* @Version 1.0
**/
@Repository
public interface ScpSuppDemandCalendarRepo extends JpaRepository<ScpSuppDemandCalendarDO, Long>, QuerydslPredicateExecutor<ScpSuppDemandCalendarDO> {

    @Query(value = "select * from scp_supp_demand_calendar where (delete_flag=0 or delete_flag is null) " +
            "and CONCAT(COALESCE(supp_code, ''),COALESCE(type, ''),COALESCE(store_wh_code, ''), COALESCE(year, ''), COALESCE(month, '')) in (?1)",nativeQuery = true)
    List<ScpSuppDemandCalendarDO> findByConcatYearAndMonthKey(List<String> concatKey);


    @Query(value = "select * from scp_supp_demand_calendar where (delete_flag=0 or delete_flag is null) " +
            "and CONCAT(COALESCE(supp_code, ''),COALESCE(type, ''),COALESCE(store_wh_code, ''), COALESCE(year, ''), COALESCE(month, ''),COALESCE(day, '')) in (?1)",nativeQuery = true)
    List<ScpSuppDemandCalendarDO> findCalendarByStoreDayConcatStr(List<String> storeDayConcatStr);

}
