/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.authority;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.authority.StoreAuthorityService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.template.TemplateApplyCartContext;
import com.elitesland.scp.domain.convert.StoreInfoConvert;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.authority.StoreAuthorityRespDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcDTO;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StoreAuthorityServiceImpl
implements StoreAuthorityService {
    private static final Logger log = LoggerFactory.getLogger(StoreAuthorityServiceImpl.class);
    private final RmiItemService rmiItemService;
    private final CommonPriceService commonPriceService;
    private final RmiOrgStoreRpcService rmiOrgStoreService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;

    @Override
    @SysCodeProc
    public StoreAuthorityRespDTO getStoreAuthorityDataBOH(StoreAuthorityRpcDTO storeAuthorityRpcDTO, TemplateApplyCartContext context, List<String> itemCodeList, String type) {
        String storeCode = storeAuthorityRpcDTO.getStoreCode();
        if (StrUtil.isBlank((CharSequence)storeCode)) {
            throw new BusinessException("\u53c2\u6570\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgStoreBaseRpcDTO storeDto = this.rmiOrgStoreService.getOrgStoreBase(storeCode);
        log.info("\u95e8\u5e97\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)storeDto));
        if (storeDto == null) {
            return null;
        }
        context.setStoreDto(storeDto);
        StoreAuthorityRespDTO storeAuthorityRespDTO = StoreInfoConvert.INSTANCE.toStoreAuthorityRespDTO(storeDto);
        String ouCode = storeAuthorityRespDTO.getOuCode();
        String brandCode = storeAuthorityRespDTO.getBrandCode();
        List<ItmItemBusinessRpcDTO> itmItemBusinessRpcDTOS = this.rmiItemService.findItmItemBusinessByBUCodeAndBrandAndItemList(ouCode, brandCode, itemCodeList);
        log.info("\u8c03\u7528\u57fa\u7840\u57df\u67e5\u8be2\u5546\u54c1\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(itmItemBusinessRpcDTOS));
        context.setItmItemBusinessRpcDTOS(itmItemBusinessRpcDTOS);
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(storeAuthorityRpcDTO.getBusinessType(), type);
        List<AppItemActivityItemPriceParamVO> priceParamVOS = itmItemBusinessRpcDTOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom2());
            priceParamVO.setItemType2(row.getItemType2());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, AppItemPriceRespVO> priceMap = this.commonPriceService.getNewPriceAndStockDetails(priceParamVOS, storeDto.getStoreCode(), orderSetting, type);
        log.info("\u5546\u54c1\u4ef7\u683c\u5b57\u6bb5\u6570\u636e:{}", (Object)JSONUtil.toJsonStr(priceMap));
        context.setPriceMap(priceMap);
        ArrayList<StoreAuthorityRespDTO.ItemInfo> itemInfoList = new ArrayList<StoreAuthorityRespDTO.ItemInfo>();
        for (ItmItemBusinessRpcDTO dto : itmItemBusinessRpcDTOS) {
            StoreAuthorityRespDTO.ItemInfo itemInfo = new StoreAuthorityRespDTO.ItemInfo();
            itemInfo.setItemCode(dto.getItemCode());
            itemInfo.setItemId(dto.getId());
            itemInfo.setItemName(dto.getItemName());
            itemInfo.setUom(dto.getUom2());
            itemInfo.setUomName(dto.getUom2Name());
            itemInfo.setTaxRate(dto.getTaxRate2());
            AppItemPriceRespVO priceRespVO = priceMap.get(itemInfo.getItemCode());
            if (priceRespVO != null) {
                itemInfo.setPrice(priceRespVO.getPrice());
                itemInfo.setSalePrice(priceRespVO.getSalePrice());
                itemInfo.setSuppId(priceRespVO.getSuppId());
                itemInfo.setSuppCode(priceRespVO.getSuppCode());
                itemInfo.setSuppName(priceRespVO.getSuppName());
                itemInfo.setStoreCode(priceRespVO.getStoreCode());
                itemInfo.setCostPrice(priceRespVO.getCostPrice());
                itemInfo.setPurPrice(priceRespVO.getPurPrice());
                itemInfo.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                itemInfo.setTefPrice(priceRespVO.getTefPrice());
                itemInfo.setMefPrice(priceRespVO.getMefPrice());
                itemInfo.setOefPrice(priceRespVO.getOefPrice());
                itemInfo.setTefFeeOuCode(priceRespVO.getTefFeeOuCode());
                itemInfo.setTefFeeOuName(priceRespVO.getTefFeeOuName());
                itemInfo.setOefFeeOuCode(priceRespVO.getOefFeeOuCode());
                itemInfo.setOefFeeOuName(priceRespVO.getOefFeeOuName());
                itemInfo.setMefFeeOuCode(priceRespVO.getMefFeeOuCode());
                itemInfo.setMefFeeOuName(priceRespVO.getMefFeeOuName());
            }
            itemInfoList.add(itemInfo);
        }
        storeAuthorityRespDTO.setItemInfos(itemInfoList);
        log.info("\u95e8\u5e97\u8981\u8d27\u6743\u9650\u6570\u636e:{}", (Object)JSONUtil.toJsonStr((Object)storeAuthorityRespDTO));
        return storeAuthorityRespDTO;
    }

    public StoreAuthorityServiceImpl(RmiItemService rmiItemService, CommonPriceService commonPriceService, RmiOrgStoreRpcService rmiOrgStoreService, ScpOrderSettingDomainService scpOrderSettingDomainService) {
        this.rmiItemService = rmiItemService;
        this.commonPriceService = commonPriceService;
        this.rmiOrgStoreService = rmiOrgStoreService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
    }
}

