/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.inv.dto.invTrn.StoreOrderTrnResultDTO;
import com.elitesland.inv.dto.invTrn.StoreOrderTrnRpcDTO;
import com.elitesland.inv.dto.invstk.InvStkItemUomRpcDtoParam;
import com.elitesland.inv.dto.invstk.InvStkQueryRpcParam;
import com.elitesland.inv.dto.invstk.InvStkQueryRpcResult;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.inv.provider.StoreOrderTrnProvider;
import com.elitesland.inv.provider.StoreOrderTroProvider;
import com.elitesland.order.param.SalSoDSaveDTO;
import com.elitesland.order.param.SalSoSaveDTO;
import com.elitesland.pur.dto.PurPriceParamRpcDTO;
import com.elitesland.pur.dto.po.PurPoDSaveDTO;
import com.elitesland.pur.dto.po.PurPoSaveDTO;
import com.elitesland.pur.provider.PurPoProvider;
import com.elitesland.sale.api.vo.resp.crm.CustBaseAndBelongOuDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBelongOuDTO;
import com.elitesland.scp.application.facade.vo.order.ScpDemandOrderExportRespVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpComputeDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderAppCountParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemBatchParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderSubmitMqParam;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.order.AppDemandOrderCountRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderComputeVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPayInfoRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderTitlePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpPayOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.application.service.strategy.EventContext;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.convert.order.ScpDemandSetConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDtoParam;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderRelateDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingItemRepoProc;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrderRpcService;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiPriceRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.scp.rmi.RmiSysSettingService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.DateTimeUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.scp.utils.TransactionCommitHandler;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcDtoParam;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgAddrAddressRpcDTO;
import com.elitesland.support.provider.org.dto.OrgContactRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreWhDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;

@Service
public class ScpDemandOrderServiceImpl
implements ScpDemandOrderService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderServiceImpl.class);
    private final EventContext eventContext;
    private final RmiItemService rmiItemService;
    private final RmiSalRpcService rmiSalRpcService;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiOrderRpcService orderRpcService;
    private final RmiInvStkRpcService rmiInvStkService;
    private final RmiSysSettingService rmiSysSettingService;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final TransactionTemplate transactionTemplate;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final ScpSupplyAllocationService scpSupplyAllocationService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final SupportTransactionPathRpcService supportTransactionPathRpcService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final StoreOrderTroProvider storeOrderTroProvider;
    private final RmiOrgOuService rmiOrgOuService;
    private final RedisTemplate<String, Object> redisTemplate;
    private final MessageQueueTemplate messageQueueTemplate;
    @Autowired
    @Qualifier(value="cloudt_taskExecutor")
    private TaskExecutor taskExecutor;
    private final ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc;
    private final ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final ScpDemandOrderRepo scpDemandOrderRepo;
    private final ScpDemandOrderDRepo scpDemandOrderDRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final WorkflowService workflowService;
    private final TransactionCommitHandler transactionCommitHandler;
    private final CommonPriceService commonPriceService;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    private final StoreOrderTrnProvider storeOrderTrnProvider;
    private final PurPoProvider purPoProvider;
    @Value(value="${ext.server-addr}")
    private String serverAddr;
    @Qualifier(value="com.elitesland.support.provider.org.service.OrgStoreRpcService")
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;

    @Override
    public PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderDList(ScpDemandOrderPageParamVO paramVO) {
        return this.scpDemandOrderDomainService.queryDemandOrderList(paramVO);
    }

    @Override
    public PagingVO<ScpDemandOrderTitlePageRespVO> page(ScpDemandOrderPageParamVO paramVO) {
        return this.scpDemandOrderDomainService.page(paramVO);
    }

    @Override
    public PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        return this.scpDemandOrderDomainService.queryDemandOrderHeader(paramVO);
    }

    @Override
    public PagingVO<ScpDemandOrderPageRespVO> queryDboDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        PagingVO<ScpDemandOrderPageRespVO> dboOrderPageVo = this.scpDemandOrderDomainService.queryDemandOrderHeader(paramVO);
        List records = dboOrderPageVo.getRecords();
        List<String> renovationStoreCodeList = records.stream().filter(record -> StringUtils.isNotBlank((String)record.getRenovationStore())).flatMap(record -> Arrays.stream(StringUtils.split((String)record.getRenovationStore(), (String)","))).map(String::trim).distinct().toList();
        List orgStoreList = this.orgStoreRpcService.queryByStoreCodes(renovationStoreCodeList);
        Map orgStoreMap = orgStoreList.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, Function.identity()));
        records.forEach(record -> {
            if (StringUtils.isNotBlank((String)record.getRenovationStore())) {
                List<String> storeCodes = Arrays.stream(StringUtils.split((String)record.getRenovationStore(), (String)",")).map(String::trim).toList();
                List<String> storeNames = storeCodes.stream().map(code -> orgStoreMap.containsKey(code) ? ((OrgStoreDetailRpcDTO)orgStoreMap.get(code)).getStoreName() : code).toList();
                record.setRenovationStoreName(String.join((CharSequence)",", storeNames));
            }
        });
        return dboOrderPageVo;
    }

    @Override
    public Optional<ScpDemandOrderRespVO> findDemandOrderCateById(Long id) {
        return this.scpDemandOrderDomainService.findDemandOrderById(id).map(row -> {
            ScpDemandOrderRespVO respVO = ScpDemandOrderConvert.INSTANCE.dtoToRespVO((ScpDemandOrderDTO)row);
            respVO.setItemCates(this.scpOrderSettingDomainService.findItemCatesByBusinessType(row.getBusinessType(), row.getType()));
            return respVO;
        });
    }

    @Override
    public Optional<ScpDemandOrderRespVO> findDemandOrderById(Long id) {
        return this.scpDemandOrderDomainService.findDemandOrderById(id).map(ScpDemandOrderConvert.INSTANCE::dtoToRespVO);
    }

    @Override
    public List<ScpDemandOrderRespVO> findDemandOrderByDemandIds(List<Long> demandIds) {
        return this.scpDemandOrderDomainService.findDemandOrderByDemandIds(demandIds).stream().map(ScpDemandOrderConvert.INSTANCE::dtoToRespVO).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ScpDemandOrderDO saveDemandOrder(ScpDemandOrderSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpDemandSetSelectRespVO scpDemandSetDTO = this.getScpDemandSetSelectRespVO(saveVO.getType(), saveVO.getDemandWhStCode());
            saveVO.setDemandId(scpDemandSetDTO.getId());
            saveVO.setDemandCode(scpDemandSetDTO.getDemandCode());
            saveVO.setDemandName(scpDemandSetDTO.getDemandName());
            saveVO.setDemandDate(scpDemandSetDTO.getDemandDate());
            this.generateDemandOrderSaveVo(saveVO);
        }
        return this.scpDemandOrderDomainService.saveDemandOrder(saveVO);
    }

    private void generateDemandOrderSaveVo(ScpDemandOrderSaveVO saveVO) {
        if (saveVO.getId() == null) {
            if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(saveVO.getType()) && (StrUtil.isBlank((CharSequence)saveVO.getRecvProvince()) || StrUtil.isBlank((CharSequence)saveVO.getRecvCity()))) {
                List<OrgContactRpcDTO> contactRpcDTOS = this.rmiOrgStoreRpcService.findContactByStoreCode(saveVO.getDemandWhStCode());
                if (CollUtil.isEmpty(contactRpcDTOS)) {
                    throw new BusinessException("\u95e8\u5e97\u7f16\u7801\uff1a" + saveVO.getDemandWhStCode() + "\u672a\u914d\u7f6e\u8054\u7cfb\u4eba\u4fe1\u606f");
                }
                List filterContacts = contactRpcDTOS.stream().filter(row -> "BUSINESS".equals(row.getType())).collect(Collectors.toList());
                if (CollUtil.isEmpty(filterContacts)) {
                    throw new BusinessException("\u95e8\u5e97\u7f16\u7801\uff1a" + saveVO.getDemandWhStCode() + "\u672a\u914d\u7f6e\u4e1a\u52a1\u8054\u7cfb\u4eba\u4fe1\u606f");
                }
                OrgContactRpcDTO orgContactRpcDTO = (OrgContactRpcDTO)filterContacts.get(0);
                if (orgContactRpcDTO.getProvince() == null || orgContactRpcDTO.getCity() == null || orgContactRpcDTO.getCounty() == null) {
                    throw new BusinessException("\u95e8\u5e97\u7f16\u7801\uff1a" + saveVO.getDemandWhStCode() + "\u672a\u914d\u7f6e\u4e1a\u52a1\u8054\u7cfb\u4eba\u6536\u8d27\u5730\u5740\u4fe1\u606f");
                }
                saveVO.setRecvProvince(orgContactRpcDTO.getProvince());
                saveVO.setRecvCity(orgContactRpcDTO.getCity());
                saveVO.setRecvCounty(orgContactRpcDTO.getCounty());
                saveVO.setRecvDetailaddr(orgContactRpcDTO.getDetailAddress());
            }
            String orderNo = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("OB", new ArrayList<String>());
            saveVO.setStoreLevel(StrUtil.isBlank((CharSequence)saveVO.getStoreLevel()) ? "1" : saveVO.getStoreLevel());
            saveVO.setDocCode(orderNo);
            saveVO.setDocStatus(ScpUdcEnum.DEO_STATUS_DRAFT.getValueCode());
            saveVO.setApprStatus(ScpUdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ScpDemandOrderDO saveAndSubmitDemandOrder(ScpDemandOrderSaveVO saveVO) {
        ScpDemandSetDTO scpDemandSetDTO = this.scpDemandSetDomainService.findDemandSetById(saveVO.getDemandId()).orElseThrow(() -> new BusinessException("\u8ba2\u8d27\u96c6\u4e0d\u5b58\u5728"));
        if (Objects.equals(Boolean.FALSE, scpDemandSetDTO.getStatus())) {
            throw new BusinessException("\u8ba2\u8d27\u96c6\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u65b0\u589e\u8ba2\u8d27\u5355");
        }
        boolean shopUser = this.isShopUser();
        if (shopUser) {
            if (scpDemandSetDTO.getExpireTime() != null && scpDemandSetDTO.getExpireTime().isBefore(LocalDateTime.now())) {
                throw new BusinessException("\u4e0d\u5728\u8ba2\u8d27\u65f6\u95f4\u5185\uff0c\u65e0\u6cd5\u8ba2\u8d27");
            }
            saveVO.setAllowPayTimeout(true);
        } else {
            saveVO.setAllowPayTimeout(false);
        }
        this.generateDemandOrderSaveVo(saveVO);
        saveVO.setDocStatus(ScpUdcEnum.DEO_STATUS_WT.getValueCode());
        String apprStatus = this.generateDemandOrderApprStatus(saveVO.getType(), saveVO.getBusinessType());
        saveVO.setApprStatus(apprStatus);
        return this.scpDemandOrderDomainService.saveDemandOrder(saveVO);
    }

    @Override
    public boolean isShopUser() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        ScpsmanInfoDO byLoginAccount = this.scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7:{}", (Object)JSONUtil.toJsonStr((Object)((Object)byLoginAccount)));
        if (byLoginAccount == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7\u67e5\u8be2\u5f02\u5e38");
        }
        String scpManType = byLoginAccount.getScpsmanType();
        String invisibleAccount = SysUtils.getInvisibleAccount();
        List invisibleAccountList = Arrays.stream(invisibleAccount.split(",")).collect(Collectors.toList());
        log.info("\u9650\u5236\u8d26\u53f7\u7c7b\u578b:{}", (Object)JSONUtil.toJsonStr(invisibleAccountList));
        return invisibleAccountList.contains(scpManType);
    }

    @Override
    public String generateDemandOrderApprStatus(String type, String businessType) {
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(businessType, type);
        if (orderSetting != null && orderSetting.getNeedApproval() != null) {
            if (orderSetting.getNeedApproval().booleanValue()) {
                return ScpUdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode();
            }
            return ScpUdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode();
        }
        return ScpUdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode();
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDRespVO> getItemList(ScpDemandOrderItemParamVO paramVO) {
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(paramVO.getBusinessType(), paramVO.getType());
        if (orderSetting == null) {
            throw new BusinessException("\u8bf7\u5148\u914d\u7f6e\u6216\u542f\u7528\u5355\u636e\u7c7b\u578b:" + paramVO.getDocType());
        }
        OrgStoreBaseRpcDTO orgStore = this.getOrgStore(paramVO.getType(), paramVO.getDemandWhStCode());
        ArrayList<ScpDemandOrderDRespVO> result = new ArrayList<ScpDemandOrderDRespVO>(this.whnetStrategy(paramVO, orgStore, orderSetting));
        if (result.isEmpty()) {
            throw new BusinessException("\u8bf7\u914d\u7f6e\u5546\u54c1\u3010" + paramVO.getItemName() + "\u3011\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u6216\u8005\u4f9b\u5e94\u5546\u4efd\u989d");
        }
        ArrayList<String> itemCodes = new ArrayList<String>();
        for (ScpDemandOrderDRespVO scpDemandOrderDRespVO : result) {
            if (scpDemandOrderDRespVO.getPrice() != null) continue;
            itemCodes.add(scpDemandOrderDRespVO.getItemCode());
        }
        if (CollUtil.isNotEmpty(itemCodes)) {
            String itemCodeStr = String.join((CharSequence)",", itemCodes);
            throw new BusinessException("\u8bf7\u914d\u7f6e\u5546\u54c1\u3010" + itemCodeStr + "\u3011\u7ed3\u7b97\u4ef7\u683c\u4fe1\u606f");
        }
        return result;
    }

    private OrgStoreBaseRpcDTO getOrgStore(String type, String demandWhStCode) {
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type)) {
            return Optional.ofNullable(this.rmiOrgStoreRpcService.getOrgStoreBase(demandWhStCode)).orElseThrow(() -> new BusinessException("\u95e8\u5e97\u7f16\u7801\uff1a" + demandWhStCode + "\u4e0d\u5b58\u5728"));
        }
        return new OrgStoreBaseRpcDTO();
    }

    private Map<String, List<ScpWhNetRelationRpcDTO>> findNewWhNetByParam(String demandWhStCode, String type, List<AppItmItemPageVO> storeCartDOS) {
        HashMap<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap = new HashMap<String, List<ScpWhNetRelationRpcDTO>>();
        ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam = new ScpWhNetRelationRpcDtoParam();
        scpWhNetRelationRpcDtoParam.setType(type);
        scpWhNetRelationRpcDtoParam.setDemandWhStCode(demandWhStCode);
        scpWhNetRelationRpcDtoParam.setValidDate(LocalDateTime.now());
        List<ScpWhNetRelationRpcDTO> relationList = this.scpWhNetRelationService.findWhNetRelationRpcDtoByParam(scpWhNetRelationRpcDtoParam);
        for (AppItmItemPageVO cartDO : storeCartDOS) {
            List itemCodeResults = relationList.stream().filter(row -> cartDO.getItemCode().equals(row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCodeResults)) {
                if (itemCodeResults.size() > 1) {
                    itemCodeResults = itemCodeResults.subList(0, 1);
                }
                whNetRelationMap.put(cartDO.getItemCode(), itemCodeResults);
                continue;
            }
            List resultList = relationList.stream().filter(row -> StringUtils.isBlank((String)row.getItemCode()) && Objects.equals(cartDO.getItemType2(), row.getDeliveryType())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(resultList)) continue;
            if (resultList.size() > 1) {
                resultList = resultList.subList(0, 1);
            }
            whNetRelationMap.put(cartDO.getItemCode(), resultList);
        }
        return whNetRelationMap;
    }

    @Override
    public List<ScpDemandOrderDRespVO> whnetStrategy(ScpDemandOrderItemParamVO paramVO, OrgStoreBaseRpcDTO orgStore, ScpOrderSettingRespVO orderSetting) {
        ArrayList<ScpDemandOrderDRespVO> result = new ArrayList<ScpDemandOrderDRespVO>();
        AppItemPageParamVO itemParam = new AppItemPageParamVO();
        BeanUtils.copyProperties((Object)paramVO, (Object)itemParam, (String[])new String[0]);
        itemParam.setStoreCode(orgStore.getStoreCode());
        Long count = this.scpCateItemRepoProc.countAppItemAndWhNetSku(itemParam);
        if (count == 0L) {
            return new ArrayList<ScpDemandOrderDRespVO>();
        }
        List<AppItmItemPageVO> itemList = this.scpCateItemRepoProc.pageAppItemAndWhNetSku(itemParam);
        if (CollUtil.isNotEmpty(itemList)) {
            AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
            CopyOnWriteArrayList appItemActivityItemPriceParamVOS = CollUtil.newCopyOnWriteArrayList(new ArrayList());
            itemList.forEach(row -> {
                AppItemActivityItemPriceParamVO appItemActivityItemPriceParamVO = new AppItemActivityItemPriceParamVO();
                appItemActivityItemPriceParamVO.setStoreCode(orgStore.getStoreCode());
                appItemActivityItemPriceParamVO.setItemCode(row.getItemCode());
                appItemActivityItemPriceParamVO.setItemCateCode(row.getItemCateCode());
                appItemActivityItemPriceParamVO.setUom(paramVO.getUom2());
                appItemActivityItemPriceParamVO.setDeliveryType(row.getItemType2());
                appItemActivityItemPriceParamVO.setItemId(row.getItemId());
                appItemActivityItemPriceParamVO.setItemType2(row.getItemType2());
                appItemActivityItemPriceParamVOS.add(appItemActivityItemPriceParamVO);
            });
            Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.findNewWhNetByParam(paramVO.getDemandWhStCode(), paramVO.getType(), itemList);
            log.info("\u5546\u54c1\u7f16\u7801\uff1a{},\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u4fe1\u606f\uff1a{}", (Object)paramVO.getItemCode(), (Object)JSONUtil.toJsonStr(whNetMap));
            Map<String, AppItemPriceRespVO> priceMap = this.commonPriceService.getNewPriceAndStockDetails(appItemActivityItemPriceParamVOS, orgStore.getStoreCode(), orderSetting, paramVO.getType(), stockMapRef);
            Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap = this.getSkuImgMap(List.of(paramVO.fetchImageId()));
            int size = itemList.size();
            BigDecimal sum = BigDecimal.ZERO;
            for (int i = 0; i < size; ++i) {
                AppItmItemPageVO appItmItemPageVO = itemList.get(i);
                List<ScpWhNetRelationRpcDTO> scpWhNetRelationRpcDTOS = whNetMap.get(appItmItemPageVO.getItemCode());
                if (CollUtil.isEmpty(scpWhNetRelationRpcDTOS)) continue;
                ScpDemandOrderDRespVO scpDemandOrderDRespVO = this.buildScpDemandOrderDRespVOByWhNetRelate(paramVO, scpWhNetRelationRpcDTOS, priceMap, skuImgMap);
                if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(paramVO.getType()) && orgStore.getFreightFlag().booleanValue() && orderSetting.getWhnetFreightFlag().booleanValue()) {
                    scpDemandOrderDRespVO.setFreightFlag(Boolean.TRUE);
                    scpDemandOrderDRespVO.setFreightRatio(orgStore.getFreightRatio());
                } else {
                    scpDemandOrderDRespVO.setFreightFlag(Boolean.FALSE);
                    scpDemandOrderDRespVO.setFreightRatio(BigDecimal.ZERO);
                }
                if (scpDemandOrderDRespVO.getDemandQuantity() == null) {
                    result.add(scpDemandOrderDRespVO);
                    continue;
                }
                BigDecimal ratioQty = scpDemandOrderDRespVO.getDemandQuantity().multiply(scpDemandOrderDRespVO.getRatio()).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_DOWN);
                scpDemandOrderDRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
                result.add(scpDemandOrderDRespVO);
            }
            return result;
        }
        return new ArrayList<ScpDemandOrderDRespVO>();
    }

    @Override
    public List<ScpDemandOrderDRespVO> whnetStrategy(List<ScpDemandOrderItemParamVO> paramVOList, OrgStoreBaseRpcDTO orgStore, ScpOrderSettingRespVO orderSetting) {
        ArrayList<ScpDemandOrderDRespVO> result = new ArrayList<ScpDemandOrderDRespVO>();
        Map paramVOMap = paramVOList.stream().collect(Collectors.toMap(ScpDemandOrderItemParamVO::getItemCode, Function.identity(), (k1, k2) -> k1));
        List<String> itemCodeList = paramVOList.stream().map(ScpDemandOrderItemParamVO::getItemCode).collect(Collectors.toList());
        ScpDemandOrderItemParamVO paramVO = paramVOList.get(0);
        AppItemPageParamVO itemParam = new AppItemPageParamVO();
        itemParam.setItemCodes(itemCodeList);
        itemParam.setStoreCode(orgStore.getStoreCode());
        Long count = this.scpCateItemRepoProc.countAppItemAndWhNetSku(itemParam);
        if (count == 0L) {
            return new ArrayList<ScpDemandOrderDRespVO>();
        }
        List<AppItmItemPageVO> itemList = this.scpCateItemRepoProc.pageAppItemAndWhNetSku(itemParam);
        if (CollUtil.isNotEmpty(itemList)) {
            AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
            CopyOnWriteArrayList appItemActivityItemPriceParamVOS = CollUtil.newCopyOnWriteArrayList(new ArrayList());
            itemList.forEach(row -> {
                ScpDemandOrderItemParamVO scpDemandOrderItemParamVO = (ScpDemandOrderItemParamVO)paramVOMap.get(row.getItemCode());
                AppItemActivityItemPriceParamVO appItemActivityItemPriceParamVO = new AppItemActivityItemPriceParamVO();
                appItemActivityItemPriceParamVO.setStoreCode(orgStore.getStoreCode());
                appItemActivityItemPriceParamVO.setItemCode(row.getItemCode());
                appItemActivityItemPriceParamVO.setItemCateCode(row.getItemCateCode());
                appItemActivityItemPriceParamVO.setUom(scpDemandOrderItemParamVO.getUom2());
                appItemActivityItemPriceParamVO.setDeliveryType(row.getItemType2());
                appItemActivityItemPriceParamVO.setItemId(row.getItemId());
                appItemActivityItemPriceParamVO.setItemType2(row.getItemType2());
                appItemActivityItemPriceParamVOS.add(appItemActivityItemPriceParamVO);
            });
            Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.findNewWhNetByParam(orgStore.getStoreCode(), paramVO.getType(), itemList);
            log.info("\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u4fe1\u606f\uff1a{}", (Object)JSONUtil.toJsonStr(whNetMap));
            Map<String, AppItemPriceRespVO> priceMap = this.commonPriceService.getNewPriceAndStockDetails(appItemActivityItemPriceParamVOS, orgStore.getStoreCode(), orderSetting, paramVO.getType(), stockMapRef);
            List<Long> fetchImageIdList = paramVOList.stream().map(ScpDemandOrderItemParamVO::fetchImageId).collect(Collectors.toList());
            Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap = this.getSkuImgMap(fetchImageIdList);
            for (AppItmItemPageVO appItmItemPageVO : itemList) {
                List<ScpWhNetRelationRpcDTO> scpWhNetRelationRpcDTOS = whNetMap.get(appItmItemPageVO.getItemCode());
                if (CollUtil.isEmpty(scpWhNetRelationRpcDTOS)) continue;
                ScpDemandOrderItemParamVO scpDemandOrderItemParamVO = (ScpDemandOrderItemParamVO)paramVOMap.get(appItmItemPageVO.getItemCode());
                ScpDemandOrderDRespVO scpDemandOrderDRespVO = this.buildScpDemandOrderDRespVOByWhNetRelate(scpDemandOrderItemParamVO, scpWhNetRelationRpcDTOS, priceMap, skuImgMap);
                if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(scpDemandOrderItemParamVO.getType()) && orgStore.getFreightFlag().booleanValue() && orderSetting.getWhnetFreightFlag().booleanValue()) {
                    scpDemandOrderDRespVO.setFreightFlag(Boolean.TRUE);
                    scpDemandOrderDRespVO.setFreightRatio(orgStore.getFreightRatio());
                } else {
                    scpDemandOrderDRespVO.setFreightFlag(Boolean.FALSE);
                    scpDemandOrderDRespVO.setFreightRatio(BigDecimal.ZERO);
                }
                if (scpDemandOrderDRespVO.getDemandQuantity() == null) {
                    result.add(scpDemandOrderDRespVO);
                    continue;
                }
                BigDecimal ratioQty = scpDemandOrderDRespVO.getDemandQuantity().multiply(scpDemandOrderDRespVO.getRatio()).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_DOWN);
                scpDemandOrderDRespVO.setAllocationDeQuantity(ratioQty);
                result.add(scpDemandOrderDRespVO);
            }
            return result;
        }
        return new ArrayList<ScpDemandOrderDRespVO>();
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandOrderExportRespVO> executeExport(ScpDemandOrderPageParamVO queryParamVO) {
        return this.scpDemandOrderDomainService.executeExport(queryParamVO);
    }

    private List<ScpDemandOrderDRespVO> suppAllocStrategy(ScpDemandOrderItemParamVO paramVO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag) {
        ArrayList<ScpDemandOrderDRespVO> result = new ArrayList<ScpDemandOrderDRespVO>();
        ScpSupplyAllocationRpcDtoParam supAllocParam = new ScpSupplyAllocationRpcDtoParam();
        supAllocParam.setItemCode(paramVO.getItemCode());
        supAllocParam.setType(paramVO.getType());
        supAllocParam.setValidDate(paramVO.getDemandDate());
        supAllocParam.setStoreWhCode(paramVO.getDemandWhStCode());
        List<ScpSupplyAllocationRpcDTO> suppAllocList = this.scpSupplyAllocationService.findSupplyAllocationRpcByParam(supAllocParam);
        log.info("\u4f9b\u5e94\u5546\u914d\u989d\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(suppAllocList));
        if (CollUtil.isEmpty(suppAllocList)) {
            return new ArrayList<ScpDemandOrderDRespVO>();
        }
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        for (ScpSupplyAllocationRpcDTO row : suppAllocList) {
            if (StrUtil.isBlank((CharSequence)row.getSaleOuCode())) continue;
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setItemId(paramVO.getItemId());
            priceParam.setCustCode(row.getSaleCustCode());
            priceParam.setItemCode(paramVO.getItemCode());
            priceParam.setUom(paramVO.getUnit());
            priceParam.setCurrCode("CNY");
            priceParam.setOuCode(row.getSaleOuCode());
            priceParamList.add(priceParam);
        }
        Map<String, List<PriPriceRpcDTO>> priceMap = this.getSalePriceMap(priceParamList, paramVO);
        Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap = this.getSkuImgMap(List.of(paramVO.fetchImageId()));
        Map<String, Object> purOuInfo = this.getPurOuInfo(paramVO.getType(), orgStore, paramVO.getDemandWhStCode());
        int size = suppAllocList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            ScpDemandOrderDRespVO scpDemandOrderDRespVO = this.buildScpDemandOrderDRespVOBySupplyAlloc(paramVO, suppAllocList.get(i), priceMap, purOuInfo, skuImgMap);
            if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(paramVO.getType()) && orgStore.getFreightFlag2().booleanValue() && freightFlag.booleanValue()) {
                scpDemandOrderDRespVO.setFreightFlag(Boolean.TRUE);
                scpDemandOrderDRespVO.setFreightRatio(orgStore.getFreightRatio2());
            } else {
                scpDemandOrderDRespVO.setFreightFlag(Boolean.FALSE);
                scpDemandOrderDRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (scpDemandOrderDRespVO.getDemandQuantity() == null) {
                result.add(scpDemandOrderDRespVO);
                continue;
            }
            if (i == size - 1) {
                scpDemandOrderDRespVO.setAllocationDeQuantity(scpDemandOrderDRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = scpDemandOrderDRespVO.getDemandQuantity().multiply(scpDemandOrderDRespVO.getRatio()).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_DOWN);
                scpDemandOrderDRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(scpDemandOrderDRespVO);
        }
        return result;
    }

    private Map<Long, List<ItmItemAttachmentProviderDTO>> getSkuImgMap(List<Long> fetchImageIds) {
        List<ItmItemAttachmentProviderDTO> skuImgList = this.rmiItemService.findSkuImgByItemIds(fetchImageIds);
        if (CollUtil.isNotEmpty(skuImgList)) {
            return skuImgList.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
        }
        return new HashMap<Long, List<ItmItemAttachmentProviderDTO>>();
    }

    private Map<String, List<PriPriceRpcDTO>> getSalePriceMap(List<ItmPriPriceRpcDtoParam> priceParamList, ScpDemandOrderItemParamVO paramVO) {
        if (CollUtil.isEmpty(priceParamList)) {
            return new HashMap<String, List<PriPriceRpcDTO>>();
        }
        List<PriPriceRpcDTO> priceByParam = this.rmiPriceRpcService.findPriceByParam(priceParamList);
        if (CollUtil.isEmpty(priceByParam)) {
            this.getBasePrice(priceParamList, priceByParam);
        }
        Map<String, List<PriPriceRpcDTO>> priceMap = priceByParam.stream().collect(Collectors.groupingBy(data -> data.getItemCode() + "@" + data.getOuCode()));
        log.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(priceMap));
        return priceMap;
    }

    @Override
    @SysCodeProc
    public Map<String, List<ScpDemandOrderDRespVO>> getItemListBatch(ScpDemandOrderItemBatchParamVO paramVO) {
        log.info("\u6279\u91cf\u83b7\u53d6\u5546\u54c1\u660e\u7ec6\u884c\u4fe1\u606f\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        String demandWhStCode = paramVO.getDemandWhStCode();
        OrgStoreBaseRpcDTO orgStore = this.getOrgStore(paramVO.getType(), paramVO.getDemandWhStCode());
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(paramVO.getBusinessType(), paramVO.getType());
        if (orderSetting == null) {
            throw new BusinessException("\u8bf7\u5148\u914d\u7f6e\u6216\u542f\u7528\u5355\u636e\u7c7b\u578b:" + paramVO.getDocType());
        }
        List<ScpDemandOrderItemBatchParamVO.Item> itemList = paramVO.getItemList();
        List<ScpStoreCartDO> dataList = itemList.stream().map(row -> {
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setItemCode(row.getItemCode());
            storeCartDO.setItemCateCode(row.getItemCateCode());
            storeCartDO.setUom(row.getUom());
            return storeCartDO;
        }).collect(Collectors.toList());
        List<String> itemCodes = itemList.stream().map(ScpDemandOrderItemBatchParamVO.Item::getItemCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.scpWhNetRelationService.findNewWhNetByParam(demandWhStCode, paramVO.getType(), dataList);
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = this.scpSupplyAllocationService.findSupplyAllocationByParam(demandWhStCode, paramVO.getType(), itemCodes);
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        ArrayList confirmRespVOS = new ArrayList();
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
        block0: for (ScpDemandOrderItemBatchParamVO.Item item2 : itemList) {
            ArrayList<ScpDemandOrderDRespVO> inConfirmList = new ArrayList<ScpDemandOrderDRespVO>();
            for (String priority : priorities) {
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    inConfirmList.addAll(this.suppAllocStrategy(item2, orgStore, orderSetting.getSuppFreightFlag(), supplyAllocationMap, priceParamList, paramVO.getType(), stockMapRef));
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    inConfirmList.addAll(this.whnetStrategy(item2, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList, paramVO.getType()));
                }
                if (inConfirmList.isEmpty()) continue;
                confirmRespVOS.addAll(inConfirmList);
                continue block0;
            }
        }
        List<PriPriceRpcDTO> priceList = this.rmiPriceRpcService.findPriceByParam(priceParamList);
        Map<String, List<PriPriceRpcDTO>> priceMap = this.buildPriceMap(priceList, priceParamList);
        List<Long> imgIds = confirmRespVOS.stream().map(ScpDemandOrderDRespVO::fetchImageId).distinct().collect(Collectors.toList());
        Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap = this.getSkuImgMap(imgIds);
        Map<String, List<ScpDemandOrderDRespVO>> resultMap = confirmRespVOS.stream().map(item -> {
            if (priceMap.containsKey(item.getItemCode() + "@" + item.getSaleOuCode())) {
                item.setPrice(((PriPriceRpcDTO)((List)priceMap.get(item.getItemCode() + "@" + item.getSaleOuCode())).get(0)).getPrice());
            }
            item.setPlanQuantity(item.getDemandQuantity());
            if (item.getPrice() != null) {
                item.setPlanAmt(SysUtils.processAmtScale(item.getPrice().multiply(item.getPlanQuantity())));
            }
            if (skuImgMap.containsKey(item.fetchImageId())) {
                List v = (List)skuImgMap.get(item.fetchImageId());
                ItmItemAttachmentProviderDTO itmItemAttachmentProviderDTO = v.stream().filter(i -> i.getMajor() != null && i.getMajor() != false).findFirst().orElseGet(() -> null);
                if (itmItemAttachmentProviderDTO == null) {
                    itmItemAttachmentProviderDTO = (ItmItemAttachmentProviderDTO)v.get(0);
                }
                item.setImgUrl(itmItemAttachmentProviderDTO.getUrl());
            }
            return item;
        }).collect(Collectors.groupingBy(ScpDemandOrderDRespVO::getItemCode));
        log.info("\u6279\u91cf\u83b7\u53d6\u5546\u54c1\u660e\u7ec6\u884c\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(resultMap));
        return resultMap;
    }

    private Map<String, List<PriPriceRpcDTO>> buildPriceMap(List<PriPriceRpcDTO> priceList, List<ItmPriPriceRpcDtoParam> priceParamList) {
        if (CollUtil.isEmpty(priceList)) {
            this.getBasePrice(priceParamList, priceList);
            if (CollUtil.isEmpty(priceList)) {
                return new HashMap<String, List<PriPriceRpcDTO>>();
            }
        } else {
            Map<String, List<PriPriceRpcDTO>> inPriceMap = priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
            priceParamList.removeAll(priceParamList.stream().filter(row -> inPriceMap.containsKey(row.getItemCode())).collect(Collectors.toList()));
            this.getBasePrice(priceParamList, priceList);
        }
        return priceList.stream().collect(Collectors.groupingBy(row -> row.getItemCode() + "@" + row.getOuCode()));
    }

    private void getBasePrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList) {
        if (CollUtil.isEmpty(priceParamList)) {
            return;
        }
        List<Long> itemIds = priceParamList.stream().map(ItmPriPriceRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemSimpleRpcDTO> simpleItemMap = this.rmiItemService.findBaseItemMap(itemIds);
        List<ItmPriPriceRpcDtoParam> baseUomList = priceParamList.stream().map(row -> {
            ItmPriPriceRpcDtoParam param = (ItmPriPriceRpcDtoParam)BeanUtils.copyProperties((Object)row, ItmPriPriceRpcDtoParam.class, (String[])new String[0]);
            ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
            param.setUom(simpleItem.getUom());
            return param;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> basePriceList = this.rmiPriceRpcService.findPriceByParam(baseUomList);
        log.info("\u67e5\u8be2\u57fa\u672c\u5355\u4f4d\u4ef7\u683c:{}", (Object)JSONUtil.toJsonStr(basePriceList));
        if (CollUtil.isNotEmpty(basePriceList)) {
            List resultPriceList = basePriceList.stream().map(row -> {
                PriPriceRpcDTO priPriceRpcDTO = (PriPriceRpcDTO)BeanUtils.copyProperties((Object)row, PriPriceRpcDTO.class, (String[])new String[0]);
                ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
                if (simpleItem.getUomRatio2() == null) {
                    return null;
                }
                if (simpleItem.getDecimalPlaces() != null) {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()).setScale((int)simpleItem.getDecimalPlaces(), 4));
                } else {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()));
                }
                return priPriceRpcDTO;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            priceList.addAll(resultPriceList);
        }
    }

    private List<ScpDemandOrderDRespVO> suppAllocStrategy(ScpDemandOrderItemBatchParamVO.Item cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap, List<ItmPriPriceRpcDtoParam> priceParamList, String type, AtomicReference<Map<String, BigDecimal>> stockMap) {
        ArrayList<ScpDemandOrderDRespVO> result = new ArrayList<ScpDemandOrderDRespVO>();
        List<ScpSupplyAllocationRpcDTO> suppAllocList = supplyAllocationMap.get(cartDO.getItemCode());
        log.info("\u4f9b\u5e94\u5546\u914d\u989d\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(suppAllocList));
        if (CollUtil.isEmpty(suppAllocList)) {
            return new ArrayList<ScpDemandOrderDRespVO>();
        }
        for (ScpSupplyAllocationRpcDTO row : suppAllocList) {
            if (StrUtil.isBlank((CharSequence)row.getSaleOuCode())) continue;
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getSaleCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode("CNY");
            priceParam.setOuCode(row.getSaleOuCode());
            priceParamList.add(priceParam);
        }
        int size = suppAllocList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            ScpSupplyAllocationRpcDTO row = suppAllocList.get(i);
            ScpDemandOrderDRespVO orderConfirmRespVO = new ScpDemandOrderDRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuItemCode(cartDO.getSpuItemCode());
            orderConfirmRespVO.setSpuItemName(cartDO.getSpuItemName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSuppId());
            orderConfirmRespVO.setSuppWhCode(row.getSuppCode());
            orderConfirmRespVO.setSuppWhName(row.getSuppName());
            orderConfirmRespVO.setRatio(row.getAllocation());
            orderConfirmRespVO.setCurrency("CNY");
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode());
            orderConfirmRespVO.setSaleOuCode(row.getSaleOuCode());
            orderConfirmRespVO.setSaleOuName(row.getSaleOuName());
            orderConfirmRespVO.setSaleCustCode(row.getSaleCustCode());
            orderConfirmRespVO.setOuId(row.getOuId());
            orderConfirmRespVO.setOuCode(row.getOuCode());
            orderConfirmRespVO.setOuName(row.getOuName());
            orderConfirmRespVO.setDemandQuantity(cartDO.getDemandQuantity());
            orderConfirmRespVO.setItemType(cartDO.getItemType());
            orderConfirmRespVO.setQty2(cartDO.getQty2());
            orderConfirmRespVO.setUom2(cartDO.getUom2());
            orderConfirmRespVO.setUom2Name(cartDO.getUom2Name());
            orderConfirmRespVO.setDecimalPlaces(cartDO.getDecimalPlaces());
            orderConfirmRespVO.setUomRatio(cartDO.getUomRatio());
            orderConfirmRespVO.setIsCalculated(Boolean.FALSE);
            orderConfirmRespVO.setIsPushed(Boolean.FALSE);
            orderConfirmRespVO.setImgUrl(cartDO.getUrl());
            orderConfirmRespVO.setMinNum(cartDO.getDemandQuantity());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(cartDO.getItemCode(), new BigDecimal("9999"));
                return currentMap;
            });
            if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type) && orgStore.getFreightFlag2().booleanValue() && freightFlag.booleanValue()) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio2());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;
    }

    private List<ScpDemandOrderDRespVO> whnetStrategy(ScpDemandOrderItemBatchParamVO.Item cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap, List<ItmPriPriceRpcDtoParam> priceParamList, String type) {
        ArrayList<ScpDemandOrderDRespVO> result = new ArrayList<ScpDemandOrderDRespVO>();
        List<ScpWhNetRelationRpcDTO> whNetRelationRpcDTOList = whNetRelationMap.get(cartDO.getItemCode());
        log.info("\u5546\u54c1\u7f16\u7801\uff1a{},\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u4fe1\u606f\uff1a{}", (Object)cartDO.getItemCode(), (Object)JSONUtil.toJsonStr(whNetRelationRpcDTOList));
        if (CollUtil.isEmpty(whNetRelationRpcDTOList)) {
            return new ArrayList<ScpDemandOrderDRespVO>();
        }
        for (ScpWhNetRelationRpcDTO row : whNetRelationRpcDTOList) {
            if (StrUtil.isBlank((CharSequence)row.getOuCode())) continue;
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode("CNY");
            priceParam.setOuCode(row.getOuCode());
            priceParamList.add(priceParam);
        }
        int size = whNetRelationRpcDTOList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            ScpWhNetRelationRpcDTO row = whNetRelationRpcDTOList.get(i);
            ScpDemandOrderDRespVO orderConfirmRespVO = new ScpDemandOrderDRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuItemCode(cartDO.getSpuItemCode());
            orderConfirmRespVO.setSpuItemName(cartDO.getSpuItemName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSupplyWhId());
            orderConfirmRespVO.setSuppWhCode(row.getSupplyWhCode());
            orderConfirmRespVO.setSuppWhName(row.getSupplyWhName());
            orderConfirmRespVO.setRatio(row.getSupplyPercentage());
            orderConfirmRespVO.setCurrency("CNY");
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode());
            orderConfirmRespVO.setDemandQuantity(cartDO.getDemandQuantity());
            orderConfirmRespVO.setSaleOuName(row.getOuName());
            orderConfirmRespVO.setSaleOuCode(row.getOuCode());
            orderConfirmRespVO.setSaleCustCode(row.getCustCode());
            orderConfirmRespVO.setItemType(cartDO.getItemType());
            orderConfirmRespVO.setQty2(cartDO.getQty2());
            orderConfirmRespVO.setUom2(cartDO.getUom2());
            orderConfirmRespVO.setUom2Name(cartDO.getUom2Name());
            orderConfirmRespVO.setDecimalPlaces(cartDO.getDecimalPlaces());
            orderConfirmRespVO.setUomRatio(cartDO.getUomRatio());
            orderConfirmRespVO.setIsCalculated(Boolean.FALSE);
            orderConfirmRespVO.setIsPushed(Boolean.FALSE);
            orderConfirmRespVO.setImgUrl(cartDO.getUrl());
            orderConfirmRespVO.setMinNum(cartDO.getDemandQuantity());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type) && orgStore.getFreightFlag().booleanValue() && freightFlag.booleanValue()) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;
    }

    private Map<String, Object> getPurOuInfo(String type, OrgStoreBaseRpcDTO orgStore, String demandWhStCode) {
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type)) {
            return Map.of("ouId", orgStore.getOuId(), "ouCode", orgStore.getOuCode(), "ouName", orgStore.getOuName());
        }
        if (ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(type)) {
            Map<String, InvWhRpcSimpleDTO> whDtoMap = this.rmiInvStkService.findInvWhBaseMapByCode(List.of(demandWhStCode));
            InvWhRpcSimpleDTO invWhRpcDTO = whDtoMap.get(demandWhStCode);
            Map<Long, OrgOuRpcSimpleDTO> ouDtoMap = this.rmiOrgOuService.findOuDtoMap(List.of(invWhRpcDTO.getOuId()));
            return Map.of("ouId", invWhRpcDTO.getOuId(), "ouCode", invWhRpcDTO.getOuCode(), "ouName", ouDtoMap.get(invWhRpcDTO.getOuId()).getOuName());
        }
        return new HashMap<String, Object>();
    }

    private ScpDemandOrderDRespVO buildScpDemandOrderDRespVOByWhNetRelate(ScpDemandOrderItemParamVO paramVO, List<ScpWhNetRelationRpcDTO> rowList, Map<String, AppItemPriceRespVO> priceMap, Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap) {
        AppItemPriceRespVO priceRpcDTOS;
        ScpDemandOrderDRespVO item = new ScpDemandOrderDRespVO();
        item.setItemId(paramVO.getItemId());
        item.setItemCode(paramVO.getItemCode());
        item.setItemName(paramVO.getItemName());
        item.setSpuItemCode(paramVO.getSpuItemCode());
        item.setSpuItemName(paramVO.getSpuItemName());
        item.setUnitName(paramVO.getUnitName());
        item.setUnit(paramVO.getUnit());
        item.setCurrency("CNY");
        item.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode());
        item.setUom2(paramVO.getUom2());
        item.setUom2Name(paramVO.getUom2Name());
        item.setUomRatio(paramVO.getUomRatio());
        item.setDecimalPlaces(paramVO.getDecimalPlaces());
        item.setIsPushed(Boolean.FALSE);
        item.setIsCalculated(Boolean.FALSE);
        item.setDemandQuantity(paramVO.getDemandQuantity());
        item.setItemType(paramVO.getItemType());
        item.setDeliveryType(paramVO.getItemType());
        if (skuImgMap.containsKey(paramVO.fetchImageId())) {
            List<ItmItemAttachmentProviderDTO> v = skuImgMap.get(paramVO.fetchImageId());
            ItmItemAttachmentProviderDTO itmItemAttachmentProviderDTO = v.stream().filter(i -> i.getMajor() != null && i.getMajor() != false).findFirst().orElseGet(() -> null);
            if (itmItemAttachmentProviderDTO == null) {
                itmItemAttachmentProviderDTO = v.get(0);
            }
            String fileUrl = this.serverAddr + "/coordinator/el-fsm-service/api/fsm/download/" + itmItemAttachmentProviderDTO.getFileCode();
            item.setImgUrl(fileUrl);
        }
        if (CollUtil.isNotEmpty(rowList)) {
            ScpWhNetRelationRpcDTO row = rowList.get(0);
            item.setDeliveryType(row.getDeliveryType());
            item.setSuppWhId(row.getSupplyWhId());
            item.setSuppWhCode(row.getSupplyWhCode());
            item.setSuppWhName(row.getSupplyWhName());
            item.setRatio(row.getSupplyPercentage());
            item.setSaleOuName(row.getOuName());
            item.setSaleOuCode(row.getOuCode());
            item.setSaleCustCode(row.getCustCode());
            item.setOuCode(row.getPurCompanyCode());
            item.setOuName(row.getPurCompanyName());
        }
        if ((priceRpcDTOS = priceMap.get(item.getItemCode())) != null) {
            item.setPrice(priceRpcDTOS.getPrice());
            item.setSettlementPrice(priceRpcDTOS.getPrice());
            item.setSuppId(priceRpcDTOS.getSuppId());
            item.setSuppCode(priceRpcDTOS.getSuppCode());
            item.setSuppName(priceRpcDTOS.getSuppName());
            item.setCostPrice(priceRpcDTOS.getCostPrice());
            item.setPurPrice(priceRpcDTOS.getPurPrice());
            item.setIsProjFeeCharged(priceRpcDTOS.getIsProjFeeCharged());
            item.setOefPrice(priceRpcDTOS.getOefPrice());
            item.setMefPrice(priceRpcDTOS.getMefPrice());
            item.setTefPrice(priceRpcDTOS.getTefPrice());
            item.setSalePrice(priceRpcDTOS.getSalePrice());
            item.setSettlementSalePrice(priceRpcDTOS.getSalePrice());
            item.setTefFeeOuCode(priceRpcDTOS.getTefFeeOuCode());
            item.setTefFeeOuName(priceRpcDTOS.getTefFeeOuName());
            item.setOefFeeOuCode(priceRpcDTOS.getOefFeeOuCode());
            item.setOefFeeOuName(priceRpcDTOS.getOefFeeOuName());
            item.setMefFeeOuCode(priceRpcDTOS.getMefFeeOuCode());
            item.setMefFeeOuName(priceRpcDTOS.getMefFeeOuName());
        }
        return item;
    }

    private ScpDemandOrderDRespVO buildScpDemandOrderDRespVOBySupplyAlloc(ScpDemandOrderItemParamVO paramVO, ScpSupplyAllocationRpcDTO row, Map<String, List<PriPriceRpcDTO>> priceMap, Map<String, Object> purOuInfo, Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap) {
        String ouCode;
        ScpDemandOrderDRespVO item = new ScpDemandOrderDRespVO();
        item.setItemId(paramVO.getItemId());
        item.setItemCode(paramVO.getItemCode());
        item.setItemName(paramVO.getItemName());
        item.setSpuItemCode(paramVO.getSpuItemCode());
        item.setSpuItemName(paramVO.getSpuItemName());
        item.setUnitName(paramVO.getUnitName());
        item.setUnit(paramVO.getUnit());
        item.setSuppWhId(row.getSuppId());
        item.setSuppWhCode(row.getSuppCode());
        item.setSuppWhName(row.getSuppName());
        item.setRatio(row.getAllocation());
        item.setCurrency("CNY");
        item.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode());
        item.setUom2(paramVO.getUom2());
        item.setUom2Name(paramVO.getUom2Name());
        item.setUomRatio(paramVO.getUomRatio());
        item.setDecimalPlaces(paramVO.getDecimalPlaces());
        item.setSaleOuCode(row.getSaleOuCode());
        item.setSaleOuName(row.getSaleOuName());
        item.setSaleCustCode(row.getSaleCustCode());
        item.setItemType(paramVO.getItemType());
        item.setOuId(Optional.ofNullable(row.getOuId()).orElse((Long)purOuInfo.get("ouId")));
        item.setOuCode(Optional.ofNullable(row.getOuCode()).orElse((String)purOuInfo.get("ouCode")));
        item.setOuName(Optional.ofNullable(row.getOuName()).orElse((String)purOuInfo.get("ouName")));
        item.setIsPushed(Boolean.FALSE);
        item.setIsCalculated(Boolean.FALSE);
        item.setDemandQuantity(paramVO.getDemandQuantity());
        if (skuImgMap.containsKey(paramVO.fetchImageId())) {
            List<ItmItemAttachmentProviderDTO> v = skuImgMap.get(paramVO.fetchImageId());
            ItmItemAttachmentProviderDTO itmItemAttachmentProviderDTO = v.stream().filter(i -> i.getMajor() != null && i.getMajor() != false).findFirst().orElseGet(() -> null);
            if (itmItemAttachmentProviderDTO == null) {
                itmItemAttachmentProviderDTO = v.get(0);
            }
            item.setImgUrl(itmItemAttachmentProviderDTO.getUrl());
        }
        if (StrUtil.isBlank((CharSequence)(ouCode = row.getSaleOuCode()))) {
            return item;
        }
        List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(item.getItemCode() + "@" + ouCode);
        if (!CollUtil.isNotEmpty(priceRpcDTOS)) {
            throw new BusinessException("\u5546\u54c1\u7f16\u7801\uff1a" + item.getItemCode() + ",\u516c\u53f8\u7f16\u7801\uff1a" + ouCode + ",\u672a\u914d\u7f6e\u7ed3\u7b97\u4ef7\u683c\u4fe1\u606f");
        }
        item.setPrice(priceRpcDTOS.get(0).getPrice());
        return item;
    }

    @Override
    public void cancelScpDemand(Long id) {
        ScpDemandOrderDTO scpDemandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(id).orElseThrow(new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728"));
        List<String> cancelableStatuses = Arrays.asList(ScpUdcEnum.DEO_STATUS_WT.getValueCode(), ScpUdcEnum.DEO_STATUS_TIMEOUT.getValueCode(), ScpUdcEnum.DEO_STATUS_DOING.getValueCode());
        if (!cancelableStatuses.contains(scpDemandOrderDTO.getDocStatus())) {
            throw new BusinessException("\u5355\u636e\u72b6\u6001\u4e0d\u53ef\u53d6\u6d88");
        }
        List<Long> demandOrderDDTOList = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(id).stream().filter(row -> row.getIsCalculated() == false && row.getIsPushed() == false).map(BaseViewModel::getId).collect(Collectors.toList());
        this.scpDemandOrderDDomainService.deleteByIds(demandOrderDDTOList);
    }

    @Override
    public void compute(Long demandSetId) {
        TimeInterval timer = new TimeInterval();
        log.info("\u3010\u8ba2\u8d27\u96c6\u81ea\u52a8\u8ba1\u7b97\u3011\u8ba2\u8d27\u96c6ID\uff1a{},\u5f00\u59cb\u914d\u8d27", (Object)demandSetId);
        String redisKey = "ORDER_COMPUTE@".concat(demandSetId.toString());
        if (this.redisTemplate.hasKey((Object)redisKey).booleanValue()) {
            log.info("\u3010order-compute\u3011\u8ba2\u8d27\u96c6ID:{},\u6b63\u5728\u8ba1\u7b97\u4e2d...");
            return;
        }
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)"ORDER_COMPUTE", 300L, TimeUnit.SECONDS);
        try {
            Long orderCount = this.scpDemandOrderDomainService.countDemandOrderByDemandIds(List.of(demandSetId));
            if (orderCount == 0L) {
                log.info("\u3010\u8ba2\u8d27\u96c6\u81ea\u52a8\u8ba1\u7b97\u3011\u8ba2\u8d27\u96c6ID\uff1a{}\uff0c\u65e0\u8ba2\u8d27\u5355\u4fe1\u606f", (Object)demandSetId);
                this.scpDemandSetDomainService.updateDemandSetMsgByIds(List.of(demandSetId), "\u65e0\u9700\u8ba1\u7b97");
                return;
            }
            ScpDemandSetDTO scpDemandSetDTO = this.scpDemandSetDomainService.findDemandSetById(demandSetId).get();
            if (scpDemandSetDTO == null) {
                log.info("\u3010\u8ba2\u8d27\u96c6\u81ea\u52a8\u8ba1\u7b97\u3011\u8ba2\u8d27\u96c6\uff1a{}\uff0c\u67e5\u8be2\u4e3a\u7a7a", (Object)demandSetId);
                return;
            }
            SysSettingVO sysSetting = this.rmiSysSettingService.findSysSettingByNo("ALLOC_COMPUTE_CONFIG");
            SysSettingVO stkSetting = this.rmiSysSettingService.findSysSettingByNo("ORDER_PRODUCT_STATUS_VALUE");
            String allocComputeConfig = sysSetting == null ? "0" : sysSetting.getSettingVal();
            String stkStatusConfig = stkSetting == null ? "1" : stkSetting.getSettingVal();
            Integer totalPage = PageUtil.totalPage((long)orderCount, (int)500);
            for (int i = 1; i <= totalPage; ++i) {
                ScpComputeDemandOrderPageParamVO pageParamVO = new ScpComputeDemandOrderPageParamVO();
                pageParamVO.setDemandId(demandSetId);
                pageParamVO.setSize(500);
                pageParamVO.setCurrent(i);
                ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
                OrderItem orderItem = new OrderItem();
                orderItem.setAsc(false);
                orderItem.setColumn("storeLevel");
                orders.add(orderItem);
                pageParamVO.setOrders(orders);
                List<Long> ids = this.scpDemandOrderDomainService.pageDemandOrderIds(pageParamVO);
                String checkMsg = this.checkTransactionPathAndPoPrice(demandSetId, ids, scpDemandSetDTO);
                if (StrUtil.isNotBlank((CharSequence)checkMsg)) {
                    this.scpDemandSetDomainService.updateDemandSetMsgByIds(List.of(demandSetId), checkMsg);
                    continue;
                }
                this.scpDemandOrderDDomainService.updateSuppAllocPlanQty(demandSetId);
                List<ScpDemandOrderComputeVO> itemAndWhMapList = this.scpDemandOrderDomainService.getItemAndWarehouseByIds(ids);
                HashMap itemStkMap = new HashMap();
                Map<Long, List<ScpDemandOrderComputeVO>> whMap = itemAndWhMapList.stream().collect(Collectors.groupingBy(ScpDemandOrderComputeVO::getSuppWhId));
                whMap.forEach((whId, list) -> {
                    InvStkQueryRpcParam invStkRpcDtoParam = new InvStkQueryRpcParam();
                    invStkRpcDtoParam.setWhIds(List.of(whId));
                    List<String> stkStatusList = "0".equals(stkStatusConfig) ? List.of(ScpUdcEnum.STK_ITM_STATUS_OK.getValueCode()) : List.of(ScpUdcEnum.STK_ITM_STATUS_OK.getValueCode(), ScpUdcEnum.STK_ITM_STATUS_QC.getValueCode(), ScpUdcEnum.STK_ITM_STATUS_PASS.getValueCode());
                    List itemList = list.stream().map(row -> {
                        InvStkItemUomRpcDtoParam invStkItemUomParam = new InvStkItemUomRpcDtoParam();
                        invStkItemUomParam.setItemId(row.getItemId());
                        invStkItemUomParam.setToUom(row.getUnit());
                        return invStkItemUomParam;
                    }).collect(Collectors.toList());
                    invStkRpcDtoParam.setInvStkItemUomParams(itemList);
                    invStkRpcDtoParam.setFilterAvalZero(Boolean.TRUE);
                    invStkRpcDtoParam.setIsSumFlag(Boolean.TRUE);
                    invStkRpcDtoParam.setLimit1s(stkStatusList);
                    List<InvStkQueryRpcResult> invStkRpcDTOList = this.rmiInvStkService.queryInvStk(invStkRpcDtoParam);
                    Map<String, BigDecimal> itemStkQtyMap = invStkRpcDTOList.stream().collect(Collectors.groupingBy(row -> row.getWhCode() + "@" + row.getItemCode(), Collectors.reducing(BigDecimal.ZERO, InvStkQueryRpcResult::getAvalQty, BigDecimal::add)));
                    log.info("\u3010\u8ba2\u8d27\u96c6\u81ea\u52a8\u8ba1\u7b97\u3011\u5e93\u5b58ID\uff1a{},\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff1a{}", whId, (Object)JSONUtil.toJsonStr(itemStkQtyMap));
                    itemStkMap.putAll(itemStkQtyMap);
                });
                Map<String, List<ScpDemandOrderComputeVO>> computeList = itemAndWhMapList.stream().collect(Collectors.groupingBy(row -> row.getSuppWhCode() + "@" + row.getItemCode()));
                computeList.forEach((compute, list) -> {
                    String[] split = compute.split("@");
                    String suppWhCode = split[0];
                    String itemCode = split[1];
                    log.info("\u3010\u8ba2\u8d27\u96c6\u81ea\u52a8\u8ba1\u7b97\u3011\u8ba2\u8d27\u5355\u5206\u914d\u7b97\u6cd5\uff0c\u8ba2\u8d27\u96c6ID: " + demandSetId + ",\u5546\u54c1\u7f16\u7801 " + itemCode + " ,\u4ed3\u5e93\u7f16\u7801: " + suppWhCode);
                    TimeInterval itemTimer = new TimeInterval();
                    BigDecimal orDefault = itemStkMap.getOrDefault(compute, BigDecimal.ZERO);
                    if (orDefault.compareTo(BigDecimal.ZERO) == 0) {
                        log.info("\u3010\u8ba2\u8d27\u96c6\u81ea\u52a8\u8ba1\u7b97\u3011\u5546\u54c1\u7f16\u7801\uff1a{},\u4ed3\u5e93\u7f16\u7801\uff1a{},\u5e93\u5b58\u91cf\u4e3a0", (Object)itemCode, (Object)suppWhCode);
                        return;
                    }
                    String unique = "SCP_COMPUTE@".concat((String)compute);
                    BigDecimal sumAvalQty = this.redisTemplate.opsForValue().get((Object)unique) == null ? orDefault : new BigDecimal((String)this.redisTemplate.opsForValue().get((Object)unique));
                    this.computeAndUpdateAllocation(unique, (List<ScpDemandOrderComputeVO>)list, sumAvalQty, allocComputeConfig);
                    log.info("\u3010\u8ba2\u8d27\u96c6\u81ea\u52a8\u8ba1\u7b97\u3011\u8ba2\u8d27\u96c6ID\uff1a{},\u5546\u54c1\u7f16\u7801\uff1a{},\u5e93\u5b58\uff1a{},\u5206\u914d\u8017\u65f6\uff1a{}", new Object[]{demandSetId, itemCode, suppWhCode, itemTimer.intervalMs()});
                });
            }
            this.delPatternKey(this.redisTemplate, "SCP_COMPUTE@*");
            this.scpDemandSetDomainService.updateDemandSetMsgByIds(List.of(demandSetId), "\u8ba1\u7b97\u5b8c\u6bd5");
            this.scpDemandOrderDomainService.updateAllocStatusByDemandId(demandSetId);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            this.redisTemplate.delete((Object)redisKey);
        }
        log.info("\u3010\u8ba2\u8d27\u96c6\u81ea\u52a8\u8ba1\u7b97\u3011\u8ba2\u8d27\u96c6ID\uff1a{},\u8017\u65f6\uff1a{}", (Object)demandSetId, (Object)timer.intervalMs());
    }

    @Override
    public String pushPo(List<PurPoSaveDTO> storeOrderPoRpcDTOs) {
        List<Long> dIdList = ScpDemandOrderServiceImpl.collectRelateDocDidPo(storeOrderPoRpcDTOs);
        AtomicReference errorLog = new AtomicReference();
        log.info("\u5f00\u59cb\u63a8\u9001\u91c7\u8d2d\u5355,\u53c2\u6570:{},\u660e\u7ec6\u884cid:{}", (Object)JSONUtil.toJsonStr(storeOrderPoRpcDTOs), (Object)JSONUtil.toJsonStr(dIdList));
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(transactionStatus -> {
            try {
                List<PurPoSaveDTO> result = this.rmiPurRpcService.createPo(storeOrderPoRpcDTOs);
                this.scpDemandOrderDDomainService.updateIsPushed(dIdList);
                log.info("\u66f4\u65b0\u660e\u7ec6\u884c\u63a8\u9001\u72b6\u6001\u6210\u529f");
                this.processPoInfoCallback(result);
                this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u6210\u529f");
                log.info("\u66f4\u65b0\u660e\u7ec6\u884c\u540c\u6b65\u6d88\u606f\u6210\u529f");
                return "ok";
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u91c7\u8d2d\u5355\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
                errorLog.set(e.getMessage());
                transactionStatus.setRollbackOnly();
                return "ok";
            }
        });
        List<Long> ids = storeOrderPoRpcDTOs.stream().map(PurPoSaveDTO::getRelateDocId).filter(Objects::nonNull).distinct().toList();
        if (StrUtil.isNotBlank((CharSequence)((CharSequence)errorLog.get()))) {
            this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, StringUtils.substring((String)errorLog.toString(), (int)0, (int)200));
        } else {
            ids.stream().filter(Objects::nonNull).forEach(this.scpDemandOrderDomainService::updatePushStatusById);
        }
        ids.stream().filter(Objects::nonNull).forEach(id -> this.redisTemplate.delete((Object)("PO" + id)));
        if (errorLog.get() != null) {
            return (String)errorLog.get();
        }
        return null;
    }

    @Override
    public String pushTrn(List<StoreOrderTrnRpcDTO> storeOrderTrnRpcDTOs) {
        List<Long> dIdList = ScpDemandOrderServiceImpl.collectRelateDocDid(storeOrderTrnRpcDTOs);
        AtomicReference errorLog = new AtomicReference();
        log.info("\u5f00\u59cb\u63a8\u9001\u8c03\u62e8\u5355,\u53c2\u6570:{},\u660e\u7ec6\u884cid:{}", (Object)JSONUtil.toJsonStr(storeOrderTrnRpcDTOs), (Object)JSONUtil.toJsonStr(dIdList));
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(transactionStatus -> {
            try {
                List result = (List)this.storeOrderTroProvider.generateTro(storeOrderTrnRpcDTOs).computeData();
                this.scpDemandOrderDDomainService.updateIsPushed(dIdList);
                log.info("\u66f4\u65b0\u660e\u7ec6\u884c\u63a8\u9001\u72b6\u6001\u6210\u529f");
                this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u6210\u529f");
                log.info("\u66f4\u65b0\u660e\u7ec6\u884c\u540c\u6b65\u6d88\u606f\u6210\u529f");
                this.processTrnInfoMsg(result);
                return "ok";
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u8c03\u62e8\u5355\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
                errorLog.set(e.getMessage());
                transactionStatus.setRollbackOnly();
                return "ok";
            }
        });
        List<Long> ids = storeOrderTrnRpcDTOs.stream().map(StoreOrderTrnRpcDTO::getRelateDocId).filter(Objects::nonNull).distinct().toList();
        if (StrUtil.isNotBlank((CharSequence)((CharSequence)errorLog.get()))) {
            this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, StringUtils.substring((String)errorLog.toString(), (int)0, (int)200));
        } else {
            ids.stream().filter(Objects::nonNull).forEach(this.scpDemandOrderDomainService::updatePushStatusById);
        }
        ids.stream().filter(Objects::nonNull).forEach(id -> this.redisTemplate.delete((Object)("TRN" + id)));
        if (errorLog.get() != null) {
            return (String)errorLog.get();
        }
        return null;
    }

    @Override
    public void pushSo(List<SalSoSaveDTO> salSoSaveDTOS) {
        for (SalSoSaveDTO salSoSaveDTO : salSoSaveDTOS) {
            List<Long> dIdList = salSoSaveDTO.getSalSoDSaveVOList().stream().map(SalSoDSaveDTO::getRootDocDId).collect(Collectors.toList());
            AtomicReference errorLog = new AtomicReference();
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    log.info("\u3010\u5f00\u59cb\u63a8\u9001\u9500\u552e\u8ba2\u5355\u3011\u521b\u5efa\u9500\u552e\u8ba2\u5355\uff1a{}", (Object)JSONObject.toJSONString((Object)salSoSaveDTO));
                    this.orderRpcService.createSalSo(salSoSaveDTO);
                    this.scpDemandOrderDDomainService.updateIsPushed(dIdList);
                    return "ok";
                }
                catch (Exception e) {
                    log.error("\u9500\u552e\u8ba2\u5355\u521b\u5efa,\u7ebf\u7a0b:{},\u51fa\u9519:{},\u53c2\u6570:{}", new Object[]{Thread.currentThread().getName(), e, JSONObject.toJSONString((Object)salSoSaveDTO)});
                    errorLog.set(e.getMessage());
                    transactionStatus.setRollbackOnly();
                    return "ok";
                }
            });
            if (StrUtil.isNotBlank((CharSequence)((CharSequence)errorLog.get()))) {
                this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, StringUtils.substring((String)errorLog.toString(), (int)0, (int)200));
            } else {
                this.scpDemandOrderDomainService.updatePushStatusById(salSoSaveDTO.getRelateDocId());
            }
            this.redisTemplate.delete((Object)("SO" + salSoSaveDTO.getRelateDocId().toString()));
        }
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderPayInfoRespVO> payInfo(Long id) {
        ScpDemandOrderDTO scpDemandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(id).orElseThrow(() -> new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728"));
        List<String> payStatusList = List.of(ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode(), ScpUdcEnum.PAY_STATUS_PART_PAY.getValueCode(), ScpUdcEnum.PAY_STATUS_PAYING.getValueCode());
        if (!payStatusList.contains(scpDemandOrderDTO.getPayStatus())) {
            throw new BusinessException("\u4ed8\u6b3e\u72b6\u6001\u4e0d\u4e3a\u3010\u5f85\u652f\u4ed8\u3011\u3001\u3010\u652f\u4ed8\u4e2d\u3011\u3001\u3010\u90e8\u5206\u4ed8\u6b3e\u3011");
        }
        return this.scpDemandOrderDDomainService.payInfo(id);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpPayOrderPageRespVO> payPage(ScpDemandOrderPageParamVO paramVO) {
        return this.scpDemandOrderDomainService.payPage(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void close(Long id, String source) {
        ScpDemandOrderDTO scpDemandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(id).orElseThrow(() -> new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728"));
        String payStatus = scpDemandOrderDTO.getPayStatus();
        if (!payStatus.equals(ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode())) {
            throw new BusinessException("\u4ed8\u6b3e\u72b6\u6001\u53ea\u6709\u3010\u5f85\u652f\u4ed8\u3011\u624d\u5141\u8bb8\u53d6\u6d88");
        }
        String userName = "SYSTEM";
        if (!Objects.equals(source, "SYSTEM") && (userName = SecurityContextUtil.currentUserName()) == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        List<ScpDemandOrderDDTO> demandItemList = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        if (CollUtil.isEmpty(demandItemList = demandItemList.stream().filter(d -> !Objects.equals(d.getStatus(), ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode())).toList())) {
            throw new BusinessException("\u6240\u6709\u660e\u7ec6\u884c\u90fd\u5df2\u53d6\u6d88\uff0c\u65e0\u9700\u518d\u53d6\u6d88");
        }
        List<ScpDemandOrderDDO> scpDemandOrderDDOS = this.scpDemandOrderDRepo.findByMasId(id);
        List troDocIds = scpDemandOrderDDOS.stream().filter(d -> "STKTRO".equals(d.getSrcDocCls())).map(ScpDemandOrderDDO::getSrcDocId).distinct().collect(Collectors.toList());
        List poDocIds = scpDemandOrderDDOS.stream().filter(d -> "PO".equals(d.getSrcDocCls())).map(ScpDemandOrderDDO::getSrcDocId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(troDocIds)) {
            this.storeOrderTrnProvider.abortForce(troDocIds).computeData();
        }
        if (CollectionUtils.isNotEmpty(poDocIds)) {
            this.purPoProvider.cancelAndClosePurPo(poDocIds).computeData();
        }
        if (CollectionUtils.isEmpty(troDocIds) && CollectionUtils.isEmpty(poDocIds)) {
            this.scpDemandOrderDomainService.closeDemandOrder(scpDemandOrderDTO.getId(), userName);
        } else {
            this.scpDemandOrderRepo.updateDemandOrderCancelOperator(id, userName);
        }
    }

    @Override
    public void closeOrderByDocNo(String docNo) {
        String docStatus;
        ScpDemandOrderParamVO paramVO = ScpDemandOrderParamVO.builder().docCode(docNo).build();
        List<ScpDemandOrderDTO> demandOrderDTOS = this.scpDemandOrderDomainService.findDemandOrderByParam(paramVO);
        if (CollUtil.isEmpty(demandOrderDTOS)) {
            throw new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728");
        }
        ScpDemandOrderDTO scpDemandOrderDTO = demandOrderDTOS.get(0);
        List<String> docStatusList = List.of(ScpUdcEnum.DEO_STATUS_PART_SHIP.getValueCode(), ScpUdcEnum.DEO_STATUS_SHIP.getValueCode(), ScpUdcEnum.DEO_STATUS_PART_RECV.getValueCode(), ScpUdcEnum.DEO_STATUS_RECV.getValueCode());
        if (docStatusList.contains(docStatus = scpDemandOrderDTO.getDocStatus())) {
            throw new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5141\u8bb8\u5173\u95ed");
        }
        List<ScpDemandOrderRelateDTO> relateOrderList = this.scpDemandOrderDDomainService.findRelateOrderByMasId(scpDemandOrderDTO.getId());
        if (CollUtil.isNotEmpty(relateOrderList)) {
            Map<String, List<ScpDemandOrderRelateDTO>> docMap = relateOrderList.stream().collect(Collectors.groupingBy(ScpDemandOrderRelateDTO::getSrcDocCls));
            for (Map.Entry<String, List<ScpDemandOrderRelateDTO>> entry : docMap.entrySet()) {
                List<Long> ids = entry.getValue().stream().map(ScpDemandOrderRelateDTO::getSrcDocId).collect(Collectors.toList());
                if ("PO".equals(entry.getKey())) {
                    this.rmiPurRpcService.closePo(ids);
                    continue;
                }
                this.rmiInvStkService.closeTro(ids);
            }
        }
        this.scpDemandOrderDomainService.closeDemandOrder(scpDemandOrderDTO.getId(), "System");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoPush(Long masId) {
        Optional<ScpDemandOrderDTO> demandOrderOpt = this.scpDemandOrderDomainService.findDemandOrderById(masId);
        if (demandOrderOpt.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u5355ID:" + masId + "\u4e0d\u5b58\u5728");
        }
        this.push(masId);
    }

    @Override
    @SysCodeProc
    public Map<String, List<ScpDemandOrderDRespVO>> findEnableAllocSetting(ScpAllocSettingParamVO paramVO) {
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(paramVO.getBusinessType(), paramVO.getType());
        if (orderSetting == null) {
            throw new BusinessException("\u8bf7\u5148\u914d\u7f6e\u6216\u542f\u7528\u5355\u636e\u7c7b\u578b:" + paramVO.getDocType());
        }
        String storeCode = paramVO.getStoreCode();
        List itemTypes = StrUtil.split((CharSequence)orderSetting.getItemCate(), (CharSequence)",");
        List<ScpAllocSettingItemRespVO> allocSettingList = this.scpAllocSettingItemRepoProc.getAllocSettingItemByStoreCode(storeCode, paramVO.getDocType(), itemTypes);
        if (CollUtil.isEmpty(allocSettingList)) {
            return new HashMap<String, List<ScpDemandOrderDRespVO>>();
        }
        OrgStoreBaseRpcDTO orgStore = this.getOrgStore(paramVO.getType(), storeCode);
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        List<String> itemCodes = allocSettingList.stream().map(ScpAllocSettingItemRespVO::getItemCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemCodes(itemCodes);
        List<ItmItemScpBaseRpcDTO> itmItemScpBaseList = this.rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        if (CollUtil.isEmpty(itmItemScpBaseList)) {
            log.info("findEnableAllocSetting \u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
            return new HashMap<String, List<ScpDemandOrderDRespVO>>();
        }
        Map skuMap = itmItemScpBaseList.stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));
        List<ScpStoreCartDO> dataList = itmItemScpBaseList.stream().map(row -> {
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setItemCode(row.getItemCode());
            storeCartDO.setItemCateCode(row.getItemCateCode());
            storeCartDO.setUom(row.getUom());
            return storeCartDO;
        }).collect(Collectors.toList());
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.scpWhNetRelationService.findNewWhNetByParam(storeCode, paramVO.getType(), dataList);
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = this.scpSupplyAllocationService.findSupplyAllocationByParam(storeCode, paramVO.getType(), itemCodes);
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        ArrayList<ScpDemandOrderDRespVO> confirmRespVOS = new ArrayList<ScpDemandOrderDRespVO>();
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
        block2: for (ScpAllocSettingItemRespVO row2 : allocSettingList) {
            ScpDemandOrderItemBatchParamVO.Item item2 = new ScpDemandOrderItemBatchParamVO.Item();
            ItmItemScpBaseRpcDTO simpleRpcDTO = (ItmItemScpBaseRpcDTO)skuMap.get(row2.getItemId());
            if (simpleRpcDTO == null) continue;
            item2.setItemId(simpleRpcDTO.getId());
            item2.setItemCode(simpleRpcDTO.getItemCode());
            item2.setItemName(simpleRpcDTO.getItemName());
            item2.setItemCateCode(simpleRpcDTO.getItemCateCode());
            item2.setItemCateName(simpleRpcDTO.getItemCateName());
            item2.setSpuId(simpleRpcDTO.getSpuId());
            item2.setSpuItemCode(simpleRpcDTO.getSpuCode());
            item2.setSpuItemName(simpleRpcDTO.getSpuName());
            item2.setUom(simpleRpcDTO.getUom2());
            item2.setUomName(simpleRpcDTO.getUom2Name());
            item2.setDecimalPlaces(simpleRpcDTO.getDecimalPlaces());
            item2.setUomRatio(simpleRpcDTO.getUomRatio2());
            item2.setItemType(row2.getItemType2());
            item2.setDemandQuantity(row2.getMinNum());
            item2.setQty2(row2.getMinNum().multiply(simpleRpcDTO.getUomRatio2()).setScale((int)simpleRpcDTO.getDecimalPlaces(), RoundingMode.HALF_UP));
            item2.setUom2(simpleRpcDTO.getUom());
            item2.setUom2Name(simpleRpcDTO.getUomName());
            item2.setActivityCode(row2.getActivityCode());
            item2.setActivityId(row2.getMasId());
            item2.setItemType(row2.getItemType2());
            List skuAttchmentList = simpleRpcDTO.getSkuAttchmentList();
            List spuAttchmentList = simpleRpcDTO.getSpuAttchmentList();
            if (CollUtil.isNotEmpty((Collection)skuAttchmentList)) {
                first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                item2.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)skuAttchmentList.get(0)).getUrl() : first.get().getUrl());
            } else if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                item2.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
            }
            ArrayList<ScpDemandOrderDRespVO> inConfirmList = new ArrayList<ScpDemandOrderDRespVO>();
            for (String priority : priorities) {
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    inConfirmList.addAll(this.suppAllocStrategy(item2, orgStore, orderSetting.getSuppFreightFlag(), supplyAllocationMap, priceParamList, paramVO.getType(), stockMapRef));
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    inConfirmList.addAll(this.whnetStrategy(item2, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList, paramVO.getType()));
                }
                if (inConfirmList.isEmpty()) continue;
                confirmRespVOS.addAll(inConfirmList);
                continue block2;
            }
        }
        if (CollUtil.isEmpty(confirmRespVOS)) {
            return new HashMap<String, List<ScpDemandOrderDRespVO>>();
        }
        InvWhItemTotalStkRpcParam stockParam = this.buildStockParam(confirmRespVOS);
        CompletableFuture<List> future1 = CompletableFuture.supplyAsync(() -> {
            if (CollUtil.isEmpty((Collection)priceParamList)) {
                return new ArrayList();
            }
            return this.rmiPriceRpcService.findPriceByParam(priceParamList);
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> this.getWhStockMap(stockParam, stockMapRef), (Executor)this.taskExecutor);
        CompletableFuture.allOf(future1, future2).join();
        ArrayList<PriPriceRpcDTO> priceList = new ArrayList();
        try {
            priceList = future1.get();
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a{}", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a" + e.toString());
        }
        Map<String, List<PriPriceRpcDTO>> priceMap = this.buildPriceMap(priceList, priceParamList);
        Map stockMap = stockMapRef.get();
        List filterList = confirmRespVOS.stream().filter(item -> {
            if (ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode().equals(item.getSupplyType())) {
                return true;
            }
            if (stockMap != null && stockMap.containsKey(item.getItemCode())) {
                BigDecimal avalQty = (BigDecimal)stockMap.get(item.getItemCode());
                return item.getDemandQuantity().compareTo(avalQty) <= 0;
            }
            return false;
        }).collect(Collectors.toList());
        Map<String, List<ScpDemandOrderDRespVO>> resultMap = filterList.stream().map(item -> {
            if (priceMap.containsKey(item.getItemCode() + "@" + item.getSaleOuCode())) {
                item.setPrice(((PriPriceRpcDTO)((List)priceMap.get(item.getItemCode() + "@" + item.getSaleOuCode())).get(0)).getPrice());
            }
            item.setPlanQuantity(item.getDemandQuantity());
            if (item.getPrice() != null) {
                item.setPlanAmt(SysUtils.processAmtScale(item.getPrice().multiply(item.getPlanQuantity())));
            }
            return item;
        }).collect(Collectors.groupingBy(ScpDemandOrderDRespVO::getItemCode));
        log.info("\u6279\u91cf\u83b7\u53d6\u5546\u54c1\u660e\u7ec6\u884c\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(resultMap));
        return resultMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void startWorkFlow(ScpDemandOrderDO scpDemandOrderDO) {
        if (scpDemandOrderDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(scpDemandOrderDO.getProcInstStatus())) {
            String procInstName = "\u8ba2\u8d27\u5355\u4e0b\u5355-" + scpDemandOrderDO.getDocCode();
            WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)"SCP_DEMAND_ORDER_ADD", (String)procInstName, (String)scpDemandOrderDO.getDocCode(), null));
            log.info("\u8ba2\u8d27\u5355\u4e0b\u5355\u8c03\u7528\u5de5\u4f5c\u6d41\u6210\u529f!");
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
            }
            QScpDemandOrderDO orderDO = QScpDemandOrderDO.scpDemandOrderDO;
            JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)orderDO).set((Path)orderDO.procInstId, (Object)((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstId()).set(orderDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{orderDO.id.eq((Object)scpDemandOrderDO.getId())});
            if (!Objects.equals(((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(orderDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                jpaUpdateClause.set((Path)orderDO.apprStatus, (Object)ScpUdcEnum.COM_APPLY_STATUS_DOING.getValueCode());
            }
            jpaUpdateClause.execute();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(String docCode, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        Optional<ScpDemandOrderDO> byDocNo = this.scpDemandOrderRepo.findByDocCode(docCode);
        if (byDocNo.isEmpty()) {
            throw new BusinessException("\u5355\u636e\u53f7\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        ScpDemandOrderDO scpDemandOrderDO = byDocNo.get();
        QScpDemandOrderDO demandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)demandOrderDO).set(demandOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{demandOrderDO.id.eq((Object)scpDemandOrderDO.getId())});
        switch (procInstStatus) {
            case NOTSUBMIT: 
            case INTERRUPT: {
                jpaUpdateClause.set((Path)demandOrderDO.apprStatus, (Object)ScpUdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)demandOrderDO.apprStatus, (Object)ScpUdcEnum.COM_APPLY_STATUS_REJECTED.getValueCode()).set((Path)demandOrderDO.applyComment, (Object)commentInfo.getComment()).set(demandOrderDO.apprTime, (Object)LocalDateTime.now());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)demandOrderDO.apprStatus, (Object)ScpUdcEnum.COM_APPLY_STATUS_VOID.getValueCode()).set((Path)demandOrderDO.applyComment, (Object)commentInfo.getComment());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)demandOrderDO.apprStatus, (Object)ScpUdcEnum.COM_APPLY_STATUS_DOING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)demandOrderDO.apprStatus, (Object)ScpUdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode()).set(demandOrderDO.approvedTime, (Object)LocalDateTime.now()).set(demandOrderDO.apprTime, (Object)LocalDateTime.now()).set((Path)demandOrderDO.applyComment, (Object)commentInfo.getComment());
                break;
            }
            default: {
                throw new IllegalStateException("\u72b6\u6001\u5f02\u5e38");
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            List<ScpDemandOrderDDO> byMasId = this.scpDemandOrderDRepo.findByMasId(scpDemandOrderDO.getId());
            this.splitDoc(scpDemandOrderDO, scpDemandOrderDO.getId(), byMasId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void splitDoc(ScpDemandOrderDO saveVO, Long id, List<ScpDemandOrderDDO> saveItemList) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)currentUserDTO));
        if (ObjectUtils.isEmpty((Object)currentUserDTO) || currentUserDTO.getDetail() == null) {
            throw new BusinessException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u5931\u8d25");
        }
        this.transactionCommitHandler.handle(() -> {
            ScpOrderSubmitMqParam orderSubmitMqParam = new ScpOrderSubmitMqParam();
            orderSubmitMqParam.setDemandOrderId(id);
            orderSubmitMqParam.setAgentEmpId(currentUserDTO.getDetail().getEmployeeId());
            orderSubmitMqParam.setBusinessKey("scp_demand_order_submit");
            orderSubmitMqParam.setDemandWhStCode(saveVO.getDemandWhStCode());
            if (CollUtil.isNotEmpty((Collection)saveItemList)) {
                List<Long> activityIds = saveItemList.stream().map(ScpDemandOrderDDO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                orderSubmitMqParam.setActivityIds(activityIds);
            }
            this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_demand_order_submit", (Serializable)orderSubmitMqParam);
        });
    }

    private InvWhItemTotalStkRpcParam buildStockParam(List<ScpDemandOrderDRespVO> confirmRespVOS) {
        if (CollUtil.isNotEmpty(confirmRespVOS)) {
            List itemIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(ScpDemandOrderDRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List whIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(ScpDemandOrderDRespVO::getSuppWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(itemIds) || CollUtil.isEmpty(whIds)) {
                log.info("\u67e5\u8be2\u5e93\u5b58\u5546\u54c1\u6216\u8005\u4ed3\u5e93\u4e3a\u7a7a\uff0c\u65e0\u9700\u67e5\u8be2");
                return null;
            }
            InvWhItemTotalStkRpcParam invWhItemTotalStkRpcParam = new InvWhItemTotalStkRpcParam();
            invWhItemTotalStkRpcParam.setItemIds(itemIds);
            invWhItemTotalStkRpcParam.setWhIds(whIds);
            invWhItemTotalStkRpcParam.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
            return invWhItemTotalStkRpcParam;
        }
        return null;
    }

    private void getWhStockMap(InvWhItemTotalStkRpcParam stkRpcParam, AtomicReference<Map<String, BigDecimal>> stockMap) {
        if (stkRpcParam == null) {
            return;
        }
        List<InvWhItemTotalStkRpcDTO> invWhItemTotalStkRpcDTOS = this.rmiInvStkRpcService.queryInvWhItemTotalStk(stkRpcParam);
        if (CollUtil.isEmpty(invWhItemTotalStkRpcDTOS)) {
            return;
        }
        for (InvWhItemTotalStkRpcDTO dto : invWhItemTotalStkRpcDTOS) {
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(dto.getItemCode(), dto.getAvalQty2());
                return currentMap;
            });
        }
    }

    private String checkTransactionPathAndPoPrice(Long demandSetId, List<Long> orderIds, ScpDemandSetDTO scpDemandSetDTO) {
        List<ScpDemandOrderComputeVO> demandOrderComputeVOS = this.scpDemandOrderDomainService.findComputeDemandOrderD(orderIds);
        if (CollUtil.isEmpty(demandOrderComputeVOS)) {
            return "\u8ba2\u5355\u96c6\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u8ba2\u8d27\u5355\u660e\u7ec6";
        }
        String checkMsg = this.checkTransactionPath(demandSetId, scpDemandSetDTO.getType(), demandOrderComputeVOS);
        if (StrUtil.isNotBlank((CharSequence)checkMsg)) {
            return checkMsg;
        }
        List poDemandOrders = demandOrderComputeVOS.stream().filter(row -> StrUtil.isNotBlank((CharSequence)row.getOuCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(poDemandOrders)) {
            return checkMsg;
        }
        ArrayList<PurPriceParamRpcDTO> purPriceParamRpcDTOS = new ArrayList<PurPriceParamRpcDTO>();
        for (ScpDemandOrderComputeVO row2 : poDemandOrders) {
            PurPriceParamRpcDTO purPriceParamRpcDTO = new PurPriceParamRpcDTO();
            purPriceParamRpcDTO.setUuid(Long.valueOf(Math.abs(UUID.randomUUID().hashCode())));
            purPriceParamRpcDTO.setItemId(row2.getItemId());
            purPriceParamRpcDTO.setOuId(row2.getOuId());
            purPriceParamRpcDTO.setSuppId(row2.getSuppWhId());
            purPriceParamRpcDTO.setUom(row2.getUnit());
            purPriceParamRpcDTO.setCurrCode("CNY");
            purPriceParamRpcDTO.setDocTime(LocalDateTime.now());
            purPriceParamRpcDTO.setQty(row2.getAllocationDeQuantity());
            purPriceParamRpcDTOS.add(purPriceParamRpcDTO);
        }
        return this.rmiPurRpcService.checkItemPurPrice(purPriceParamRpcDTOS);
    }

    public void delPatternKey(RedisTemplate<String, Object> redisTemplate, String pattern) {
        Set keys = redisTemplate.keys((Object)pattern);
        redisTemplate.delete((Collection)keys);
    }

    private String checkTransactionPath(Long demandSetId, String type, List<ScpDemandOrderComputeVO> demandOrderComputeVOS) {
        List noPoDemandOrders = demandOrderComputeVOS.stream().filter(Objects::nonNull).filter(row -> StrUtil.isBlank((CharSequence)row.getOuCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(noPoDemandOrders)) {
            log.info("\u3010\u8ba2\u8d27\u96c6\u81ea\u52a8\u8ba1\u7b97\u3011\u8ba2\u8d27\u96c6\uff1a{},\u975e\u91c7\u8d2d\u8ba2\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a", (Object)demandSetId);
            return "";
        }
        List<String> demandWhCodes = noPoDemandOrders.stream().map(ScpDemandOrderComputeVO::getDemandWhStCode).distinct().collect(Collectors.toList());
        List<String> suppWhCodes = noPoDemandOrders.stream().map(ScpDemandOrderComputeVO::getSuppWhCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> suppWhMap = this.buildInvWhMap(suppWhCodes);
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type)) {
            List<OrgStoreBaseRpcDTO> orgStoreList = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandWhCodes);
            Map storeMap = orgStoreList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity()));
            ArrayList<SupportTransactionPathRpcParam> rpcParams = new ArrayList<SupportTransactionPathRpcParam>();
            for (ScpDemandOrderComputeVO row2 : noPoDemandOrders) {
                Long whOuId;
                Long ouId = ((OrgStoreBaseRpcDTO)storeMap.get(row2.getDemandWhStCode())).getOuId();
                if (ouId.equals(whOuId = suppWhMap.get(row2.getSuppWhCode()).getOuId())) continue;
                SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
                rpcParam.setCompanyIdStart(whOuId);
                rpcParam.setCompanyIdEnd(ouId);
                rpcParams.add(rpcParam);
            }
            List disPathParams = rpcParams.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SupportTransactionPathRpcParam>(Comparator.comparing(SupportTransactionPathRpcParam::getCompanyIdStart).thenComparing(SupportTransactionPathRpcParam::getCompanyIdEnd))), ArrayList::new));
            Map<String, List<SupportTransactionPathRpcDTO>> suppTransactionPathMap = this.checkTransactionPathAndBuild(disPathParams);
            for (ScpDemandOrderComputeVO row3 : noPoDemandOrders) {
                List<SupportTransactionPathRpcDTO> pathList;
                Long ouId = ((OrgStoreBaseRpcDTO)storeMap.get(row3.getDemandWhStCode())).getOuId();
                String ouCode = ((OrgStoreBaseRpcDTO)storeMap.get(row3.getDemandWhStCode())).getOuCode();
                Long whOuId = suppWhMap.get(row3.getSuppWhCode()).getOuId();
                String whOuCode = suppWhMap.get(row3.getSuppWhCode()).getOuCode();
                if (ouId.equals(whOuId) || !CollUtil.isEmpty(pathList = suppTransactionPathMap.get(whOuId + "@" + ouId)) && !StrUtil.isBlank((CharSequence)pathList.get(0).getPathCode())) continue;
                log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)whOuId, (Object)ouId);
                return "\u4ece\u516c\u53f8:" + whOuCode + "\u5230\u516c\u53f8:" + ouCode + "\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4";
            }
        } else {
            Map<String, InvWhRpcSimpleDTO> whMap = this.buildInvWhMap(demandWhCodes);
            ArrayList<SupportTransactionPathRpcParam> rpcParams = new ArrayList<SupportTransactionPathRpcParam>();
            for (ScpDemandOrderComputeVO row4 : noPoDemandOrders) {
                Long whOuId;
                Long ouId = whMap.get(row4.getDemandWhStCode()).getOuId();
                if (ouId.equals(whOuId = suppWhMap.get(row4.getSuppWhCode()).getOuId())) continue;
                SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
                rpcParam.setCompanyIdStart(whOuId);
                rpcParam.setCompanyIdEnd(ouId);
                rpcParams.add(rpcParam);
            }
            List disPathParams = rpcParams.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SupportTransactionPathRpcParam>(Comparator.comparing(SupportTransactionPathRpcParam::getCompanyIdStart).thenComparing(SupportTransactionPathRpcParam::getCompanyIdEnd))), ArrayList::new));
            Map<String, List<SupportTransactionPathRpcDTO>> suppTransactionPathMap = this.checkTransactionPathAndBuild(disPathParams);
            for (ScpDemandOrderComputeVO row5 : noPoDemandOrders) {
                List<SupportTransactionPathRpcDTO> pathList;
                Long ouId = whMap.get(row5.getDemandWhStCode()).getOuId();
                String ouCode = whMap.get(row5.getDemandWhStCode()).getOuCode();
                Long whOuId = suppWhMap.get(row5.getSuppWhCode()).getOuId();
                String whOuCode = suppWhMap.get(row5.getSuppWhCode()).getOuCode();
                if (ouId.equals(whOuId) || !CollUtil.isEmpty(pathList = suppTransactionPathMap.get(whOuId + "@" + ouId)) && !StrUtil.isBlank((CharSequence)pathList.get(0).getPathCode())) continue;
                log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)whOuId, (Object)ouId);
                return "\u4ece\u516c\u53f8:" + whOuCode + "\u5230\u516c\u53f8:" + ouCode + "\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4";
            }
        }
        return "";
    }

    private Map<String, InvWhRpcSimpleDTO> buildInvWhMap(List<String> demandWhCodes) {
        if (CollUtil.isEmpty(demandWhCodes)) {
            return new HashMap<String, InvWhRpcSimpleDTO>();
        }
        return this.rmiInvStkService.findInvWhBaseMapByCode(demandWhCodes);
    }

    private void processPoInfoCallback(List<PurPoSaveDTO> result) {
        log.info("\u66f4\u65b0\u91c7\u8d2d\u5355\u4fe1\u606f\uff1a{}", (Object)JSONUtil.toJsonStr(result));
        if (CollUtil.isNotEmpty(result)) {
            for (PurPoSaveDTO dto : result) {
                String docNo = dto.getDocNo();
                for (PurPoDSaveDTO poDSaveDTO : dto.getPurPoDCreateParamVOList()) {
                    this.scpDemandOrderDDomainService.updatePOSrcInfo(poDSaveDTO.getRelateDocDid(), dto.getId(), docNo, String.valueOf(poDSaveDTO.getLineNo()));
                }
            }
        }
    }

    @Override
    public List<AppDemandOrderCountRespVO> countStatus(ScpDemandOrderAppCountParamVO countParamVO) {
        if (StrUtil.isBlank((CharSequence)countParamVO.getDemandWhStCode())) {
            throw new BusinessException("\u9700\u6c42\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CopyOnWriteArrayList result = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        String orderSetting = SysUtils.getOrderSetting();
        if ("1".equals(orderSetting)) {
            CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
                ScpDemandOrderPageParamVO paramVO = new ScpDemandOrderPageParamVO();
                BeanUtils.copyProperties((Object)countParamVO, (Object)paramVO, (String[])new String[0]);
                List<String> statusList = List.of(ScpUdcEnum.DEO_STATUS_PART_RECV.getValueCode(), ScpUdcEnum.DEO_STATUS_RECV.getValueCode());
                paramVO.setDocStatusList(statusList);
                Long recvCount = this.scpDemandOrderDomainService.countAppOrderByParam(paramVO);
                List<String> shipStatusList = List.of(ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode(), ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode());
                paramVO.setDocStatusList(shipStatusList);
                Long shipCount = this.scpDemandOrderDomainService.countAppOrderByParam(paramVO);
                List<String> unPushList = List.of(ScpUdcEnum.DEO_STATUS_DONE.getValueCode(), ScpUdcEnum.DEO_STATUS_DOING.getValueCode());
                paramVO.setDocStatusList(unPushList);
                Long unPushCount = this.scpDemandOrderDomainService.countAppOrderByParam(paramVO);
                result.add(new AppDemandOrderCountRespVO().setDocStatus("RECV").setCount(recvCount));
                result.add(new AppDemandOrderCountRespVO().setDocStatus("SHIP").setCount(shipCount));
                result.add(new AppDemandOrderCountRespVO().setDocStatus("PUSH").setCount(unPushCount));
            }, (Executor)this.taskExecutor);
            CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
                ScpDemandOrderPageParamVO paramVO = new ScpDemandOrderPageParamVO();
                BeanUtils.copyProperties((Object)countParamVO, (Object)paramVO, (String[])new String[0]);
                paramVO.setDocStatusList(null);
                Long allCount = this.scpDemandOrderDomainService.countAppOrderByParam(paramVO);
                List<String> replyStatusList = List.of(ScpUdcEnum.DEO_STATUS_RECV.getValueCode());
                paramVO.setDocStatusList(replyStatusList);
                paramVO.setReplyFlag(Boolean.FALSE);
                Long replyCount = this.scpDemandOrderDomainService.countAppOrderByParam(paramVO);
                List<String> payStatusList = List.of(ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode(), ScpUdcEnum.PAY_STATUS_PAYING.getValueCode());
                paramVO.setDocStatusList(null);
                paramVO.setReplyFlag(null);
                paramVO.setPayStatusList(payStatusList);
                Long payCount = this.scpDemandOrderDomainService.countAppPayOrderByParam(paramVO);
                result.add(new AppDemandOrderCountRespVO().setDocStatus("REPLY").setCount(replyCount));
                result.add(new AppDemandOrderCountRespVO().setDocStatus("ALL").setCount(allCount));
                result.add(new AppDemandOrderCountRespVO().setDocStatus("PAY").setCount(payCount));
            }, (Executor)this.taskExecutor);
            CompletableFuture.allOf(future1, future2).join();
            return result;
        }
        ScpDemandOrderPageParamVO paramVO = new ScpDemandOrderPageParamVO();
        BeanUtils.copyProperties((Object)countParamVO, (Object)paramVO, (String[])new String[0]);
        return this.scpDemandOrderDomainService.countStatus(paramVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpDemandOrderDomainService.deleteByIds(ids);
    }

    @Override
    public void push(Long id, Long agentEmpId, Boolean appFlag) {
        TimeInterval timer = new TimeInterval();
        log.info("\u3010\u8ba2\u8d27\u5355\u63a8\u9001\u5176\u4ed6\u4e1a\u52a1\u57df\u3011\u8ba2\u8d27\u5355ID\uff1a{},\u5f00\u59cb\u63a8\u9001", (Object)id);
        Object poObj = this.redisTemplate.opsForValue().get((Object)("PO" + id));
        Object trnObj = this.redisTemplate.opsForValue().get((Object)("TRN" + id));
        if (poObj != null || trnObj != null) {
            throw new BusinessException("\u8ba2\u8d27\u5355\u6b63\u5728\u63a8\u9001\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        Optional<ScpDemandOrderDTO> demandOrderOpt = this.scpDemandOrderDomainService.findDemandOrderById(id);
        if (demandOrderOpt.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u5355ID:" + id + "\u4e0d\u5b58\u5728");
        }
        ScpDemandOrderDTO demandOrderDTO = demandOrderOpt.get();
        List<String> docStatusList = List.of(ScpUdcEnum.DEO_STATUS_DONE.getValueCode(), ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode());
        if (!docStatusList.contains(demandOrderDTO.getDocStatus())) {
            throw new BusinessException("\u3010\u5168\u90e8\u5206\u914d\u3011\u548c\u3010\u90e8\u5206\u63a8\u9001\u3011\u7684\u5355\u636e\u624d\u80fd\u63a8\u9001");
        }
        if (!Objects.equals(demandOrderDTO.getApprStatus(), ScpUdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode())) {
            throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u5b8c\u6210\u7684\u5355\u636e\u624d\u80fd\u63a8\u9001");
        }
        Long empId = this.getAgentEmpId(agentEmpId);
        ScpOrderSettingRespVO setting = this.scpOrderSettingDomainService.findCacheByBusinessType(demandOrderDTO.getBusinessType(), demandOrderDTO.getType());
        Map<String, List<OrgStoreWhDTO>> orgStoreMap = this.getOrgStoreMap(demandOrderDTO);
        Map<Long, InvWhRpcSimpleDTO> whMap = this.getWhMap(demandOrderDTO);
        List<ScpDemandOrderDDTO> demandOrderDList = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(demandOrderDTO.getId());
        String troErrorLog = null;
        String poErrorLog = null;
        try {
            ArrayList<ScpDemandOrderDDTO> trnList = new ArrayList<ScpDemandOrderDDTO>();
            ArrayList poList = new ArrayList();
            demandOrderDList.forEach(d -> {
                if (ScpConstant.WH_DELIVERY_TYPES.contains(d.getDeliveryType())) {
                    trnList.add((ScpDemandOrderDDTO)d);
                } else if (ScpConstant.PUR_DELIVERY_TYPES.contains(d.getDeliveryType())) {
                    poList.add(d);
                }
            });
            ArrayList<StoreOrderTrnRpcDTO> storeOrderTrnRpcDTOS = new ArrayList();
            if (CollUtil.isNotEmpty(trnList)) {
                storeOrderTrnRpcDTOS = this.prepareDataTrnPush(demandOrderDTO, orgStoreMap, whMap, empId, trnList, setting);
            }
            List<PurPoSaveDTO> purPoSaveDTOS = new ArrayList<PurPoSaveDTO>();
            if (CollUtil.isNotEmpty(poList)) {
                List<ScpDemandOrderDDTO> demandOrderDDTOList = poList.stream().filter(d -> !Boolean.TRUE.equals(d.getGiftLineFlag())).collect(Collectors.toList());
                purPoSaveDTOS = this.prepareDataPoPush(demandOrderDTO, orgStoreMap, empId, demandOrderDDTOList, setting);
            }
            if (CollUtil.isNotEmpty(storeOrderTrnRpcDTOS)) {
                troErrorLog = this.pushTrn(storeOrderTrnRpcDTOS);
            }
            if (CollUtil.isNotEmpty(purPoSaveDTOS)) {
                poErrorLog = this.pushPo(purPoSaveDTOS);
            }
        }
        catch (Exception e) {
            log.error("\u8ba2\u8d27\u5355\uff1a{},\u53d1\u9001mq\u6d88\u606f\u5931\u8d25\uff1a{}", new Object[]{demandOrderDTO.getDocCode(), e.getMessage(), e});
            this.redisTemplate.delete((Object)("TRN" + id));
            this.redisTemplate.delete((Object)("PO" + id));
        }
        log.info("\u3010\u8ba2\u8d27\u5355\u63a8\u9001\u5176\u4ed6\u4e1a\u52a1\u57df\u3011\u8ba2\u8d27\u5355\u63a8\u9001\u7ed3\u675f\uff0c\u8017\u65f6:{}ms", (Object)timer.intervalRestart());
        if (troErrorLog != null || poErrorLog != null) {
            log.error("\u3010\u8ba2\u8d27\u5355\u63a8\u9001\u5176\u4ed6\u4e1a\u52a1\u57df\u3011\u63a8\u9001\u5931\u8d25\uff1a{}", (Object)(troErrorLog + ", " + poErrorLog));
            throw new BusinessException("\u63a8\u9001\u5931\u8d25\uff1a" + troErrorLog + ", " + poErrorLog);
        }
    }

    private Long getAgentEmpId(Long agentEmpId) {
        if (agentEmpId == null) {
            CurrentUserDTO currentUserDTO = UserService.currentUser();
            log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)currentUserDTO));
            if (ObjectUtils.isEmpty((Object)currentUserDTO) || currentUserDTO.getDetail() == null) {
                throw new BusinessException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u5931\u8d25");
            }
            return currentUserDTO.getDetail().getEmployeeId();
        }
        return agentEmpId;
    }

    @Override
    public List<SalSoSaveDTO> prepareDataSoPush(ScpDemandOrderDTO demandOrderDTO, Map<String, List<OrgStoreWhDTO>> orgStoreMap, List<ScpDemandOrderDDTO> demandOrderDList) {
        if (!ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(demandOrderDTO.getType()) || !ScpUdcEnum.STORE_TYPE2_JOIN.getValueCode().equals(demandOrderDTO.getStoreType2())) {
            log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u9500\u552e\u8ba2\u5355\u3011\u8ba2\u8d27\u5355\u7f16\u7801\uff1a{}\uff0c\u6ca1\u6709\u9700\u65b9\u65b9\u662f\u95e8\u5e97\u7c7b\u578b\u5e76\u4e14\u95e8\u5e97\u6027\u8d28\u662f\u52a0\u76df\u5e97\u7684\u8ba2\u5355", (Object)demandOrderDTO.getDocCode());
            return new ArrayList<SalSoSaveDTO>();
        }
        List<OrgStoreWhDTO> noWhStoreList = orgStoreMap.get(demandOrderDTO.getDemandWhStCode());
        if (CollUtil.isNotEmpty(noWhStoreList)) {
            log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u9500\u552e\u8ba2\u5355\u3011\u8ba2\u8d27\u5355\u7f16\u7801\uff1a{}\uff0c\u95e8\u5e97\u6027\u8d28\u662f\u52a0\u76df\u5e97\u7684\u8ba2\u5355\uff0c\u4e14\u95e8\u5e97\u4e3b\u6570\u636e\u4e0b\u6709\u771f\u5b9e\u4ed3\u5e93\u5bf9\u5e94", (Object)demandOrderDTO.getDocCode());
            List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u95e8\u5e97\u7f16\u7801:" + demandOrderDTO.getDemandWhStCode() + "\u672a\u914d\u7f6e\u771f\u5b9e\u4ed3\u5e93");
            return new ArrayList<SalSoSaveDTO>();
        }
        CopyOnWriteArrayList salSoSaveDTOS = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS = this.rmiOrgStoreRpcService.queryByStoreCodes(List.of(demandOrderDTO.getDemandWhStCode()));
        OrgStoreDetailRpcDTO storeInfo = orgStoreDetailRpcDTOS.get(0);
        String custCode = storeInfo.getCustCode();
        String storeCode = storeInfo.getStoreCode();
        if (StrUtil.isBlank((CharSequence)custCode)) {
            log.info("\u8ba2\u5355\u7f16\u7801\uff1a{},\u95e8\u5e97\u7f16\u7801\uff1a{},\u672a\u914d\u7f6e\u5ba2\u6237\u4fe1\u606f", (Object)demandOrderDTO.getDocCode(), (Object)custCode);
            List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u95e8\u5e97\u7f16\u7801:" + storeCode + "\u672a\u914d\u7f6e\u5ba2\u6237\u4fe1\u606f");
            return new ArrayList<SalSoSaveDTO>();
        }
        List<CustBaseAndBelongOuDTO> custBaseAndBelongOuList = this.rmiSalRpcService.findCustBaseAndBelongOuByParam(List.of(custCode));
        CustBaseAndBelongOuDTO crmCustDTO = custBaseAndBelongOuList.get(0);
        List custBelongOuDTOS = crmCustDTO.getBelongOuDTOS();
        if (CollUtil.isEmpty((Collection)custBelongOuDTOS)) {
            log.info("\u8ba2\u5355\u7f16\u7801\uff1a{},\u95e8\u5e97\u7f16\u7801\uff1a{},\u5ba2\u6237\u7f16\u7801:{},\u672a\u914d\u7f6e\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f", new Object[]{demandOrderDTO.getDocCode(), storeCode, custCode});
            List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u95e8\u5e97\u7f16\u7801:" + storeCode + "\u5ba2\u6237\u7f16\u7801:" + custCode + "\u672a\u914d\u7f6e\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f");
            return new ArrayList<SalSoSaveDTO>();
        }
        Optional<CustBelongOuDTO> first = custBelongOuDTOS.stream().filter(row -> row.getIsFranchisee() != null && row.getIsFranchisee() != false && "0".equals(row.getStatus())).findFirst();
        if (first.isEmpty()) {
            log.info("\u8ba2\u5355\u7f16\u7801\uff1a{},\u95e8\u5e97\u7f16\u7801\uff1a{},\u5ba2\u6237\u7f16\u7801:{},\u672a\u914d\u7f6e\u52a0\u76df\u5546\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f", new Object[]{demandOrderDTO.getDocCode(), storeCode, custCode});
            List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u95e8\u5e97\u7f16\u7801:" + storeCode + "\u5ba2\u6237\u7f16\u7801:" + custCode + "\u672a\u914d\u7f6e\u52a0\u76df\u5546\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f");
            return new ArrayList<SalSoSaveDTO>();
        }
        CustBelongOuDTO custBelongOuDTO = first.get();
        demandOrderDList.stream().filter(row -> row.getIsPushed() == false && row.getIsCalculated() != false && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType()) && row.getPlanQuantity() != null && row.getPlanQuantity().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (demandOrderDList.isEmpty()) {
            log.info("\u8ba2\u5355\u7f16\u7801\uff1a{},\u95e8\u5e97\u7f16\u7801\uff1a{},\u6ca1\u6709\u6ee1\u8db3\u8f6c\u9500\u552e\u8ba2\u5355\u6761\u4ef6\u7684\u8ba2\u8d27\u5355\u660e\u7ec6", (Object)demandOrderDTO.getDocCode(), (Object)storeCode);
            List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u6ca1\u6709\u6ee1\u8db3\u8f6c\u9500\u552e\u8ba2\u5355\u6761\u4ef6\u7684\u8ba2\u8d27\u5355\u660e\u7ec6");
            return new ArrayList<SalSoSaveDTO>();
        }
        Map<Long, List<ScpDemandOrderDDTO>> orderDMap = demandOrderDList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getSuppWhId));
        List itemCodes = demandOrderDList.stream().map(ScpDemandOrderDDTO::getItemCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        ItmItemBusinessRpcDtoParam itmItemBusinessRpcDtoParam = new ItmItemBusinessRpcDtoParam();
        itmItemBusinessRpcDtoParam.setItemCodes(itemCodes);
        itmItemBusinessRpcDtoParam.setBuCodes((List)Lists.newArrayList((Object[])new String[]{custBelongOuDTO.getOuCode()}));
        List<ItmItemBusinessRpcDTO> itemBusinessRpcDTOS = this.rmiItemService.selectItmItemBusinessByParam(itmItemBusinessRpcDtoParam);
        Map itemMap = itemBusinessRpcDTOS.stream().collect(Collectors.toMap(ItmItemBusinessRpcDTO::getItemCode, Function.identity()));
        HashMap<String, List<PriPriceRpcDTO>> groupedBasePriceList = new HashMap<String, List<PriPriceRpcDTO>>();
        HashMap<String, List<PriPriceRpcDTO>> groupedPriceList = new HashMap<String, List<PriPriceRpcDTO>>();
        this.handleSalePrice(groupedBasePriceList, groupedPriceList, itemBusinessRpcDTOS, crmCustDTO, custBelongOuDTO.getOuCode());
        for (Map.Entry<Long, List<ScpDemandOrderDDTO>> entry : orderDMap.entrySet()) {
            List<ScpDemandOrderDDTO> demandOrderDDTOList = entry.getValue();
            ArrayList<SalSoDSaveDTO> salSoDSaveDTOList = new ArrayList<SalSoDSaveDTO>();
            AtomicReference<String> errorLog = new AtomicReference<String>();
            for (ScpDemandOrderDDTO demandOrderDDTO : demandOrderDDTOList) {
                SalSoDSaveDTO salSoDSaveDTO = this.createSalSoDSaveDTO(demandOrderDDTO, demandOrderDTO.getDocCode(), (ItmItemBusinessRpcDTO)itemMap.get(demandOrderDDTO.getItemCode()), groupedBasePriceList, groupedPriceList, errorLog, custBelongOuDTO);
                if (StrUtil.isNotBlank((CharSequence)errorLog.get())) break;
                salSoDSaveDTOList.add(salSoDSaveDTO);
            }
            if (StrUtil.isNotBlank((CharSequence)((CharSequence)errorLog.get()))) {
                List<Long> dIdList = demandOrderDDTOList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, StringUtils.substring((String)errorLog.get(), (int)0, (int)200));
                break;
            }
            SalSoSaveDTO salSoSaveDTO = this.createSalSoSaveDTO(custBelongOuDTO, crmCustDTO, demandOrderDTO, storeInfo);
            salSoSaveDTO.setSalSoDSaveVOList(salSoDSaveDTOList);
            BigDecimal amt = this.sumBigDecimal(salSoSaveDTO, SalSoDSaveDTO::getAmt);
            salSoSaveDTO.setAmt(amt);
            BigDecimal netAmt = this.sumBigDecimal(salSoSaveDTO, SalSoDSaveDTO::getNetAmt);
            salSoSaveDTO.setNetAmt(netAmt);
            BigDecimal taxAmt = this.sumBigDecimal(salSoSaveDTO, SalSoDSaveDTO::getTaxAmt);
            salSoSaveDTO.setTaxAmt(taxAmt);
            ScpDemandOrderDDTO scpDemandOrderDDTO = demandOrderDDTOList.get(0);
            salSoSaveDTO.setWhId(scpDemandOrderDDTO.getSuppWhId());
            salSoSaveDTO.setWhCode(scpDemandOrderDDTO.getSuppWhCode());
            salSoSaveDTO.setWhName(scpDemandOrderDDTO.getSuppWhName());
            salSoSaveDTOS.add(salSoSaveDTO);
        }
        String redisKey = "SO" + demandOrderDTO.getId().toString();
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)"20", 3L, TimeUnit.DAYS);
        return salSoSaveDTOS;
    }

    private Map<Long, InvWhRpcSimpleDTO> getWhMap(ScpDemandOrderDTO demandOrderDTO) {
        if (ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(demandOrderDTO.getType()) && demandOrderDTO.getDemandWhStId() != null) {
            Map<Long, InvWhRpcSimpleDTO> invWhBaseMap = this.rmiInvStkService.findInvWhBaseMap(List.of(demandOrderDTO.getDemandWhStId()));
            log.info("\u4ed3\u5e93\u7c7b\u578b\u6570\u636ewhIdMap:{}", (Object)JSONUtil.toJsonStr(invWhBaseMap));
            return invWhBaseMap;
        }
        return new HashMap<Long, InvWhRpcSimpleDTO>();
    }

    @Override
    public Map<Long, InvWhRpcSimpleDTO> getWhMap(List<ScpDemandOrderDTO> demandOrderDTOS) {
        List<Long> whIds = demandOrderDTOS.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(row.getType()) && row.getDemandWhStId() != null).map(ScpDemandOrderDTO::getDemandWhStId).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(whIds)) {
            return this.rmiInvStkService.findInvWhBaseMap(whIds);
        }
        return new HashMap<Long, InvWhRpcSimpleDTO>();
    }

    private Map<String, List<OrgStoreWhDTO>> getOrgStoreMap(ScpDemandOrderDTO demandOrderDTO) {
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(demandOrderDTO.getType()) && StrUtil.isNotBlank((CharSequence)demandOrderDTO.getDemandCode())) {
            List<OrgStoreWhDTO> orgStoreWhDTOS = this.rmiOrgStoreRpcService.listWhByCode(List.of(demandOrderDTO.getDemandWhStCode()));
            if (CollUtil.isEmpty(orgStoreWhDTOS)) {
                log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u8c03\u62e8\u5355\u3011\u8ba2\u8d27\u5355\u7f16\u7801\uff1a{},\u95e8\u5e97\u7f16\u7801\uff1a{}\u4e0d\u5b58\u5728", (Object)demandOrderDTO.getDocCode(), (Object)demandOrderDTO.getDemandWhStCode());
                return new HashMap<String, List<OrgStoreWhDTO>>();
            }
            List haveWhStoreList = orgStoreWhDTOS.stream().filter(whDto -> whDto.getWhType() != null && 1 == whDto.getWhType()).collect(Collectors.toList());
            if (CollUtil.isEmpty(haveWhStoreList)) {
                log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u8c03\u62e8\u5355\u3011\u8ba2\u8d27\u5355ID\uff1a{}\uff0c\u95e8\u5e97\u4e3b\u6570\u636e\u4e0b\u6ca1\u6709\u771f\u5b9e\u4ed3\u5e93\u5bf9\u5e94", (Object)demandOrderDTO.getId());
                return new HashMap<String, List<OrgStoreWhDTO>>();
            }
            Map<String, List<OrgStoreWhDTO>> haveWhStoreMap = haveWhStoreList.stream().collect(Collectors.groupingBy(OrgStoreWhDTO::getStoreCode));
            log.info("\u771f\u5b9e\u4ed3\u5e93\u6570\u636e\u5b57\u5178haveWhStoreMap:{}", (Object)JSONUtil.toJsonStr(haveWhStoreMap));
            return haveWhStoreMap;
        }
        return new HashMap<String, List<OrgStoreWhDTO>>();
    }

    @Override
    public Map<String, List<OrgStoreWhDTO>> getOrgStoreMap(List<ScpDemandOrderDTO> demandOrderDTOS) {
        List<String> storeCodes = demandOrderDTOS.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) && StrUtil.isNotBlank((CharSequence)row.getDemandCode())).map(ScpDemandOrderDTO::getDemandWhStCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        List<OrgStoreWhDTO> orgStoreWhDTOS = this.rmiOrgStoreRpcService.listWhByCode(storeCodes);
        List haveWhStoreList = orgStoreWhDTOS.stream().filter(whDto -> whDto.getWhType() != null && 1 == whDto.getWhType()).collect(Collectors.toList());
        if (CollUtil.isEmpty(haveWhStoreList)) {
            log.info("\u3010\u8ba2\u8d27\u96c6\u63a8\u9001\u8c03\u62e8\u5355\u3011\u8ba2\u8d27\u5355\u6ca1\u6709\u95e8\u5e97\u4e3b\u6570\u636e\u4e0b\u6709\u771f\u5b9e\u4ed3\u5e93\u5bf9\u5e94");
            return new HashMap<String, List<OrgStoreWhDTO>>();
        }
        Map<String, List<OrgStoreWhDTO>> haveWhStoreMap = haveWhStoreList.stream().collect(Collectors.groupingBy(OrgStoreWhDTO::getStoreCode));
        log.info("\u771f\u5b9e\u4ed3\u5e93\u6570\u636e\u5b57\u5178haveWhStoreMap:{}", (Object)JSONUtil.toJsonStr(haveWhStoreMap));
        return haveWhStoreMap;
    }

    private SalSoSaveDTO createSalSoSaveDTO(CustBelongOuDTO custBelongOuDTO, CustBaseAndBelongOuDTO crmCustDTO, ScpDemandOrderDTO demandOrderDTO, OrgStoreDetailRpcDTO storeInfo) {
        SalSoSaveDTO salSoSaveDTO = new SalSoSaveDTO();
        salSoSaveDTO.setDocType("BTB");
        salSoSaveDTO.setDocStatus("CF");
        salSoSaveDTO.setSoScene("SO");
        salSoSaveDTO.setSoSource("POS");
        salSoSaveDTO.setOuId(custBelongOuDTO.getOuId());
        salSoSaveDTO.setOuCode(custBelongOuDTO.getOuCode());
        salSoSaveDTO.setOuName(custBelongOuDTO.getOuName());
        salSoSaveDTO.setBuId(custBelongOuDTO.getBuId());
        salSoSaveDTO.setBuCode(custBelongOuDTO.getBuCode());
        salSoSaveDTO.setBuName(custBelongOuDTO.getBuName());
        salSoSaveDTO.setCustId(crmCustDTO.getId());
        salSoSaveDTO.setCustCode(crmCustDTO.getCustCode());
        salSoSaveDTO.setCustName(crmCustDTO.getCustName());
        salSoSaveDTO.setDocTime(LocalDateTimeUtil.format((LocalDateTime)demandOrderDTO.getDemandDate(), (DateTimeFormatter)DateTimeUtil.FORMATTER_DATETIME));
        salSoSaveDTO.setDemandDate(LocalDateTimeUtil.format((LocalDateTime)demandOrderDTO.getDemandDate(), (DateTimeFormatter)DateTimeUtil.FORMATTER_DATETIME));
        salSoSaveDTO.setCustContactName(storeInfo.getStoreManager());
        salSoSaveDTO.setCustContactTel(storeInfo.getStoreContPhone());
        salSoSaveDTO.setRecvContactName(storeInfo.getStoreManager());
        salSoSaveDTO.setRecvContactTel(storeInfo.getStoreContPhone());
        OrgAddrAddressRpcDTO addressRpcDTO = storeInfo.getAddressRpcDTO();
        if (addressRpcDTO != null) {
            salSoSaveDTO.setRecvCity(addressRpcDTO.getCity());
            salSoSaveDTO.setRecvCountry(addressRpcDTO.getCountry());
            salSoSaveDTO.setRecvCounty(addressRpcDTO.getCounty());
            salSoSaveDTO.setRecvProvince(addressRpcDTO.getProvince());
            salSoSaveDTO.setRecvDetailaddr(addressRpcDTO.getDetailAddr());
        }
        salSoSaveDTO.setRemark(demandOrderDTO.getDocCode());
        salSoSaveDTO.setCurrCode("CNY");
        salSoSaveDTO.setCurrName("\u4eba\u6c11\u5e01");
        salSoSaveDTO.setPaymentTerm(crmCustDTO.getPaymentTerm());
        salSoSaveDTO.setHomeCurr("CNY");
        salSoSaveDTO.setAgentEmpId(crmCustDTO.getAgentEmpId());
        salSoSaveDTO.setPreCustCode(crmCustDTO.getPreCustCode());
        salSoSaveDTO.setPreCustName(crmCustDTO.getPreCustName());
        salSoSaveDTO.setCustChannel(crmCustDTO.getSaleChannel());
        return salSoSaveDTO;
    }

    private SalSoDSaveDTO createSalSoDSaveDTO(ScpDemandOrderDDTO demandOrderDDTO, String demandOrderCode, ItmItemBusinessRpcDTO itmItemBusinessRpcDTO, Map<String, List<PriPriceRpcDTO>> groupedBasePriceList, Map<String, List<PriPriceRpcDTO>> groupedPriceList, AtomicReference<String> errorLog, CustBelongOuDTO custBelongOuDTO) {
        SalSoDSaveDTO salSoDSaveDTO = new SalSoDSaveDTO();
        salSoDSaveDTO.setItemId(demandOrderDDTO.getItemId());
        salSoDSaveDTO.setItemCode(demandOrderDDTO.getItemCode());
        salSoDSaveDTO.setItemBrand(itmItemBusinessRpcDTO.getBrand());
        salSoDSaveDTO.setItemName(demandOrderDDTO.getItemName());
        salSoDSaveDTO.setQty(SysUtils.processQtyScale(demandOrderDDTO.getQty2()));
        salSoDSaveDTO.setWhId(demandOrderDDTO.getSuppWhId());
        salSoDSaveDTO.setWhCode(demandOrderDDTO.getSuppWhCode());
        salSoDSaveDTO.setWhName(demandOrderDDTO.getSuppWhName());
        salSoDSaveDTO.setUom(demandOrderDDTO.getUom2());
        salSoDSaveDTO.setPrice(demandOrderDDTO.getPrice());
        List<PriPriceRpcDTO> basePriceDTOS = groupedBasePriceList.get(demandOrderDDTO.getItemCode());
        if (CollUtil.isEmpty(basePriceDTOS)) {
            errorLog.set("\u5546\u54c1\u7f16\u7801\uff1a" + demandOrderDDTO.getItemCode() + "\u516c\u53f8\u7f16\u7801\uff1a" + custBelongOuDTO.getOuCode() + "\u5ba2\u6237\u7f16\u7801:" + custBelongOuDTO.getCustCode() + "\u6ca1\u6709\u914d\u7f6e\u57fa\u51c6\u4ef7\u683c");
            return salSoDSaveDTO;
        }
        salSoDSaveDTO.setBasePrice(basePriceDTOS.get(0).getPrice());
        List<PriPriceRpcDTO> priceRpcDTOS = groupedPriceList.get(demandOrderDDTO.getItemCode());
        if (CollUtil.isEmpty(priceRpcDTOS)) {
            errorLog.set("\u5546\u54c1\u7f16\u7801\uff1a" + demandOrderDDTO.getItemCode() + "\u516c\u53f8\u7f16\u7801\uff1a" + custBelongOuDTO.getOuCode() + "\u5ba2\u6237\u7f16\u7801:" + custBelongOuDTO.getCustCode() + "\u6ca1\u6709\u914d\u7f6e\u9500\u552e\u4ef7\u683c");
            return salSoDSaveDTO;
        }
        salSoDSaveDTO.setSalePrice(priceRpcDTOS.get(0).getPrice());
        salSoDSaveDTO.setRefPrice(demandOrderDDTO.getPrice());
        salSoDSaveDTO.setTaxRateNo(itmItemBusinessRpcDTO.getTaxCode());
        salSoDSaveDTO.setRootDocId(demandOrderDDTO.getMasId());
        salSoDSaveDTO.setRootDocNo(demandOrderCode);
        salSoDSaveDTO.setRootDocCls("BTB");
        salSoDSaveDTO.setRootDocDId(demandOrderDDTO.getId());
        salSoDSaveDTO.setRootDocLineno(Long.valueOf(demandOrderDDTO.getLineNo().longValue()));
        salSoDSaveDTO.setTaxRate(itmItemBusinessRpcDTO.getTaxRate2());
        BigDecimal netPrice = salSoDSaveDTO.getPrice().divide(salSoDSaveDTO.getTaxRate().add(BigDecimal.ONE), (int)SysUtils.getPricePlace(), RoundingMode.HALF_UP);
        salSoDSaveDTO.setNetPrice(netPrice);
        BigDecimal netAmt = SysUtils.processQtyScale(netPrice.multiply(salSoDSaveDTO.getQty()));
        salSoDSaveDTO.setNetAmt(netAmt);
        BigDecimal amt = SysUtils.processAmtScale(salSoDSaveDTO.getPrice().multiply(salSoDSaveDTO.getQty()));
        salSoDSaveDTO.setAmt(amt);
        salSoDSaveDTO.setTaxAmt(amt.subtract(netAmt));
        salSoDSaveDTO.setSuppFlag("0");
        salSoDSaveDTO.setQty2(demandOrderDDTO.getPlanQuantity());
        salSoDSaveDTO.setUom2(demandOrderDDTO.getUnit());
        return salSoDSaveDTO;
    }

    private void handleSalePrice(Map<String, List<PriPriceRpcDTO>> groupedBasePriceList, Map<String, List<PriPriceRpcDTO>> groupedPriceList, List<ItmItemBusinessRpcDTO> itemList, CustBaseAndBelongOuDTO custInfo, String ouCode) {
        List<ItmPriPriceRpcDtoParam> priceParams = itemList.stream().map(item -> {
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls("SALE_PRICE");
            priceParam.setItemId(item.getId());
            priceParam.setCustCode(custInfo.getCustCode());
            priceParam.setItemCode(item.getItemCode());
            priceParam.setUom(item.getUom());
            priceParam.setCurrCode("CNY");
            priceParam.setOuCode(ouCode);
            if (StrUtil.isNotBlank((CharSequence)custInfo.getSaleChannel())) {
                priceParam.setSaleChannel(custInfo.getSaleChannel());
            }
            return priceParam;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> priceList = this.rmiPriceRpcService.findPriceByParam(priceParams);
        ArrayList<ItmPriPriceRpcDtoParam> basePriceParams = new ArrayList<ItmPriPriceRpcDtoParam>();
        for (ItmPriPriceRpcDtoParam e : priceParams) {
            e.setPriceType("RETAIL_PRICE");
            e.setPriceCls("");
            basePriceParams.add(e);
        }
        List<PriPriceRpcDTO> basePriceList = this.rmiPriceRpcService.findPriceByParam(basePriceParams);
        groupedBasePriceList.putAll(basePriceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode)));
        groupedPriceList.putAll(priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode)));
    }

    private void computeAndUpdateAllocation(String unique, List<ScpDemandOrderComputeVO> computeDemandOrderList, BigDecimal sumAvalQty, String allocComputeConfig) {
        this.eventContext.consumeEventInvStk(computeDemandOrderList, sumAvalQty, allocComputeConfig);
        this.updateAllocationQuantity(unique, computeDemandOrderList, sumAvalQty);
    }

    private void updateAllocationQuantity(String unique, List<ScpDemandOrderComputeVO> computeDemandOrderList, BigDecimal sumAvalQty) {
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(trans -> {
            try {
                computeDemandOrderList.forEach(row -> {
                    log.info("\u3010\u8ba2\u8d27\u5355\u81ea\u52a8\u5206\u914d\u3011\u8ba2\u8d27\u8ba2\u5355\u7f16\u7801\uff1a{},\u5546\u54c1\u7f16\u7801\uff1a{},\u5e93\u5b58\u7f16\u7801\uff1a{},\u5206\u914d\u6570\u91cf\uff1a{}", new Object[]{row.getDocCode(), row.getItemCode(), row.getSuppWhCode(), row.getPlanQuantity()});
                    this.scpDemandOrderDDomainService.updatePlanQtyAndAmtById(row.getId(), row.getPlanQuantity());
                });
                BigDecimal sumPlanQty = computeDemandOrderList.stream().collect(Collectors.reducing(BigDecimal.ZERO, ScpDemandOrderComputeVO::getPlanQuantity, BigDecimal::add));
                this.redisTemplate.opsForValue().set((Object)unique, (Object)sumAvalQty.subtract(sumPlanQty).toString(), 300L, TimeUnit.SECONDS);
                return "OK";
            }
            catch (Exception e) {
                trans.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, e.getMessage());
            }
        });
    }

    private Map<String, List<SupportTransactionPathRpcDTO>> checkTransactionPathAndBuild(List<SupportTransactionPathRpcParam> rpcParams) {
        log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84,\u53c2\u6570:{}", (Object)JSONObject.toJSONString(rpcParams));
        List data = (List)this.supportTransactionPathRpcService.queryListByParam(rpcParams).getData();
        log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
        if (CollUtil.isEmpty((Collection)data)) {
            return new HashMap<String, List<SupportTransactionPathRpcDTO>>();
        }
        return data.stream().collect(Collectors.groupingBy(row -> row.getCompanyIdStart() + "@" + row.getCompanyIdEnd()));
    }

    private BigDecimal sumBigDecimal(SalSoSaveDTO payload, Function<SalSoDSaveDTO, BigDecimal> function) {
        return payload.getSalSoDSaveVOList().stream().map(function).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static List<Long> collectRelateDocDid(List<StoreOrderTrnRpcDTO> data) {
        return data.stream().flatMap(dto -> dto.getDetails().stream()).map(StoreOrderTrnRpcDTO.StoreOrderTrnRpcDTODetail::getRelateDocDid).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<Long> collectRelateDocDidPo(List<PurPoSaveDTO> data) {
        return data.stream().flatMap(dto -> dto.getPurPoDCreateParamVOList().stream()).map(PurPoDSaveDTO::getRelateDocDid).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void processTrnInfoMsg(List<StoreOrderTrnResultDTO> result) {
        log.info("\u56de\u5199\u521b\u5efa\u8c03\u62e8\u4fe1\u606f\uff1a{}", (Object)JSONUtil.toJsonStr(result));
        if (CollUtil.isNotEmpty(result)) {
            for (StoreOrderTrnResultDTO dto : result) {
                Long did = dto.getOrderDid();
                String errorMsg = dto.getErrorMsg();
                if (dto.isSuccess()) continue;
                this.scpDemandOrderDDomainService.updateErrorMsg(did, errorMsg);
            }
        }
    }

    @Override
    public List<PurPoSaveDTO> prepareDataPoPush(ScpDemandOrderDTO demandOrderDTO, Map<String, List<OrgStoreWhDTO>> haveWhStoreMap, Long employeeId, List<ScpDemandOrderDDTO> demandOrderDList, ScpOrderSettingRespVO setting) {
        CopyOnWriteArrayList poResult = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        String whCode = "";
        if (ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(demandOrderDTO.getType())) {
            whCode = demandOrderDTO.getDemandWhStCode();
        } else if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(demandOrderDTO.getType())) {
            List<OrgStoreWhDTO> orgStoreWhDTOS1 = haveWhStoreMap.get(demandOrderDTO.getDemandWhStCode());
            if (CollUtil.isEmpty(orgStoreWhDTOS1)) {
                log.info("\u8ba2\u8d27\u5355\u7f16\u7801\uff1a{},\u95e8\u5e97\u7f16\u7801\uff1a{},\u672a\u914d\u7f6e\u771f\u5b9e\u4ed3\u5e93", (Object)demandOrderDTO.getDocCode(), (Object)demandOrderDTO.getDemandWhStCode());
                List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u95e8\u5e97\u7f16\u7801:" + demandOrderDTO.getDemandWhStCode() + "\u672a\u914d\u7f6e\u771f\u5b9e\u4ed3\u5e93");
                return new ArrayList<PurPoSaveDTO>();
            }
            Optional<OrgStoreWhDTO> priorityWhDto = ScpDemandOrderServiceImpl.findMinWhLevelElement(orgStoreWhDTOS1);
            if (priorityWhDto.isPresent()) {
                whCode = priorityWhDto.get().getWhCode();
            } else {
                log.info("\u8ba2\u8d27\u5355\u7f16\u7801\uff1a{},\u95e8\u5e97\u7f16\u7801:{},\u672a\u914d\u7f6e\u6700\u9ad8\u4f18\u5148\u7ea7\u771f\u5b9e\u4ed3\u5e93", (Object)demandOrderDTO.getDocCode(), (Object)demandOrderDTO.getDemandWhStCode());
                List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u95e8\u5e97\u7f16\u7801:" + demandOrderDTO.getDemandWhStCode() + "\u672a\u914d\u7f6e\u6700\u9ad8\u4f18\u5148\u7ea7\u771f\u5b9e\u4ed3\u5e93");
                return new ArrayList<PurPoSaveDTO>();
            }
        }
        demandOrderDList = demandOrderDList.stream().filter(row -> row.getIsPushed() == false && row.getIsCalculated() != false && row.getPlanQuantity().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (demandOrderDList.isEmpty()) {
            log.info("\u8ba2\u8d27\u5355Id:{},\u6ca1\u6709\u8ba2\u8d27\u5355\u660e\u7ec6,\u8df3\u8fc7\u5904\u7406", (Object)demandOrderDTO.getId());
            List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u6ca1\u6709\u8ba2\u8d27\u5355\u660e\u7ec6,\u8df3\u8fc7\u5904\u7406");
            return new ArrayList<PurPoSaveDTO>();
        }
        demandOrderDList.forEach(row -> row.setCurrency("CNY"));
        Map<String, Map<String, List<ScpDemandOrderDDTO>>> orderDMap = ScpDemandOrderServiceImpl.groupByOuCodeAndSuppWhCode(demandOrderDList);
        ArrayList<String> purOuCodes = new ArrayList<String>(orderDMap.keySet());
        Map<String, OrgOuRpcSimpleDTO> ouCodeBuIdMap = this.rmiOrgOuService.findOuDtoMapByOuCodes(purOuCodes);
        log.info("whCode\u7684\u503c:{}", (Object)whCode);
        for (Map.Entry<String, Map<String, List<ScpDemandOrderDDTO>>> stringMapEntry : orderDMap.entrySet()) {
            String ouCode = stringMapEntry.getKey();
            for (Map.Entry<String, List<ScpDemandOrderDDTO>> entry : stringMapEntry.getValue().entrySet()) {
                String suppCode = entry.getKey();
                PurPoSaveDTO dto = new PurPoSaveDTO();
                dto.setPoSource("OB");
                dto.setDocStatus("APPING");
                dto.setDemandDate(demandOrderDTO.getDemandDate());
                dto.setOuCode(ouCode);
                OrgOuRpcSimpleDTO ouInfo = ouCodeBuIdMap.get(ouCode);
                dto.setOuId(ouInfo.getId());
                dto.setSuppCode(suppCode);
                dto.setWhCode(whCode);
                dto.setAgentEmpId(employeeId);
                dto.setBuId(ouInfo.getBuId());
                dto.setRelateDocId(demandOrderDTO.getId());
                dto.setRelateDocNo(demandOrderDTO.getDocCode());
                dto.setRelateDocCls("OB");
                dto.setDemandType(demandOrderDTO.getType());
                dto.setStoreCode(demandOrderDTO.getDemandWhStCode());
                dto.setStoreName(demandOrderDTO.getDemandWhStName());
                dto.setRootDocId(demandOrderDTO.getId());
                dto.setRootDocNo(demandOrderDTO.getDocCode());
                dto.setRootDocCls("OB");
                dto.setCurrCode("CNY");
                dto.setBusinessType(demandOrderDTO.getBusinessType());
                dto.setEtaDate(demandOrderDTO.getEtaDate());
                List<ScpDemandOrderDDTO> demandOrderDDTOList = entry.getValue();
                Map<String, List<ScpDemandOrderDDTO>> ouCodeGroup = demandOrderDDTOList.stream().peek(row -> {
                    if (StringUtils.isBlank((String)row.getOuCode())) {
                        row.setOuCode("");
                    }
                }).collect(Collectors.groupingBy(ScpDemandOrderDDTO::getOuCode));
                ouCodeGroup.forEach((key, value) -> {
                    ArrayList<PurPoDSaveDTO> purPoDCreateParamVOList = new ArrayList<PurPoDSaveDTO>();
                    PurPoSaveDTO storeOrderTrnRpcDTO = new PurPoSaveDTO();
                    BeanUtils.copyProperties((Object)dto, (Object)storeOrderTrnRpcDTO, (String[])new String[0]);
                    if (storeOrderTrnRpcDTO.getBusinessType().equals(ScpUdcEnum.BUSINESS_TYPE_50.getValueCode())) {
                        storeOrderTrnRpcDTO.setPaymentStatus(UdcEnum.getValueCodeByName((String)"yst-purc", (String)"PAYMENT_STATUS", (String)"\u5f85\u652f\u4ed8"));
                    }
                    HashSet<String> deliveryTypeSet = new HashSet<String>();
                    for (ScpDemandOrderDDTO demandOrderDDTO : demandOrderDDTOList) {
                        String deliveryType = demandOrderDDTO.getDeliveryType();
                        deliveryTypeSet.add(deliveryType);
                        PurPoDSaveDTO purPoDSaveDTO = new PurPoDSaveDTO();
                        purPoDSaveDTO.setItemId(demandOrderDDTO.getItemId());
                        purPoDSaveDTO.setCurrCode(demandOrderDDTO.getCurrency());
                        purPoDSaveDTO.setItemCode(demandOrderDDTO.getItemCode());
                        purPoDSaveDTO.setItemName(demandOrderDDTO.getItemName());
                        purPoDSaveDTO.setQty(demandOrderDDTO.getPlanQuantity());
                        purPoDSaveDTO.setUom(demandOrderDDTO.getUnit());
                        purPoDSaveDTO.setRelateDocId(demandOrderDTO.getId());
                        purPoDSaveDTO.setRelateDocNo(demandOrderDTO.getDocCode());
                        purPoDSaveDTO.setRelateDocCls("OB");
                        purPoDSaveDTO.setRelateDocDid(demandOrderDDTO.getId());
                        purPoDSaveDTO.setRelateDocLineno(demandOrderDDTO.getLineNo());
                        if (demandOrderDDTO.getProjectFeeFlag() != null && demandOrderDDTO.getProjectFeeFlag().booleanValue()) {
                            purPoDSaveDTO.setLineType("SF");
                        } else {
                            purPoDSaveDTO.setLineType("standard");
                        }
                        purPoDSaveDTO.setOriginPrice(demandOrderDDTO.getSalePrice());
                        purPoDSaveDTO.setLastPathSalePrice(demandOrderDDTO.getSettlementSalePrice());
                        purPoDSaveDTO.setLastPathSaleAmt(demandOrderDDTO.getSettlementSaleAmt());
                        purPoDSaveDTO.setLastPathSaleTotalPrice(demandOrderDDTO.getSettlementPrice());
                        purPoDSaveDTO.setLastPathSaleTotalAmt(demandOrderDDTO.getSettlementAmt());
                        purPoDSaveDTO.setFreightRate(demandOrderDDTO.getFreightRatio());
                        purPoDSaveDTO.setTechFee(demandOrderDDTO.getTechFee());
                        purPoDSaveDTO.setMarketingFee(demandOrderDDTO.getMarketingFee());
                        purPoDSaveDTO.setOperationFee(demandOrderDDTO.getOperationFee());
                        purPoDSaveDTO.setTefPrice(demandOrderDDTO.getTefPrice());
                        purPoDSaveDTO.setMefPrice(demandOrderDDTO.getMefPrice());
                        purPoDSaveDTO.setOefPrice(demandOrderDDTO.getOefPrice());
                        purPoDSaveDTO.setTefFeeOuCode(demandOrderDDTO.getTefFeeOuCode());
                        purPoDSaveDTO.setMefFeeOuCode(demandOrderDDTO.getMefFeeOuCode());
                        purPoDSaveDTO.setOefFeeOuCode(demandOrderDDTO.getOefFeeOuCode());
                        purPoDCreateParamVOList.add(purPoDSaveDTO);
                    }
                    storeOrderTrnRpcDTO.setPurPoDCreateParamVOList(purPoDCreateParamVOList);
                    if (!deliveryTypeSet.isEmpty()) {
                        String join = String.join((CharSequence)",", deliveryTypeSet);
                        storeOrderTrnRpcDTO.setSceneTypeCode(join);
                    }
                    poResult.add(storeOrderTrnRpcDTO);
                });
            }
        }
        String redisKey = "PO" + demandOrderDTO.getId().toString();
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)"20", 3L, TimeUnit.DAYS);
        return poResult;
    }

    public static Map<String, Map<String, List<ScpDemandOrderDDTO>>> groupByOuCodeAndSuppWhCode(List<ScpDemandOrderDDTO> demandOrderDList) {
        return demandOrderDList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getOuCode, Collectors.groupingBy(ScpDemandOrderDDTO::getSuppWhCode)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<StoreOrderTrnRpcDTO> prepareDataTrnPush(ScpDemandOrderDTO demandOrderDTO, Map<String, List<OrgStoreWhDTO>> haveWhStoreMap, Map<Long, InvWhRpcSimpleDTO> whIdMap, Long employeeId, List<ScpDemandOrderDDTO> demandOrderDList, ScpOrderSettingRespVO setting) {
        CopyOnWriteArrayList result = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        Long inWhId = null;
        String inWhCode = "";
        Long inOuId = null;
        String inOuCode = null;
        if (ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(demandOrderDTO.getType())) {
            inWhId = demandOrderDTO.getDemandWhStId();
            inWhCode = demandOrderDTO.getDemandWhStCode();
            if (!whIdMap.containsKey(inWhId)) {
                log.info("\u8ba2\u8d27\u5355\u7f16\u7801\uff1a{},\u4ed3\u5e93\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)demandOrderDTO.getDocCode());
                List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u4ed3\u5e93:" + inWhCode + "\u4fe1\u606f\u4e0d\u5b58\u5728");
                return new ArrayList<StoreOrderTrnRpcDTO>();
            }
            inOuId = whIdMap.get(inWhId).getOuId();
            inOuCode = whIdMap.get(inWhId).getOuCode();
        } else if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(demandOrderDTO.getType())) {
            List<OrgStoreWhDTO> orgStoreWhDTOS1 = haveWhStoreMap.get(demandOrderDTO.getDemandWhStCode());
            if (CollUtil.isEmpty(orgStoreWhDTOS1)) {
                log.info("\u8ba2\u8d27\u5355\u7f16\u7801\uff1a{},\u95e8\u5e97\u7f16\u7801\uff1a{},\u672a\u914d\u7f6e\u771f\u5b9e\u4ed3\u5e93", (Object)demandOrderDTO.getDocCode(), (Object)demandOrderDTO.getDemandWhStCode());
                List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u95e8\u5e97\u7f16\u7801:" + demandOrderDTO.getDemandWhStCode() + "\u672a\u914d\u7f6e\u771f\u5b9e\u4ed3\u5e93");
                return new ArrayList<StoreOrderTrnRpcDTO>();
            }
            Optional<OrgStoreWhDTO> priorityWhDto = ScpDemandOrderServiceImpl.findMinWhLevelElement(orgStoreWhDTOS1);
            if (!priorityWhDto.isPresent()) {
                log.info("\u8ba2\u8d27\u5355\u7f16\u7801\uff1a{},\u95e8\u5e97\u7f16\u7801:{},\u672a\u914d\u7f6e\u6700\u9ad8\u4f18\u5148\u7ea7\u771f\u5b9e\u4ed3\u5e93", (Object)demandOrderDTO.getDocCode(), (Object)demandOrderDTO.getDemandWhStCode());
                List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u95e8\u5e97\u7f16\u7801:" + demandOrderDTO.getDemandWhStCode() + "\u672a\u914d\u7f6e\u6700\u9ad8\u4f18\u5148\u7ea7\u771f\u5b9e\u4ed3\u5e93");
                return new ArrayList<StoreOrderTrnRpcDTO>();
            }
            inWhCode = priorityWhDto.get().getWhCode();
            log.info("\u9ad8\u4f18\u5148\u7ea7\u4ed3\u5e93,inWhCode\u7684\u503c:{}", (Object)inWhCode);
            InvWhRpcSimpleDTO whInfoByCode = this.getWhInfoByCode(inWhCode);
            log.info("whInfoByCode\u7684\u503c:{}", (Object)JSONUtil.toJsonStr((Object)whInfoByCode));
            if (whInfoByCode != null) {
                inOuId = whInfoByCode.getOuId();
                inOuCode = whInfoByCode.getOuCode();
            }
        }
        demandOrderDList = demandOrderDList.stream().filter(row -> row.getIsPushed() == false && !"SUPP".equals(row.getSupplyType()) && row.getIsCalculated() != false && row.getPlanQuantity().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (demandOrderDList.isEmpty()) {
            log.info("\u8ba2\u8d27\u5355Id:{},\u6ca1\u6709\u8ba2\u8d27\u5355\u660e\u7ec6,\u8df3\u8fc7\u5904\u7406", (Object)demandOrderDTO.getId());
            List<Long> dIdList = demandOrderDList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            this.scpDemandOrderDDomainService.updateSyncMsg(dIdList, "\u6ca1\u6709\u8ba2\u8d27\u5355\u660e\u7ec6,\u8df3\u8fc7\u5904\u7406");
            return new ArrayList<StoreOrderTrnRpcDTO>();
        }
        List<Long> suppWhIds = demandOrderDList.stream().map(ScpDemandOrderDDTO::getSuppWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Long, InvWhRpcSimpleDTO> suppWhIdMap = this.rmiInvStkService.findInvWhBaseMap(suppWhIds);
        log.info("\u4f9b\u5e94\u5546\u4ed3\u5e93\u6570\u636ewhIdMap:{}", (Object)JSONUtil.toJsonStr(suppWhIdMap));
        Map<Long, List<ScpDemandOrderDDTO>> orderDMap = demandOrderDList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getSuppWhId));
        log.info("inWhId:{},inWhCode:{},inOuId:{},inOuCode:{}", new Object[]{inWhId, inWhCode, inOuId, inOuCode});
        Iterator<Map.Entry<Long, List<ScpDemandOrderDDTO>>> iterator = orderDMap.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String redisKey = "TRN" + demandOrderDTO.getId().toString();
                this.redisTemplate.opsForValue().set((Object)redisKey, (Object)"20", 3L, TimeUnit.DAYS);
                return result;
            }
            Map.Entry<Long, List<ScpDemandOrderDDTO>> entry = iterator.next();
            StoreOrderTrnRpcDTO dto = new StoreOrderTrnRpcDTO();
            dto.setApplyEmpId(employeeId);
            dto.setApplyDate(LocalDateTime.now());
            dto.setInOuId(inOuId);
            dto.setInOuCode(inOuCode);
            if (inWhId != null) {
                dto.setInWhId(inWhId);
            }
            dto.setInWhCode(inWhCode);
            dto.setOutWhId(entry.getKey());
            dto.setOutWhCode(entry.getValue().get(0).getSuppWhCode());
            if (suppWhIdMap.containsKey(entry.getKey())) {
                InvWhRpcSimpleDTO whRpcSimpleDTO = suppWhIdMap.get(entry.getKey());
                dto.setOutOuId(whRpcSimpleDTO.getOuId());
                dto.setOutOuCode(whRpcSimpleDTO.getOuCode());
            }
            dto.setRelateDocId(demandOrderDTO.getId());
            dto.setRelateDocNo(demandOrderDTO.getDocCode());
            dto.setOrderSetId(demandOrderDTO.getDemandId());
            dto.setRelateDocCls("OB");
            dto.setDemandType(demandOrderDTO.getType());
            dto.setInStoreCode(demandOrderDTO.getDemandWhStCode());
            List<ScpDemandOrderDDTO> demandOrderDDTOList = entry.getValue();
            Map<String, List<ScpDemandOrderDDTO>> ouCodeGroup = demandOrderDDTOList.stream().peek(row -> {
                if (StringUtils.isBlank((String)row.getOuCode())) {
                    row.setOuCode("");
                }
            }).collect(Collectors.groupingBy(ScpDemandOrderDDTO::getOuCode));
            dto.setOrderBusinessType(demandOrderDTO.getBusinessType());
            dto.setEtaDate(demandOrderDTO.getEtaDate());
            ouCodeGroup.forEach((key, value) -> {
                ArrayList<StoreOrderTrnRpcDTO.StoreOrderTrnRpcDTODetail> itemList = new ArrayList<StoreOrderTrnRpcDTO.StoreOrderTrnRpcDTODetail>();
                StoreOrderTrnRpcDTO storeOrderTrnRpcDTO = new StoreOrderTrnRpcDTO();
                BeanUtils.copyProperties((Object)dto, (Object)storeOrderTrnRpcDTO, (String[])new String[0]);
                HashSet<String> deliveryTypeSet = new HashSet<String>();
                for (ScpDemandOrderDDTO demandOrderDDTO : value) {
                    String deliveryType = demandOrderDDTO.getDeliveryType();
                    deliveryTypeSet.add(deliveryType);
                    StoreOrderTrnRpcDTO.StoreOrderTrnRpcDTODetail storeOrderTrnRpcDTODetail = new StoreOrderTrnRpcDTO.StoreOrderTrnRpcDTODetail();
                    storeOrderTrnRpcDTODetail.setItemId(demandOrderDDTO.getItemId());
                    storeOrderTrnRpcDTODetail.setGiftLineFlag(demandOrderDDTO.getGiftLineFlag());
                    storeOrderTrnRpcDTODetail.setQty(demandOrderDDTO.getPlanQuantity());
                    storeOrderTrnRpcDTODetail.setUom(demandOrderDDTO.getUnit());
                    storeOrderTrnRpcDTODetail.setRelateDocDid(demandOrderDDTO.getId());
                    storeOrderTrnRpcDTODetail.setOriginPrice(demandOrderDDTO.getSalePrice());
                    storeOrderTrnRpcDTODetail.setPrice(demandOrderDDTO.getSettlementSalePrice());
                    storeOrderTrnRpcDTODetail.setTotalPrice(demandOrderDDTO.getSettlementPrice());
                    storeOrderTrnRpcDTODetail.setLastPathSaleAmt(demandOrderDDTO.getSettlementSaleAmt());
                    storeOrderTrnRpcDTODetail.setLastPathSaleTotalAmt(demandOrderDDTO.getSettlementAmt());
                    storeOrderTrnRpcDTODetail.setFreightRate(demandOrderDDTO.getFreightRatio());
                    storeOrderTrnRpcDTODetail.setRelateDocLineno(Integer.valueOf(demandOrderDDTO.getLineNo().intValue()));
                    storeOrderTrnRpcDTODetail.setTefPrice(demandOrderDDTO.getTefPrice());
                    storeOrderTrnRpcDTODetail.setMefPrice(demandOrderDDTO.getMefPrice());
                    storeOrderTrnRpcDTODetail.setOefPrice(demandOrderDDTO.getOefPrice());
                    storeOrderTrnRpcDTODetail.setTefFee(demandOrderDDTO.getTechFee());
                    storeOrderTrnRpcDTODetail.setMefFee(demandOrderDDTO.getMarketingFee());
                    storeOrderTrnRpcDTODetail.setOefFee(demandOrderDDTO.getOperationFee());
                    storeOrderTrnRpcDTODetail.setTefFeeOuCode(demandOrderDDTO.getTefFeeOuCode());
                    storeOrderTrnRpcDTODetail.setMefFeeOuCode(demandOrderDDTO.getMefFeeOuCode());
                    storeOrderTrnRpcDTODetail.setOefFeeOuCode(demandOrderDDTO.getOefFeeOuCode());
                    itemList.add(storeOrderTrnRpcDTODetail);
                }
                storeOrderTrnRpcDTO.setDetails(itemList);
                if (!deliveryTypeSet.isEmpty()) {
                    String join = String.join((CharSequence)",", deliveryTypeSet);
                    storeOrderTrnRpcDTO.setDocType(join);
                }
                result.add(storeOrderTrnRpcDTO);
            });
        }
    }

    private InvWhRpcSimpleDTO getWhInfoByCode(String whCode) {
        Map<String, InvWhRpcSimpleDTO> invWhBaseMapByCode = this.rmiInvStkService.findInvWhBaseMapByCode(List.of(whCode));
        return invWhBaseMapByCode.get(whCode);
    }

    public static Optional<OrgStoreWhDTO> findMinWhLevelElement(List<OrgStoreWhDTO> orgStoreWhDTOs) {
        return orgStoreWhDTOs.stream().min(Comparator.comparingInt(OrgStoreWhDTO::getWhLevel));
    }

    @Override
    public ScpDemandSetSelectRespVO getScpDemandSetSelectRespVO(String type, String storeCode) {
        ScpDemandSetParamVO orderSetParam = ScpDemandSetParamVO.builder().build();
        orderSetParam.setIsPushed(false);
        orderSetParam.setType(type);
        orderSetParam.setStatus(true);
        orderSetParam.setStoreCode(storeCode);
        orderSetParam.setDemandDate(LocalDateTime.now().toLocalDate().atStartOfDay());
        List orderSetList = this.scpDemandSetDomainService.findDemandSetByParam(orderSetParam).stream().map(ScpDemandSetConvert.INSTANCE::dtoToSelectRespVO).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(orderSetList)) {
            orderSetParam.setStoreCode(null);
            orderSetParam.setNotUseStoreFlag(true);
            orderSetList = this.scpDemandSetDomainService.findDemandSetByParam(orderSetParam).stream().map(ScpDemandSetConvert.INSTANCE::dtoToSelectRespVO).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(orderSetList)) {
                throw new BusinessException("\u672a\u627e\u5230\u6709\u6548\u7684\u8ba2\u8d27\u96c6");
            }
        }
        return (ScpDemandSetSelectRespVO)orderSetList.get(0);
    }

    public ScpDemandOrderServiceImpl(EventContext eventContext, RmiItemService rmiItemService, RmiSalRpcService rmiSalRpcService, RmiPurRpcService rmiPurRpcService, RmiOrderRpcService orderRpcService, RmiInvStkRpcService rmiInvStkService, RmiSysSettingService rmiSysSettingService, RmiSysUserRpcService rmiSysUserRpcService, TransactionTemplate transactionTemplate, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiPriceRpcService rmiPriceRpcService, ScpWhNetRelationService scpWhNetRelationService, ScpSupplyAllocationService scpSupplyAllocationService, ScpDemandSetDomainService scpDemandSetDomainService, ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, SupportTransactionPathRpcService supportTransactionPathRpcService, ScpOrderSettingDomainService scpOrderSettingDomainService, StoreOrderTroProvider storeOrderTroProvider, RmiOrgOuService rmiOrgOuService, RedisTemplate<String, Object> redisTemplate, MessageQueueTemplate messageQueueTemplate, ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc, ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService, RmiInvStkRpcService rmiInvStkRpcService, ScpDemandOrderRepo scpDemandOrderRepo, ScpDemandOrderDRepo scpDemandOrderDRepo, JPAQueryFactory jpaQueryFactory, WorkflowService workflowService, TransactionCommitHandler transactionCommitHandler, CommonPriceService commonPriceService, ScpCateItemRepoProc scpCateItemRepoProc, ScpsmanInfoRepo scpsmanInfoRepo, StoreOrderTrnProvider storeOrderTrnProvider, PurPoProvider purPoProvider) {
        this.eventContext = eventContext;
        this.rmiItemService = rmiItemService;
        this.rmiSalRpcService = rmiSalRpcService;
        this.rmiPurRpcService = rmiPurRpcService;
        this.orderRpcService = orderRpcService;
        this.rmiInvStkService = rmiInvStkService;
        this.rmiSysSettingService = rmiSysSettingService;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.transactionTemplate = transactionTemplate;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiPriceRpcService = rmiPriceRpcService;
        this.scpWhNetRelationService = scpWhNetRelationService;
        this.scpSupplyAllocationService = scpSupplyAllocationService;
        this.scpDemandSetDomainService = scpDemandSetDomainService;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.supportTransactionPathRpcService = supportTransactionPathRpcService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.storeOrderTroProvider = storeOrderTroProvider;
        this.rmiOrgOuService = rmiOrgOuService;
        this.redisTemplate = redisTemplate;
        this.messageQueueTemplate = messageQueueTemplate;
        this.scpAllocSettingItemRepoProc = scpAllocSettingItemRepoProc;
        this.scpAllocSettingStoreDomainService = scpAllocSettingStoreDomainService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.scpDemandOrderRepo = scpDemandOrderRepo;
        this.scpDemandOrderDRepo = scpDemandOrderDRepo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.workflowService = workflowService;
        this.transactionCommitHandler = transactionCommitHandler;
        this.commonPriceService = commonPriceService;
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.scpsmanInfoRepo = scpsmanInfoRepo;
        this.storeOrderTrnProvider = storeOrderTrnProvider;
        this.purPoProvider = purPoProvider;
    }
}

