/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.support.provider.out.ItmItemCateUpdateMqParam;
import java.util.Collection;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ItmItemCateUpdateListener
implements MessageQueueListener<ItmItemCateUpdateMqParam> {
    private static final Logger log = LoggerFactory.getLogger(ItmItemCateUpdateListener.class);
    private final ScpCateItemRepoProc scpCateItemRepoProc;

    @NotEmpty
    public String[] channels() {
        return new String[]{"itm_item_spu_update"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull ItmItemCateUpdateMqParam itmItemCateUpdateMqParam) {
        log.info("\u5546\u54c1\u54c1\u7c7b\u53d8\u66f4\uff1a" + JSON.toJSONString((Object)itmItemCateUpdateMqParam));
        if (CollUtil.isEmpty((Collection)itmItemCateUpdateMqParam.getBrandCodes())) {
            log.info("\u5546\u54c1\u54c1\u7c7b\u53d8\u66f4\uff1a\u54c1\u724c\u4e3a\u7a7a");
            return;
        }
        String brand = String.join((CharSequence)";", itmItemCateUpdateMqParam.getBrandCodes());
        this.scpCateItemRepoProc.updateItemBrand(brand, itmItemCateUpdateMqParam.getRootCateId());
    }

    public ItmItemCateUpdateListener(ScpCateItemRepoProc scpCateItemRepoProc) {
        this.scpCateItemRepoProc = scpCateItemRepoProc;
    }
}

