/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.scp.application.facade.vo.param.app.AddressParamVO;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.utils.SysUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

@Component
public class CartRedisUtil {
    private static final Logger log = LoggerFactory.getLogger(CartRedisUtil.class);
    private final RedisTemplate redisClient;

    public BoundHashOperations<String, Object, Object> getStoreCartOps(String storeCode, String cartType, Long userId) {
        String cartKey = "SCP:CART:" + userId + ":" + storeCode + ":" + cartType;
        return this.redisClient.boundHashOps((Object)cartKey);
    }

    public ScpStoreCartDO getStoreCartItem(String itemKey, String storeCode, String cartType, Long userId) {
        BoundHashOperations<String, Object, Object> cartOps = this.getStoreCartOps(storeCode, cartType, userId);
        String redisValue = (String)cartOps.get((Object)SysUtils.generateRedisKey("SKU", itemKey));
        return (ScpStoreCartDO)JSON.parseObject((String)redisValue, ScpStoreCartDO.class);
    }

    public List<ScpStoreCartDO> getStoreCartItems(String storeCode, String cartType, Long userId) {
        BoundHashOperations<String, Object, Object> operations = this.getStoreCartOps(storeCode, cartType, userId);
        return ((List)Optional.ofNullable(operations.values()).orElse(new ArrayList())).stream().map(obj -> {
            String str = (String)obj;
            return (ScpStoreCartDO)JSON.parseObject((String)str, ScpStoreCartDO.class);
        }).collect(Collectors.toList());
    }

    public List<ScpStoreCartDO> getCheckedShoppingCartItems(String storeCode, String cartType, Long userId) {
        BoundHashOperations<String, Object, Object> operations = this.getStoreCartOps(storeCode, cartType, userId);
        return ((List)Optional.ofNullable(operations.values()).orElse(new ArrayList())).stream().map(obj -> {
            String str = (String)obj;
            return (ScpStoreCartDO)JSON.parseObject((String)str, ScpStoreCartDO.class);
        }).filter(row -> row.getSelectedStatus() == 1).collect(Collectors.toList());
    }

    public Set<String> scan(RedisTemplate<String, Object> redisTemplate, String pattern) {
        return (Set)redisTemplate.execute(connection -> {
            HashSet<String> keysTmp = new HashSet<String>();
            try (Cursor cursor = connection.scan(ScanOptions.scanOptions().match(pattern).count(10000L).build());){
                while (cursor.hasNext()) {
                    keysTmp.add(new String((byte[])cursor.next(), StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return keysTmp;
        });
    }

    public void updateUnSelectedStoreCartItems(String storeCode, Long userId, String cartType) {
        BoundHashOperations<String, Object, Object> cartOps = this.getStoreCartOps(storeCode, cartType, userId);
        List<ScpStoreCartDO> cartDOS = ((List)Optional.ofNullable(cartOps.values()).orElse(new ArrayList())).stream().map(obj -> {
            String str = (String)obj;
            return (ScpStoreCartDO)JSON.parseObject((String)str, ScpStoreCartDO.class);
        }).collect(Collectors.toList());
        cartDOS.forEach(row -> row.setSelectedStatus(0));
        cartOps.putAll(cartDOS.stream().collect(Collectors.toMap(row -> SysUtils.generateRedisKey("SKU", row.getCombineItemCode(), row.getItemCode()), row -> JSON.toJSONString((Object)row))));
    }

    public void clearCheckedStoreCartItems(String storeCode, Long userId, String cartType, String itemKey) {
        BoundHashOperations<String, Object, Object> cartOps = this.getStoreCartOps(storeCode, cartType, userId);
        cartOps.delete(new Object[]{SysUtils.generateRedisKey("SKU", itemKey)});
    }

    public AddressParamVO getAddr() {
        AddressParamVO addressParam = null;
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        assert (userDetails != null) : "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        String cacheKey = "DBO_ADDRESS_CACHE:" + userDetails.getUser().getUsername();
        String addressJson = (String)RedisUtils.instance().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)addressJson)) {
            addressParam = (AddressParamVO)JSON.parseObject((String)addressJson, AddressParamVO.class);
        }
        return addressParam;
    }

    public void delAddr() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        assert (userDetails != null) : "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        String cacheKey = "DBO_ADDRESS_CACHE:" + userDetails.getUser().getUsername();
        RedisUtils.instance().del(new String[]{cacheKey});
    }

    public CartRedisUtil(RedisTemplate redisClient) {
        this.redisClient = redisClient;
    }
}

