package com.elitesland.scp.application.facade.vo.template;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/4/29 09:34
 * @Description:
 */
@Data
@ApiModel(description = "应用模板")
public class DemandOrderApplyParamVO implements Serializable {

    @ApiModelProperty(value = "模板id", required = true)
    @NotEmpty(message = "模板id不允许为空")
    private List<Long> ids;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不允许为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "类型，0:门店，1:仓库", required = true)
    @NotBlank(message = "订货单类型不允许为空")
    private String type;

    //如果为BOH，说明为小程序，需要额外校验逻辑
    private String invoker;

    @ApiModelProperty(value = "单据类型", required = true)
    @NotBlank(message = "单据类型不允许为空")
    private String docType;

    @ApiModelProperty(value = "业务类型", required = true)
    @NotBlank(message = "业务类型不允许为空")
    private String businessType;
}
