package com.elitesland.scp.application.facade.vo.template;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * @Auther: Mark
 * @Date: 2024/5/9 15:08
 * @Description:
 */
@Data
@ApiModel(description = "订货模板导出结果")
public class ScpDemandTemplateExportRespVO implements Serializable {

    @ApiModelProperty("订货模板id")
    private Long id;

    @ApiModelProperty("订货模板编号")
    private String demandTemCode;

    @ApiModelProperty("订货模板名称")
    private String demandTemName;

    @ApiModelProperty("单据类型")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("要货类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String demandType;
    private String demandTypeName;

    @ApiModelProperty("起始日期")
    private Date startDate;

    @ApiModelProperty("截止日期")
    private Date endDate;

    @ApiModelProperty("详细日期")
    private String detailedTime;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private Integer demandTemStatus;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private String demandTemStatusName;

    @ApiModelProperty("商品种数")
    private BigDecimal typeNumber;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;


    //门店仓库区域信息
    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("类型名称")
    private String typeName;

    @ApiModelProperty("门店/仓库/区域id")
    private Long whStZoId;

    @ApiModelProperty("门店/仓库/区域编号")
    private String whStZoCode;

    @ApiModelProperty("门店/仓库/区域名称")
    private String whStZoName;

    @ApiModelProperty("详细地址")
    private String detailedAddress;

    @ApiModelProperty("所属组织编码")
    private String belongOrgCode;

    @ApiModelProperty("所属组织名称")
    private String belongOrgName;

    @ApiModelProperty("所属公司编码")
    private String belongOuCode;

    @ApiModelProperty("所属公司名称")
    private String belongOuName;

    @ApiModelProperty("经营性质")
    private String storeType;

    @ApiModelProperty("经营性质名称")
    private String storeTypeName;

    //商品信息
    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品分类/品类")
    private String itemCateCode;

    @ApiModelProperty("商品分类/品类名称")
    private String itemCateName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("基本计量单位")
    private String basicUnitMeasure;

    @ApiModelProperty("重量")
    private String weight;

    @ApiModelProperty("重量单位")
    private String weightUom;
    private String weightUomName;

    @ApiModelProperty("订货数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty("总重量")
    private String totalWeight;

}
