package com.elitesland.scp.application.service.whnet;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.whnet.*;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.param.ScpWhNetRelationParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: jeesie.jiang
 * @create: 2024-03-20
 * @Version 1.0
 **/
public interface ScpWhNetRelationService {


    /**
     * 仓网关系分页返回
     *
     * @param queryParam
     * @return
     */
    PagingVO<ScpWhNetRelationPageVO> page(ScpWhNetRelationPageParamVO queryParam);

    OuInfo findOuInfo(OuInfoQueryParamVO queryParam);


    /**
     * 仓网关系保存/修改
     *
     * @param createParam
     * @return
     */
    ApiResult<?> saveWhNetRelation(ScpWhNetRelationSaveVO createParam);

    /**
     * 查询同组合下明细
     * @param param
     * @return
     */
    List<ScpWhNetRelationRespVO> findWhNetList(ScpWhNetRelationBaseParamVO param);


    /**
     * 删除-逻辑
     * @param ids
     */
    void deleteWhNetRelation(List<Long> ids);


    /**
     * 仓网组合配置：（需求仓库/门店+品类+商品编码）
     * 查询仓网关系数据，根据传参，优先返回当前组合下的仓网配置，若为空则返回上一层级的仓网配置，依次类推
     * @param scpWhNetRelationRpcDtoParam
     * @return
     */
    List<ScpWhNetRelationRpcDTO> findWhNetRelationRpcDtoByParam(ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam);


    /**
     * 导出
     * @param queryParam
     * @return
     */
    PagingVO<ScpWhNetRelationExportRespVO> exportSearch(ScpWhNetRelationPageParamVO queryParam);

    List<String> executeImport(List<ScpWhNetRelationImportVO> dataList, int startRowIndex);

    PagingVO<ScpWhNetRelationPageVO> scpmanAuthorityPage(ScpWhNetRelationPageParamVO queryParam);

    /**
     * 根据需求仓库编码、类型、商品编码查询仓网关系
     *
     * @param demandWhStCode
     * @param type
     * @param storeCartDOS
     * @return
     */
    @Deprecated
    Map<String, List<ScpWhNetRelationRpcDTO>> findWhNetByParam(String demandWhStCode, String type, List<ScpStoreCartDO> storeCartDOS);

    Map<String, List<ScpWhNetRelationRpcDTO>> findNewWhNetByParam(String demandWhStCode, String type, List<ScpStoreCartDO> storeCartDOS);


    /**
     * 批量删除
     * @param ids
     */
    void batchDelete(List<Long> ids);

    List<String> findSaleOuInfo(String storeCode);

    /**
     * 根据门店+商品查询有效范围内的仓网关系
     * */
    List<ScpWhNetRelationRespVO> findValidWhNetRelationByParam(List<Long> itemIds, String storeCode, LocalDateTime dateTime);

    List<ScpWhNetRelationRespVO> findValidWhNetRelationByParam2(String itemType, String storeCode,LocalDateTime dateTime);

    List<ScpWhNetRelationRpcDTO> outFindWhNetRelationRpcDtoByParam(ScpWhNetRelationParam whNetRelationParam);
}