package com.elitesland.scp.domain.entity.scpsman;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:48
 * @Description:
 */
@Entity
@Table(name = "scpsman_info")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "scpsman_info", comment = "计划员信息表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "scpsman_info", description = "计划员信息表")
public class ScpsmanInfoDO extends BaseModel {

    private static final long serialVersionUID = -7649324985994842998L;
    @ApiModelProperty("计划员编号")
    @Column(name = "scpsman_no", columnDefinition = "varchar(30) default 0 comment '计划员编号'")
    private String scpsmanNo;

    @ApiModelProperty("计划员类型")
    @Column(name = "scpsman_type ", columnDefinition = "varchar(20) default 0 comment '计划员类型'")
    @BusinessParam(fieldPermissionEnabled = false)
    private String scpsmanType;

    @ApiModelProperty("业务类型")
    @Column(name = "business_type", columnDefinition = "varchar(100) default 0 comment '业务类型'")
    @BusinessParam(fieldPermissionEnabled = false)
    private String businessType;

    @ApiModelProperty("管辖区域")
    @Column(name = "jurisdiction", columnDefinition = "varchar(50) default 0 comment '管辖区域'")
    private String jurisdiction;

    @Comment(value = "是否管理所有区域", defaultValue = "0")
    @Column()
    @BusinessParam(fieldPermissionEnabled = false)
    private Boolean jurisdictionAll;

    @ApiModelProperty("登录账号")
    @Column(name = "login_account", columnDefinition = "varchar(30) comment '关联用户id'")
    private String loginAccount;

    @ApiModelProperty("公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(50) comment '公司名称'")
    private String ouName;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(30) comment '公司编码'")
    @BusinessParam(fieldPermissionEnabled = false)
    private String ouCode;

    @ApiModelProperty("公司id")
    @Column(name = "ou_id", columnDefinition = "bigint(30) comment '公司id'")
    private Long ouId;

    @ApiModelProperty("公司所属组织id")
    @Column(name = "org_id_belong", columnDefinition = "bigint(30) comment '公司所属组织id'")
    private Long orgIdBelong;

    @ApiModelProperty("头像文件编码")
    @Column(name = "file_code", columnDefinition = "varchar(50) comment '头像文件编码'")
    private String fileCode;

    @ApiModelProperty("启用状态")
    @Column(name = "enable_status", columnDefinition = "tinyint(3)")
    private Integer enableStatus;

    @ApiModelProperty("名称")
    @Column(name = "name", columnDefinition = "varchar(100) comment '名称'")
    private String name;

    @ApiModelProperty("创建方式")
    @Column(name = "source", columnDefinition = "varchar(100) comment 'ADD:新增计划员，EMP：绑定现有员工'")
    private String source;
}
