package com.elitesland.scp.domain.entity.survey;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

@Entity
@Table(name = "scp_survey_question", indexes = {
})
@Comment("问卷")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SurveyQuestionDO extends BaseModel implements Serializable {
    @Serial
    private static final long serialVersionUID = -4254921460115216468L;

    @ApiModelProperty("问卷ID")
    @Column(name = "suv_id")
    private Long suvId;

    @ApiModelProperty("问题类型")
    @Column(name = "qus_type")
    private String qusType;

    @ApiModelProperty("问题标题")
    @Column(name = "qus_title")
    private String qusTitle;

    @ApiModelProperty("序号")
    @Column(name = "sort_no")
    private Integer sortNo;

    @ApiModelProperty("是否必填")
    @Column(name = "required")
    private Boolean required;

}
