package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingBrandRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingBrandSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingBrandConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingBrandDO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingBrandRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingBrandRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;


@Slf4j
@Service
@RequiredArgsConstructor
public class ScpAllocSettingBrandDomainServiceImpl implements ScpAllocSettingBrandDomainService {

    private final ScpAllocSettingBrandRepo scpAllocSettingBrandRepo;
    private final ScpAllocSettingBrandRepoProc scpAllocSettingBrandRepoProc;

    @Override
    public List<ScpAllocSettingBrandRespVO> findByMasId(Long masId) {
        List<ScpAllocSettingBrandDO> settingItemDOS = scpAllocSettingBrandRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpAllocSettingBrandConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveAllocSettingBrand(List<ScpAllocSettingBrandSaveVO> saveVOS) {
        scpAllocSettingBrandRepo.saveAll(ScpAllocSettingBrandConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpAllocSettingBrandRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpAllocSettingBrandRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findMasIdByBrand(String brand, Set<Long> masIds) {
        return scpAllocSettingBrandRepoProc.findMasIdByBrand(brand, masIds);
    }
}
