package com.elitesland.scp.domain.vo.survey;

import com.elitesland.scp.enums.ScpUdcEnum;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(description = "问卷出参")
@Data
public class SurveyAnswerRespVO implements Serializable {

    private static final long serialVersionUID = 44067892996016803L;

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("问卷ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suvId;

    @ApiModelProperty("问题ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long qusId;

    @ApiModelProperty("选项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long optId;

    @ApiModelProperty("填空题")
    private String optContent;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("账号")
    private String username;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty("填写时间")
    private String fillTimeStr;

    @ApiModelProperty("问题类型")
    private String qusType;

    @ApiModelProperty("问题标题")
    private String qusTitle;

    @ApiModelProperty("问题排序")
    private Integer sortNo;

    @ApiModelProperty("选项")
    private String opContent;

    @ApiModelProperty("选项排序")
    private Integer opSortNo;

    @ApiModelProperty("填写时间")
    private LocalDateTime createTime;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("答案列表")
    private List<SurveyAnswerRespVO> answerList;

    public String getOuCodeAndSuvId(){
        return ouCode + ":" + suvId;
    }

    public String getQuestionAnswer(){
        return ScpUdcEnum.SURVEY_QUESTION_TYPE_30.getValueCode().equals(qusType) ? optContent : opContent;
    }

}
