/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.purLimit;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingRegionRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingRegionSaveVO;
import com.elitesland.scp.domain.convert.purLimit.ScpPurLimitSettingRegionConvert;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingRegionDO;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingRegionDomainService;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingRegionRepo;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingRegionRepoProc;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpPurLimitSettingRegionDomainServiceImpl
implements ScpPurLimitSettingRegionDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpPurLimitSettingRegionDomainServiceImpl.class);
    private final ScpPurLimitSettingRegionRepo scpPurLimitSettingRegionRepo;
    private final ScpPurLimitSettingRegionRepoProc scpPurLimitSettingRegionRepoProc;

    @Override
    public List<ScpPurLimitSettingRegionRespVO> findByMasId(Long masId) {
        List<ScpPurLimitSettingRegionDO> settingItemDOS = this.scpPurLimitSettingRegionRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpPurLimitSettingRegionConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<ScpPurLimitSettingRegionRespVO>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveSettingRegion(List<ScpPurLimitSettingRegionSaveVO> saveVOS) {
        this.scpPurLimitSettingRegionRepo.saveAll(ScpPurLimitSettingRegionConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpPurLimitSettingRegionRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpPurLimitSettingRegionRepo.deleteByIds(ids);
    }

    @Override
    public PagingVO<ScpPurLimitSettingRegionRespVO> page(ScpPurLimitSettingRegionPageParamVO paramVO) {
        long count = this.scpPurLimitSettingRegionRepoProc.countPurLimitSettingRegion(paramVO);
        if (count > 0L) {
            List<ScpPurLimitSettingRegionRespVO> respVOList = this.scpPurLimitSettingRegionRepoProc.queryPurLimitSettingRegion(paramVO);
            return new PagingVO(count, respVOList);
        }
        return new PagingVO();
    }

    @Override
    public List<Long> findMasIdByRegionCode(String regionCode) {
        return this.scpPurLimitSettingRegionRepoProc.findMasIdByRegionCode(regionCode);
    }

    public ScpPurLimitSettingRegionDomainServiceImpl(ScpPurLimitSettingRegionRepo scpPurLimitSettingRegionRepo, ScpPurLimitSettingRegionRepoProc scpPurLimitSettingRegionRepoProc) {
        this.scpPurLimitSettingRegionRepo = scpPurLimitSettingRegionRepo;
        this.scpPurLimitSettingRegionRepoProc = scpPurLimitSettingRegionRepoProc;
    }
}

