package com.elitesland.scp.application.facade.vo.calendar;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;


/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 29日 15:19
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpSuppDemandCalendarPageParamVO", description = "供应商送货日历分页条件")
public class ScpSuppDemandCalendarPageParamVO extends AbstractOrderQueryParam implements BaseScpmanAuthorityParam,Serializable {

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "门店仓库编码")
    private String storeWhCode;

    @ApiModelProperty(value = "供应商编码编码")
    private String suppCode;

    @ApiModelProperty(value = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    @ApiModelProperty(value = "结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty(value = "计划员数据权限")
    private Boolean scpmanAuthority;

    @ApiModelProperty(value = "门店集合")
    private List<String> stores;

    @ApiModelProperty(value = "仓库集合")
    private List<String> whCodes;

}
