package com.elitesland.scp.application.facade.vo.param.app;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.scp.application.facade.vo.resp.app.OrgStoreDboVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 甲指乙采商品列表查询入参
 */
@Data
@ApiModel(value = "商品列表查询入参")
public class AddressParamVO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -8387700128516698775L;
    /**
     * 甲指乙采进入报货列表，输入收货地址
     */
    @ApiModelProperty(value = "装修门店编码")
    private List<OrgStoreDboVO> orgStoreList;

    @ApiModelProperty("国家")
    private String country;
    private String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区县")
    private String county;
    private String countyName;

    @ApiModelProperty("详细地址")
    private String detailAddr;

    @ApiModelProperty("联系人")
    private String contPerson;

    @ApiModelProperty("联系人电话")
    private String tel;
}
