package com.elitesland.scp.application.facade.vo.save.setting;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(value = "单据类型配置保存参数")
public class ScpOrderSettingSaveVO implements Serializable {
    private static final long serialVersionUID = -3342841575717594695L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("单据类型")
//    @NotBlank(message = "单据类型不能为空")
    private String docType;

    @ApiModelProperty("商品分类")
    private List<String> itemCates;

    @ApiModelProperty("采购场景")
//    @NotBlank(message = "采购场景不能为空")
    private String purScene;

    @ApiModelProperty("采购场景名称")
    private String purSceneName;

    @ApiModelProperty("调拨订单单据类型")
//    @NotBlank(message = "调拨订单单据类型不能为空")
    private String trnType;

    @ApiModelProperty("第一优先级")
//    @NotBlank(message = "第一优先级不能为空")
    private String firstPriority;

    @ApiModelProperty("第二优先级")
    private String secPriority;

    @ApiModelProperty("仓网供应关系是否计算运费,0:不计算,1:计算")
    private Boolean whnetFreightFlag;

    @ApiModelProperty("供应商份额分配是否计算运费,0:不计算,1:计算")
    private Boolean suppFreightFlag;

    @ApiModelProperty("业务类型")
    @NotBlank(message = "业务类型不能为空")
    private String businessType;

    @ApiModelProperty("配送类型")
    private String deliveryType;

    @ApiModelProperty("要货类型")
    private String type;

    @ApiModelProperty("是否需要审批,0:不需要,1:需要")
    private Boolean needApproval;

    @ApiModelProperty("是否允许打折,0:不允许,1:允许")
    private Boolean allowDiscount;

    @ApiModelProperty("是否启用,0:禁用,1:启用")
    private Boolean status;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("调拨订单分批分配是否自动")
    private Boolean troAutoAllocateStatus;

    @ApiModelProperty("采购订单是否卡单")
    private Boolean purStuckOrderStatus;
}
