package com.elitesland.scp.application.facade.vo.template;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/4/24 16:34
 * @Description:
 */
@Data
@ApiModel(description = "保存")
public class DemandOrderSaveParamVO implements Serializable {

    @ApiModelProperty("订货模板id")
    private Long id;

    @ApiModelProperty("订货模板编号")
    private String demandTemCode;

    @ApiModelProperty("订货模板名称")
    private String demandTemName;

    @ApiModelProperty("起始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    @ApiModelProperty("截止日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    @ApiModelProperty("详细日期")
    private String detailedTime;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private Integer demandTemStatus;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("要货类型")
    private String type;

    @ApiModelProperty("备注")
    private String remark;

    private List<WhStZoObject> whStZoObjects;

    private List<ItemObject> itemObjects;

    @Data
    public static class WhStZoObject {
        @ApiModelProperty("类型")
        private Integer type;

        @ApiModelProperty("门店/仓库/区域id")
        private Long whStZoId;

        @ApiModelProperty("门店/仓库/区域编号")
        private String whStZoCode;

        @ApiModelProperty("门店/仓库/区域名称")
        private String whStZoName;

        @ApiModelProperty("详细地址")
        private String detailedAddress;

        @ApiModelProperty("所属组织编码")
        private String belongOrgCode;

        @ApiModelProperty("所属组织名称")
        private String belongOrgName;

        @ApiModelProperty("所属公司编码")
        private String belongOuCode;

        @ApiModelProperty("所属公司名称")
        private String belongOuName;

        @ApiModelProperty("经营性质")
        private String storeType;
    }

    @Data
    public static class ItemObject {
        @ApiModelProperty("商品id")
        private Long itemId;

        @ApiModelProperty("商品编号")
        private String itemCode;

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("商品分类/品类")
        private String itemCateCode;

        @ApiModelProperty("商品分类/品类名称")
        private String itemCateName;

        @ApiModelProperty("商品规格")
        private String itemSpec;

        @ApiModelProperty("基本计量单位")
        private String basicUnitMeasure;
        @ApiModelProperty("基本计量单位名称")
        private String basicUnitMeasureName;

        @ApiModelProperty("重量")
        private BigDecimal weight;

        @ApiModelProperty("重量单位")
        private String weightUom;
        private String weightUomName;

        @ApiModelProperty("订货数量")
        private BigDecimal demandQuantity;

        @ApiModelProperty("总重量")
        private BigDecimal totalWeight;

        @ApiModelProperty("辅助单位")
        private String uom2;

        @ApiModelProperty("辅助单位名称")
        private String uom2Name;

        @ApiModelProperty("辅助单位数量")
        private BigDecimal qty2;

        @ApiModelProperty("辅助单位转换率")
        private BigDecimal uomRatio;

        @ApiModelProperty(name = "有效小数位数")
        private Integer decimalPlaces;

    }
}
