package com.elitesland.scp.application.service.export;

import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationImportVO;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 28日 10:04
 * @version: 1.0
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ScpSupplyAllocationServiceImportImpl implements DataImport<ScpSupplyAllocationImportVO> {


    private final ScpSupplyAllocationService supplyAllocationService;

    @Override
    public String getTmplCode() {
        return "scp_supply_allocation_import";
    }

    @Override
    public List<String> executeImport(List<ScpSupplyAllocationImportVO> dataList, int startRowIndex) {
        return supplyAllocationService.importSupplyAllocation(dataList,startRowIndex);
    }

    @Override
    public Integer stepSize() {
        return 1000;
    }

    @Override
    public Set<Integer> sheetNoList() {
        return Set.of(1);
    }
}
