package com.elitesland.scp.application.web.calendar;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetApproveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSaveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSubmitVO;
import com.elitesland.scp.application.service.calendar.ScpStoreCalendarSetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "门店订货日历配置接口")
@RestController
@RequestMapping(value = "/calendar/setting", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpStoreCalendarSetController {

    private final ScpStoreCalendarSetService scpStoreCalendarSetService;

    @ApiOperation(value = "门店订货日历配置-  分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpStoreCalendarSetPageRespVO>> queryCalendarSet(@RequestBody ScpStoreCalendarSetPageParamVO paramVO) {
        log.info("[SCP-STORE-CALENDAR-SET] queryCalendarSet  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpStoreCalendarSetService.page(paramVO));
    }

    @ApiOperation("门店订货日历配置 - 查询门店订货日历配置信息")
    @GetMapping("/findIdOne/{id}")
    public ApiResult<ScpStoreCalendarSetRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-STORE-CALENDAR-SET] findIdOne, id ={}", id);
        return scpStoreCalendarSetService.findCalendarSetById(id).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    @PostMapping("/save")
    @ApiOperation("门店订货日历配置 - 保存")
    public ApiResult<Long> saveCalendarSet(@RequestBody @Validated ScpStoreCalendarSetSaveVO saveVO) {
        log.info("[SCP-STORE-CALENDAR-SET] saveCalendarSet  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpStoreCalendarSetService.saveCalendarSet(saveVO));
    }

    @ApiOperation("门店订货日历配置 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-STORE-CALENDAR-SET] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpStoreCalendarSetService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation("门店订货日历配置 - 提交")
    @PostMapping("/submit")
    public ApiResult<Object> submit(@RequestBody @Validated ScpStoreCalendarSetSubmitVO submitVO) {
        log.info("[SCP-STORE-CALENDAR-SET-LINE] submit paramVO = {}", JSONUtil.toJsonStr(submitVO));
        scpStoreCalendarSetService.submit(submitVO);
        return ApiResult.ok();
    }

    @PostMapping("/batch/approve")
    @ApiOperation("批量审批通过")
    public ApiResult<Object> batchApprove(@RequestBody ScpStoreCalendarSetApproveVO approveSaveParam) {
        scpStoreCalendarSetService.batchApprove(approveSaveParam);
        return ApiResult.ok();
    }

    @PostMapping("/batch/reject")
    @ApiOperation("批量审批拒绝")
    public ApiResult<Object> batchReject(@RequestBody ScpStoreCalendarSetApproveVO approveSaveParam) {
        scpStoreCalendarSetService.batchReject(approveSaveParam);
        return ApiResult.ok();
    }

}
