package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLinePageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLineParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLinePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineDelVO;

import java.util.List;

public interface ScpStoreCalendarSetLineDomainService {

    /**
     * 门店订货日历配置明细查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpStoreCalendarSetLinePageRespVO> queryCalendarSetLineList(ScpStoreCalendarSetLinePageParamVO paramVO);


    /**
     * 删除门店订货日历配置明细
     *
     * @param paramVO
     */
    void deleteByParam(ScpStoreCalendarSetLineDelVO paramVO);

    /**
     * 根据星期查询门店ID
     *
     * @param todayWeek
     * @return
     */
    List<ScpStoreCalendarSetLineRespVO> findCalendarSetByParam(Long masId,Integer todayWeek);

    /**
     * 门店订货日历配置明细查询
     *
     * @param paramVO
     * @return
     */
    Long countCalendarSetLine(ScpStoreCalendarSetLineParamVO paramVO);

    /**
     * 获取门店编码
     *
     * @param masId
     * @return
     */
    List<ScpStoreCalendarSetLineRespVO> findStoreCodeByMasId(Long masId, Integer year);

    List<ScpStoreCalendarSetLineRespVO> findCalendarSetInfoByParam(ScpStoreCalendarSetLineParamVO paramVO);
}
