package com.elitesland.scp.infr.repo.calendar;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLinePageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLineParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLinePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineDelVO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreCalendarSetDO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreCalendarSetLineDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpStoreCalendarSetLineRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpStoreCalendarSetLineDO scpStoreCalendarSetLineDO = QScpStoreCalendarSetLineDO.scpStoreCalendarSetLineDO;
    private static final QScpStoreCalendarSetDO scpStoreCalendarSetDO = QScpStoreCalendarSetDO.scpStoreCalendarSetDO;

    public long count(ScpStoreCalendarSetLinePageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpStoreCalendarSetLineDO.count())
                .from(scpStoreCalendarSetLineDO)
                .leftJoin(scpStoreCalendarSetLineDO).on(scpStoreCalendarSetLineDO.id.eq(scpStoreCalendarSetLineDO.masId));
        jpaQuery.where(this.whereCalendarSet(paramVO));
        return jpaQuery.fetchCount();
    }

    private final QBean<ScpStoreCalendarSetLinePageRespVO> pageList = Projections.bean(
            ScpStoreCalendarSetLinePageRespVO.class,
            scpStoreCalendarSetLineDO.id,
            scpStoreCalendarSetLineDO.masId,
            scpStoreCalendarSetLineDO.todayWeek,
            scpStoreCalendarSetLineDO.storeCode,
            scpStoreCalendarSetLineDO.storeId,
            scpStoreCalendarSetLineDO.storeName,
            scpStoreCalendarSetLineDO.ouCode,
            scpStoreCalendarSetLineDO.ouId,
            scpStoreCalendarSetLineDO.custId,
            scpStoreCalendarSetLineDO.custCode,
            scpStoreCalendarSetLineDO.brandCode,
            scpStoreCalendarSetLineDO.regionCode,
            scpStoreCalendarSetLineDO.storeType2,
            scpStoreCalendarSetLineDO.creator,
            scpStoreCalendarSetLineDO.createUserId,
            scpStoreCalendarSetLineDO.createTime,
            scpStoreCalendarSetLineDO.updater,
            scpStoreCalendarSetLineDO.modifyUserId,
            scpStoreCalendarSetLineDO.modifyTime,
            scpStoreCalendarSetLineDO.remark,
            scpStoreCalendarSetDO.type
    );

    public List<ScpStoreCalendarSetLinePageRespVO> queryCalendarSetLine(ScpStoreCalendarSetLinePageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpStoreCalendarSetDO)
                .leftJoin(scpStoreCalendarSetLineDO).on(scpStoreCalendarSetDO.id.eq(scpStoreCalendarSetLineDO.masId));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpStoreCalendarSetLineDO);
        jpaQuery.where(this.whereCalendarSet(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereCalendarSet(ScpStoreCalendarSetLinePageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getMasId() != null) {
            predicates.add(scpStoreCalendarSetLineDO.masId.eq(paramVO.getMasId()));
        }
        if (paramVO.getTodayWeek() != null) {
            predicates.add(scpStoreCalendarSetLineDO.todayWeek.eq(paramVO.getTodayWeek()));
        }
        if (paramVO.getStoreId() != null) {
            predicates.add(scpStoreCalendarSetLineDO.storeId.eq(paramVO.getStoreId()));
        }
        if (paramVO.getOuId() != null) {
            predicates.add(scpStoreCalendarSetLineDO.ouId.eq(paramVO.getOuId()));
        }
        if (StrUtil.isNotBlank(paramVO.getBrandCode())) {
            predicates.add(scpStoreCalendarSetLineDO.brandCode.eq(paramVO.getBrandCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getRegionCode())) {
            predicates.add(scpStoreCalendarSetLineDO.regionCode.eq(paramVO.getRegionCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getStoreType2())) {
            predicates.add(scpStoreCalendarSetLineDO.storeType2.eq(paramVO.getStoreType2()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long deleteByMasIds(List<Long> masIds) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpStoreCalendarSetLineDO.masId.in(masIds));
        var delete = jpaQueryFactory.delete(scpStoreCalendarSetLineDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

    public long deleteByParam(ScpStoreCalendarSetLineDelVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (CollUtil.isNotEmpty(paramVO.getIds())) {
            predicates.add(scpStoreCalendarSetLineDO.id.in(paramVO.getIds()));
        }
        if (paramVO.getTodayWeek() != null) {
            predicates.add(scpStoreCalendarSetLineDO.todayWeek.eq(paramVO.getTodayWeek()));
        }
        if (paramVO.getMasId() != null) {
            predicates.add(scpStoreCalendarSetLineDO.masId.eq(paramVO.getMasId()));
        }
        var delete = jpaQueryFactory.delete(scpStoreCalendarSetLineDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

    public List<ScpStoreCalendarSetLineRespVO> findStoreByParam(Long masId,Integer todayWeek) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreCalendarSetLineRespVO.class,
                        scpStoreCalendarSetLineDO.todayWeek,
                        scpStoreCalendarSetLineDO.storeId,
                        scpStoreCalendarSetLineDO.storeCode,
                        scpStoreCalendarSetLineDO.storeName
                ))
                .from(scpStoreCalendarSetLineDO);
        jpaQuery.where(scpStoreCalendarSetLineDO.todayWeek.eq(todayWeek));
        jpaQuery.where(scpStoreCalendarSetLineDO.masId.eq(masId));
        return jpaQuery.fetch();
    }

    public Long countCalendarSetLine(ScpStoreCalendarSetLineParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpStoreCalendarSetLineDO.id.count())
                .from(scpStoreCalendarSetLineDO);
        if (paramVO.getMasId() != null) {
            jpaQuery.where(scpStoreCalendarSetLineDO.masId.eq(paramVO.getMasId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreIds())) {
            jpaQuery.where(scpStoreCalendarSetLineDO.storeId.in(paramVO.getStoreIds()));
        }
        return jpaQuery.fetchCount();
    }

    public List<ScpStoreCalendarSetLineRespVO> findStoreCodeByMasId(Long masId, Integer year) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreCalendarSetLineRespVO.class,
                        scpStoreCalendarSetLineDO.storeId,
                        scpStoreCalendarSetLineDO.storeCode,
                        scpStoreCalendarSetLineDO.storeName,
                        scpStoreCalendarSetLineDO.todayWeek,
                        scpStoreCalendarSetDO.type,
                        scpStoreCalendarSetDO.deliveryType
                ))
                .from(scpStoreCalendarSetLineDO)
                .leftJoin(scpStoreCalendarSetDO).on(scpStoreCalendarSetLineDO.masId.eq(scpStoreCalendarSetDO.id));
        jpaQuery.where(scpStoreCalendarSetLineDO.masId.eq(masId));
        jpaQuery.where(scpStoreCalendarSetDO.startYear.eq(year));
        jpaQuery.groupBy(scpStoreCalendarSetLineDO.storeId,scpStoreCalendarSetLineDO.storeCode,scpStoreCalendarSetLineDO.storeName);
        return jpaQuery.fetch();
    }

    public List<ScpStoreCalendarSetLineRespVO> findStoreByParam(ScpStoreCalendarSetLineParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreCalendarSetLineRespVO.class,
                        scpStoreCalendarSetLineDO.todayWeek,
                        scpStoreCalendarSetLineDO.storeId,
                        scpStoreCalendarSetLineDO.storeCode,
                        scpStoreCalendarSetLineDO.storeName
                ))
                .from(scpStoreCalendarSetLineDO);
        if (paramVO.getMasId() != null) {
            jpaQuery.where(scpStoreCalendarSetLineDO.masId.eq(paramVO.getMasId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreIds())) {
            jpaQuery.where(scpStoreCalendarSetLineDO.storeId.in(paramVO.getStoreIds()));
        }
        if (paramVO.getTodayWeek() != null){
            jpaQuery.where(scpStoreCalendarSetLineDO.todayWeek.eq(paramVO.getTodayWeek()));
        }
        return jpaQuery.fetch();
    }
}
