package com.elitesland.scp.infr.repo.purLimit;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingStoreRespVO;
import com.elitesland.scp.domain.entity.purLimit.QScpPurLimitSettingDO;
import com.elitesland.scp.domain.entity.purLimit.QScpPurLimitSettingStoreDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpPurLimitSettingStoreRepoProc {
    private static final QScpPurLimitSettingStoreDO scpPurLimitSettingStoreDO = QScpPurLimitSettingStoreDO.scpPurLimitSettingStoreDO;
    private static final QScpPurLimitSettingDO scpPurLimitSettingDO = QScpPurLimitSettingDO.scpPurLimitSettingDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<ScpPurLimitSettingStoreRespVO> pageList = Projections.bean(
            ScpPurLimitSettingStoreRespVO.class,
            scpPurLimitSettingStoreDO.id,
            scpPurLimitSettingStoreDO.masId,
            scpPurLimitSettingStoreDO.storeId,
            scpPurLimitSettingStoreDO.storeCode,
            scpPurLimitSettingStoreDO.storeName,
            scpPurLimitSettingStoreDO.storeType2,
            scpPurLimitSettingStoreDO.maxNum

    );

    public long countPurLimitSettingStore(ScpPurLimitSettingStorePageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpPurLimitSettingStoreDO.count())
                .from(scpPurLimitSettingStoreDO);
        jpaQuery.where(this.wherePurLimitSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpPurLimitSettingStoreRespVO> queryPurLimitSettingStore(ScpPurLimitSettingStorePageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpPurLimitSettingStoreDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpPurLimitSettingStoreDO);
        jpaQuery.where(this.wherePurLimitSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate wherePurLimitSettingPage(ScpPurLimitSettingStorePageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getMasId() != null) {
            predicates.add(scpPurLimitSettingStoreDO.masId.eq(paramVO.getMasId()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findMasIdByStoreCode(String storeCode) {
        return jpaQueryFactory.select(scpPurLimitSettingStoreDO.masId).distinct()
                .from(scpPurLimitSettingStoreDO)
                .where(scpPurLimitSettingStoreDO.storeCode.eq(storeCode))
                .fetch();
    }

    public List<ScpPurLimitSettingStoreRespVO> findByParam(ScpPurLimitSettingStoreParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpPurLimitSettingStoreRespVO.class,
                        scpPurLimitSettingStoreDO.id,
                        scpPurLimitSettingStoreDO.masId,
                        scpPurLimitSettingStoreDO.storeId,
                        scpPurLimitSettingStoreDO.storeCode,
                        scpPurLimitSettingStoreDO.storeName,
                        scpPurLimitSettingStoreDO.storeType2,
                        scpPurLimitSettingStoreDO.maxNum,
                        scpPurLimitSettingStoreDO.activeNum
                ))
                .from(scpPurLimitSettingStoreDO);
        jpaQuery.where(scpPurLimitSettingStoreDO.masId.in(paramVO.getMasIds()));
        if (StrUtil.isNotBlank(paramVO.getStoreCode())) {
            jpaQuery.where(scpPurLimitSettingStoreDO.storeCode.eq(paramVO.getStoreCode()));
        }
        if (paramVO.getUsed() != null && paramVO.getUsed()) {
            jpaQuery.where(scpPurLimitSettingStoreDO.activeNum.gt(BigDecimal.ZERO));
        }
        return jpaQuery.fetch();
    }

    public List<ScpPurLimitSettingStoreRespVO> findEnabledByParam(ScpPurLimitSettingStoreParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpPurLimitSettingStoreRespVO.class,
                        scpPurLimitSettingStoreDO.id,
                        scpPurLimitSettingStoreDO.masId,
                        scpPurLimitSettingStoreDO.storeId,
                        scpPurLimitSettingStoreDO.storeCode,
                        scpPurLimitSettingStoreDO.storeName
                ))
                .from(scpPurLimitSettingStoreDO)
                .leftJoin(scpPurLimitSettingDO).on(scpPurLimitSettingStoreDO.masId.eq(scpPurLimitSettingDO.id));
        if (CollUtil.isNotEmpty(paramVO.getMasIds())) {
            jpaQuery.where(scpPurLimitSettingStoreDO.masId.in(paramVO.getMasIds()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            jpaQuery.where(scpPurLimitSettingStoreDO.storeCode.in(paramVO.getStoreCodes()));
        }
        jpaQuery.where(scpPurLimitSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime startOfDay = LocalDateTime.now().toLocalDate().atStartOfDay();
        jpaQuery.where(scpPurLimitSettingDO.validTo.goe(startOfDay));
        return jpaQuery.fetch();
    }

    public List<Long> findUsedSettingByMasIds(List<Long> masIds) {
        var jpaQuery = jpaQueryFactory.select(scpPurLimitSettingStoreDO.masId).distinct()
                .from(scpPurLimitSettingStoreDO);
        jpaQuery.where(scpPurLimitSettingStoreDO.masId.in(masIds));
        jpaQuery.where(scpPurLimitSettingStoreDO.activeNum.gt(0));
        return jpaQuery.fetch();
    }
}
