package com.elitesland.scp.infr.repo.survey;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.domain.entity.survey.QSurveyDO;
import com.elitesland.scp.domain.entity.survey.QSurveyPublishDO;
import com.elitesland.scp.domain.entity.survey.SurveyDO;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.elitesland.scp.domain.vo.survey.SurveyPublishRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

@Repository
public class SurveyPublishRepoProc extends BaseRepoProc<SurveyDO> {

    private final static QSurveyDO surveyDO = QSurveyDO.surveyDO;
    private final static QSurveyPublishDO surveyPublishDO = QSurveyPublishDO.surveyPublishDO;

    protected SurveyPublishRepoProc() {
        super(surveyDO);
    }


    /**
     * 分页查询
     *
     * @param queryVO 条件
     * @return 分页结果
     */
    public List<SurveyPublishRespVO> findPublish(SurveyPagingParam queryVO) {
        JPAQuery<SurveyPublishRespVO> jpaQuery = jpaQueryFactory.select(
                Projections.bean(SurveyPublishRespVO.class,
                        surveyPublishDO.id,
                        surveyPublishDO.ouId,
                        surveyPublishDO.ouCode,
                        surveyPublishDO.ouName,
                        surveyPublishDO.suvId,
                        surveyPublishDO.fillStatus,
                        surveyDO.surveyTitle
                ))
                .from(surveyPublishDO)
                .leftJoin(surveyDO).on(surveyDO.id.eq(surveyPublishDO.suvId))
                .where(where(queryVO));
        return jpaQuery.fetch();
    }

    private Predicate where(SurveyPagingParam param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (StringUtils.isNotEmpty(param.getSurveyTitle())) {
            predicate = ExpressionUtils.and(predicate, surveyDO.surveyTitle.like("%" + param.getSurveyTitle() + "%"));
        }
        if (StringUtils.isNotEmpty(param.getSurveyStatus())) {
            predicate = ExpressionUtils.and(predicate, surveyDO.surveyStatus.eq(param.getSurveyStatus()));
        }
        if (StringUtils.isNotEmpty(param.getPublisherName())) {
            predicate = ExpressionUtils.and(predicate, surveyDO.publisherName.like("%" + param.getPublisherName() + "%"));
        }
        if (param.getCreateTimeFrom() != null) {
            predicate = ExpressionUtils.and(predicate, surveyDO.createTime.goe(param.getCreateTimeFrom()).or(surveyDO.createTime.eq(param.getCreateTimeFrom())));
        }
        if (param.getCreateTimeTo() != null) {
            predicate = ExpressionUtils.and(predicate, surveyDO.createTime.loe(param.getCreateTimeTo()).or(surveyDO.createTime.eq(param.getCreateTimeTo())));
        }
        if (StringUtils.isNotEmpty(param.getNeedFilterValidTime()) && "Y".equals(param.getNeedFilterValidTime())) {
            predicate = ExpressionUtils.and(predicate, surveyDO.beginTime.loe(LocalDateTime.now()).and(surveyDO.endTime.goe(LocalDateTime.now())));
        }
        if (StringUtils.isNotEmpty(param.getOuCode())) {
            predicate = ExpressionUtils.and(predicate, surveyPublishDO.ouCode.eq(param.getOuCode()));
        }
        if (CollectionUtils.isNotEmpty(param.getOuCodeList())) {
            predicate = ExpressionUtils.and(predicate, surveyPublishDO.ouCode.in(param.getOuCodeList()));
        }
        if (param.getRequired() != null) {
            predicate = ExpressionUtils.and(predicate, surveyDO.required.eq(param.getRequired()));
        }
        if (param.getNotSuvId() != null) {
            predicate = ExpressionUtils.and(predicate, surveyDO.id.ne(param.getNotSuvId()));
        }
        if (CollectionUtils.isNotEmpty(param.getSuvIdList())) {
            predicate = ExpressionUtils.and(predicate, surveyDO.id.in(param.getSuvIdList()));
        }
        return predicate;
    }



}
