/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.purLimit;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingStoreSaveVO;
import com.elitesland.scp.domain.convert.purLimit.ScpPurLimitSettingStoreConvert;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingStoreDO;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingStoreDomainService;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingStoreRepo;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingStoreRepoProc;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpPurLimitSettingStoreDomainServiceImpl
implements ScpPurLimitSettingStoreDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpPurLimitSettingStoreDomainServiceImpl.class);
    private final EntityManager entityManager;
    private final ScpPurLimitSettingStoreRepo scpPurLimitSettingStoreRepo;
    private final ScpPurLimitSettingStoreRepoProc scpPurLimitSettingStoreRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpPurLimitSettingStoreRespVO> page(ScpPurLimitSettingStorePageParamVO paramVO) {
        long count = this.scpPurLimitSettingStoreRepoProc.countPurLimitSettingStore(paramVO);
        if (count > 0L) {
            List<ScpPurLimitSettingStoreRespVO> storeRespVOList = this.scpPurLimitSettingStoreRepoProc.queryPurLimitSettingStore(paramVO);
            return new PagingVO(count, storeRespVOList);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSavePurLimitSettingStore(List<ScpPurLimitSettingStoreSaveVO> saveVOS, int batchSize) {
        this.batchInsert(ScpPurLimitSettingStoreConvert.INSTANCE.saveVosDOS(saveVOS), batchSize);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpPurLimitSettingStoreRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpPurLimitSettingStoreRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findMasIdByStoreCode(String storeCode) {
        return this.scpPurLimitSettingStoreRepoProc.findMasIdByStoreCode(storeCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePurLimitNumByParam(List<Long> masIds, String storeCode) {
        this.scpPurLimitSettingStoreRepo.updateActiveNumByParam(masIds, storeCode);
    }

    @Override
    public List<ScpPurLimitSettingStoreRespVO> findByParam(ScpPurLimitSettingStoreParamVO paramVO) {
        return this.scpPurLimitSettingStoreRepoProc.findByParam(paramVO);
    }

    @Override
    public Long updatePurLimitSettingStore(ScpPurLimitSettingStoreSaveVO saveVO) {
        Optional<ScpPurLimitSettingStoreDO> option = this.scpPurLimitSettingStoreRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u5f3a\u914d\u95e8\u5e97ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpPurLimitSettingStoreDO scpPurLimitSettingDO = option.get();
        ScpPurLimitSettingStoreConvert.INSTANCE.copySaveParamToDo(saveVO, scpPurLimitSettingDO);
        return ((ScpPurLimitSettingStoreDO)this.scpPurLimitSettingStoreRepo.save(scpPurLimitSettingDO)).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpPurLimitSettingStoreRespVO> findByMasId(Long masId) {
        List<ScpPurLimitSettingStoreDO> settingStoreDOS = this.scpPurLimitSettingStoreRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingStoreDOS)) {
            return ScpPurLimitSettingStoreConvert.INSTANCE.dosToRespVOS(settingStoreDOS);
        }
        return new ArrayList<ScpPurLimitSettingStoreRespVO>();
    }

    @Override
    public List<ScpPurLimitSettingStoreRespVO> findEnabledByParam(ScpPurLimitSettingStoreParamVO paramVO) {
        return this.scpPurLimitSettingStoreRepoProc.findEnabledByParam(paramVO);
    }

    public void batchInsert(List<ScpPurLimitSettingStoreDO> dataList, int batchSize) {
        int index = 0;
        for (ScpPurLimitSettingStoreDO data : dataList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!dataList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    public ScpPurLimitSettingStoreDomainServiceImpl(EntityManager entityManager, ScpPurLimitSettingStoreRepo scpPurLimitSettingStoreRepo, ScpPurLimitSettingStoreRepoProc scpPurLimitSettingStoreRepoProc) {
        this.entityManager = entityManager;
        this.scpPurLimitSettingStoreRepo = scpPurLimitSettingStoreRepo;
        this.scpPurLimitSettingStoreRepoProc = scpPurLimitSettingStoreRepoProc;
    }
}

