/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveSendParam;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StoreReceiveCancelListener
implements MessageQueueListener<StoreReceiveSendParam> {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveCancelListener.class);
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final ScpDemandOrderRepo scpDemandOrderRepo;
    private final StoreReceiveRepo storeReceiveRepo;

    @NotEmpty
    public String[] channels() {
        return new String[]{"store_order_cancel"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveSendParam storeReceiveSendParam) {
        log.info("\u8c03\u62e8\u8ba2\u5355\u53d6\u6d88\uff1a{}", (Object)JSON.toJSONString((Object)storeReceiveSendParam));
        if ("TRO_AUTO_CLOSE".equals(storeReceiveSendParam.getDocType())) {
            log.info("\u8c03\u62e8\u8ba2\u5355\u81ea\u52a8\u5173\u95ed\u4e0d\u505a\u4e1a\u52a1\u5904\u7406");
            return;
        }
        List<Long> dIds = storeReceiveSendParam.getItems().stream().map(StoreReceiveSendParam.OrderItem::getOrderDid).collect(Collectors.toList());
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
        if (CollUtil.isNotEmpty(receiveDOS) && "T".equals(receiveDOS.get(0).getRtType())) {
            StoreReceiveDO storeReceiveDO = receiveDOS.get(0);
            this.storeReceiveRepo.updateStatusById(storeReceiveDO.getId(), "CL");
        } else {
            this.scpDemandOrderDDomainService.cancelOrderByDIds(dIds);
            List<ScpDemandOrderDDO> byMasIdAndStatus = this.scpDemandOrderDRepoProc.findByMasIdAndStatusNotAndProjectFeeFlag(storeReceiveSendParam.getOrderId(), ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode(), false);
            if (CollUtil.isEmpty(byMasIdAndStatus)) {
                this.scpDemandOrderRepo.updateDocStatusById(storeReceiveSendParam.getOrderId(), ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode());
            }
        }
    }

    public StoreReceiveCancelListener(ScpDemandOrderDDomainService scpDemandOrderDDomainService, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc, ScpDemandOrderRepo scpDemandOrderRepo, StoreReceiveRepo storeReceiveRepo) {
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
        this.scpDemandOrderRepo = scpDemandOrderRepo;
        this.storeReceiveRepo = storeReceiveRepo;
    }
}

