/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.jpa.util.DatabaseDialectDetector;
import com.elitesland.scp.common.PartitionQueryParam;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.impl.JPAQuery;
import javax.validation.constraints.NotNull;

public class PartitionJpaUtil {
    private static DatabaseDialectDetector databaseDialectDetector;

    public static void appendYmConditionToPredicate(JPAQuery jpaQuery, @NotNull Class<?> entityClass, @NotNull PartitionQueryParam param) {
        if (param.getYmTo() == null && param.getYmFrom() == null) {
            return;
        }
        if (databaseDialectDetector == null) {
            databaseDialectDetector = (DatabaseDialectDetector)SpringContextHolder.getBean(DatabaseDialectDetector.class);
        }
        if (databaseDialectDetector.isMySQLDialect()) {
            return;
        }
        String entityName = entityClass.getSimpleName();
        String var10000 = entityName.substring(0, 1).toLowerCase();
        String alias = var10000 + entityName.substring(1);
        PathBuilder entityPath = new PathBuilder(entityClass, alias);
        NumberPath path = entityPath.getNumber("ym", Integer.class);
        if (param.getYmFrom().equals(param.getYmTo())) {
            jpaQuery.where((Predicate)path.eq((Object)param.getYmFrom()));
        } else {
            jpaQuery.where((Predicate)path.between((Number)param.getYmFrom(), (Number)param.getYmTo()));
        }
    }
}

