package com.elitesland.scp.application.facade.vo.cart;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 16:58
 * @Description:
 */
@Data
@ApiModel("下单成功部分数据结果")
public class CartToOrderSuccessRespVO implements Serializable {

    @ApiModelProperty("商品SPU-ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("商品SPU编码")
    private String spuCode;

    @ApiModelProperty("商品SPU名称")
    private String spuName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty("商品SKU明细")
    private List<ItemSpecObjectVO> itemSpecObjectVOS;

    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("单位名称")
        private String uomName;

        @ApiModelProperty("商品id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty("商品规格编码(SKU编码)")
        private String itemCode;

        @ApiModelProperty("商品规格名称(SKU名称)")
        private String itemName;

        @ApiModelProperty(value = "包装规格")
        private String itemAttrName;

        @ApiModelProperty("基本单位")
        private String uom2;

        @ApiModelProperty(value = "基本单位名称")
        private String uom2Name;

        @ApiModelProperty("单位转换系数")
        private BigDecimal uomRatio;

        @ApiModelProperty("有效位数")
        private Integer decimalPlaces;

        @ApiModelProperty(value = "商品分类")
        private String itemType;

        @ApiModelProperty(value = "配送类型")
        private String deliveryType;

        @ApiModelProperty("需求数量")
        private BigDecimal demandQuantity;

        @ApiModelProperty("小记金额")
        private BigDecimal totalAmt;

        @ApiModelProperty("强配活动ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long activityId;

        @ApiModelProperty("强配活动编码")
        private String activityCode;

        @ApiModelProperty("预售状态")
        private Boolean preSaleStatus;

        @ApiModelProperty("最小强配数量")
        private BigDecimal minNum;

        @ApiModelProperty("折扣比例")
        private BigDecimal discount;

        @ApiModelProperty("分配仓库数量数据")
        private List<WhAllocObject> whAllocObjects;

        @ApiModelProperty("赠品数量")
        private List<GiftItemVO> giftItemVOS;
    }

    @Data
    public static class GiftItemVO{
        @ApiModelProperty(value = "增品商品ID")
        private Long discountGiftItemId;

        @ApiModelProperty(value = "增品商品名称")
        private String discountGiftItemName;

        @ApiModelProperty(value = "增品商品编码")
        private String discountGiftItemCode;

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("商品SPU编码")
        private String spuCode;

        @ApiModelProperty("商品SPU名称")
        private String spuName;

        @ApiModelProperty("商品图片")
        private String url;

    }
    @Data
    public static class WhAllocObject {

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty(value = "供应商仓库或供应商id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long supplyWhId;

        @ApiModelProperty(value = "供应商仓库或供应商编码")
        private String supplyWhCode;

        @ApiModelProperty(value = "供应商仓库或供应商名称")
        private String supplyWhName;

        @ApiModelProperty(value = "WH-仓库  SUPP-供应商")
        private String supplyType;

        @ApiModelProperty(value = "仓库/供应商分配比例")
        private BigDecimal ratio;

        @ApiModelProperty("含税单价")
        private BigDecimal itemPrice;

        @ApiModelProperty("运费是否需要计费")
        private Boolean freightFlag;

        @ApiModelProperty("运费比例")
        private BigDecimal freightRatio;

        @ApiModelProperty("采购公司id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long ouId;

        @ApiModelProperty("采购公司编码")
        private String ouCode;

        @ApiModelProperty("采购公司名称")
        private String ouName;

        @ApiModelProperty("销售公司编码")
        private String saleOuCode;

        @ApiModelProperty("销售公司名称")
        private String saleOuName;

        @ApiModelProperty("销售客户编码")
        private String saleCustCode;

        @ApiModelProperty("运费")
        private BigDecimal freightAmt;

        @ApiModelProperty("可供量")
        private BigDecimal avalQty;

        @ApiModelProperty("总价格")
        private BigDecimal price;

        @ApiModelProperty("销售单价（不含服务费）")
        private BigDecimal salePrice;

        @ApiModelProperty("结算单价")
        private BigDecimal settlementPrice;

        @ApiModelProperty("结算货款单价")
        private BigDecimal settlementSalePrice;

        @ApiModelProperty("供应商ID")
        private Long suppId;

        @ApiModelProperty("供应商编码")
        private String suppCode;

        @ApiModelProperty("供应商名称")
        private String suppName;

        @ApiModelProperty("科技费价格")
        private BigDecimal tefPrice;

        @ApiModelProperty("营销费价格")
        private BigDecimal mefPrice;

        @ApiModelProperty("运营费价格")
        private BigDecimal oefPrice;

        @ApiModelProperty("是否收取项目费用")
        private Boolean isProjFeeCharged;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuCode;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuCode;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuCode;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuName;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuName;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuName;

        public BigDecimal getAmt() {
            //金额
            return price.multiply(qty);
        }
    }


    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("图片url")
    private String url;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;
}
