package com.elitesland.scp.application.service.order;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetPageRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;


@Component
@Slf4j
@RequiredArgsConstructor
public class ScpDemandOrderSetExportServiceImpl implements DataExport<ScpDemandSetPageRespVO, ScpDemandSetPageParamVO> {

    private final ScpDemandOrderSetService scpDemandOrderSetService;

    @Override
    public String getTmplCode() {
        return "yst_scp_demand_set_export";
    }

    @Override
    public PagingVO<ScpDemandSetPageRespVO> executeExport(ScpDemandSetPageParamVO queryParamVO) {
        return scpDemandOrderSetService.queryDemandSetList(queryParamVO);
    }
}
