package com.elitesland.scp.application.web.scpsman;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanComponentPageRespVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanParamVO;
import com.elitesland.scp.application.service.scpsman.ScpsmanComponentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Auther: Mark
 * @Date: 2024/3/22 10:15
 * @Description:
 */
@RestController
@RequestMapping("/scp/component")
@RequiredArgsConstructor
@Api(value = "供应链计划中心-公共组件接口", tags = {"供应链计划中心-公共组件接口"})
public class ScpComponentController {

    private final ScpsmanComponentService scpsmanComponentService;


    @ApiOperation("员工分页查询-放大镜组件")
    @PostMapping("/scpsman/paging")
    public ApiResult<PagingVO<SalesmanComponentPageRespVO>> salemansComponentPage(@RequestBody SalesmanParamVO paramVO) {
        return ApiResult.ok(scpsmanComponentService.salemansComponentPage(paramVO));
    }

}
