package com.elitesland.scp.domain.dto;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-03-11
 */
public interface TreeNode<T extends TreeNode<T>> extends Comparable<TreeNode<T>>, Serializable {

    /**
     * 获取ID
     * @return ID
     */
    Long getId();

    /**
     * 获取排序序号
     * @return 排序序号
     */
    Integer getSortNo();

    /**
     * 获取父ID
     * @return 父ID
     */
    Long getPid();

    /**
     * 设置pif
     * @param pid
     */
    void setPid(Long pid);

    /**
     * 设置排序号
     * @param sortNo
     */
    void setSortNo(Integer sortNo);

    /**
     * 设置是否是最后一级
     * @param isLeaf isLeaf
     */
    void setIsLeaf(Boolean isLeaf);

    /**
     * 获取子树
     * @return 子树
     */
    List<T> getTreeNodes();

    /**
     * 设置子树
     * @param treeNodes 子树
     */
    void setTreeNodes(List<T> treeNodes);



    /**
     * 排序
     * @param o 目标
     * @return 排序大小
     */
    @Override
    default int compareTo(TreeNode o) {
        return (this.getSortNo() == null ? 0 : this.getSortNo()) - (o.getSortNo() == null ? 0 : o.getSortNo());
    }

}
