package com.elitesland.scp.domain.dto.article;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(description = "文章分类新增编辑入参")
@Data
public class ArticleInfoDTO implements Serializable {
    private static final long serialVersionUID = 4406789299601680378L;

    @ApiModelProperty("文章信息id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("文章名称")
    private String articleName;

    @ApiModelProperty("文章编码")
    private String articleCode;

    @ApiModelProperty("文章作者")
    private String articleAuthor;

    @ApiModelProperty("文章分类id")
    private Long categoryId;

    @ApiModelProperty("文章分类名称")
    private String categoryName;

    @ApiModelProperty("文章分类code")
    private String categoryCode;

    @ApiModelProperty("文章详情")
    private String articleDetail;

    @ApiModelProperty("文章排序")
    private Integer sortNo;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    private String showFlag;

    private Long pid;
}
