package com.elitesland.scp.domain.service.authority;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpDemandAuthprityServiceImpl implements ScpDemandAuthorityService {

    private final ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc;
    private final ScpDemandAuthorityRepo scpDemandAuthorityRepo;
    private final ScpDemandAuthorityManager scpDemandAuthorityManager;

    @Override
    @SysCodeProc
    public PagingVO<ScpManAuthorityPageRespVO> queryAuthorit(ScpManAuthorityParam paramVO) {
        long count = scpDemandAuthorityRepoProc.countDemandSet(paramVO);
        if (count > 0) {
            var franchisees = scpDemandAuthorityRepoProc.queryPageDemandAuthority(paramVO);

            // 设置区域
            scpDemandAuthorityManager.convertRegionName(franchisees, t -> ScpUdcEnum.SCPSMAN_AUTHORITY_TYPE_1.getValueCode().equals(t.getType() + ""),
                    ScpManAuthorityPageRespVO::getRegion, ScpManAuthorityPageRespVO::setRegionName);

            return PagingVO.<ScpManAuthorityPageRespVO>builder()
                    .total(count)
                    .records(franchisees)
                    .build();
        }
        return new PagingVO<>();

    }

    @Override
    public PagingVO<ScpManAuthorityPageRespVO> getCurrentUserAuthority() {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUserDTO)) {
            throw new BusinessException("当前登录人查询异常");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setTypes(List.of(1, 0));
        scpManAuthorityParam.setEnableStatus(Boolean.TRUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = queryAuthorit(scpManAuthorityParam);
        return scpManAuthorityPageRespVOPagingVO;
    }


    @Override
    public void changeStatus(List<Long> ids, Boolean status) {
        scpDemandAuthorityRepoProc.changeStatus(ids, status);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        scpDemandAuthorityRepoProc.deleteByIds(ids);
    }

    @Override
    public Long saveScpManAuthority(ScpsmanAuthorityDO scpsmanAuthorityDO) {
        return scpDemandAuthorityRepo.save(scpsmanAuthorityDO).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpManAuthorityPageRespVO> listQuery(ScpManAuthorityParam paramVO) {
        return scpDemandAuthorityRepoProc.listQuery(paramVO);
    }

    @Override
    public boolean existsByscpsmanNo(ScpManAuthoritySaveVO saveVO) {
        return scpDemandAuthorityRepo.existsByscpsmanNo(saveVO.getScpsmanNo());
    }

    @Override
    @SysCodeProc
    public List<ScpManAuthorityPageRespVO> findByScpsmanNoIn(List<String> scpsmanNoList) {
        return scpDemandAuthorityRepoProc.findByScpsmanNoIn(scpsmanNoList);
    }


}
