package com.elitesland.scp.infr.dto.minOrder;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel("订货强配详情返回")
public class ScpMinOrderSettingDTO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -3038925240131174177L;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("活动类型")
    private String activityType;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty(value = "最大强配次数")
    private Integer maxAllocNum;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;

}
