package com.elitesland.scp.mq;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.task.delay.common.DelayTaskHandler;
import com.elitescloud.cloudt.core.task.delay.TaskInfo;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPayTimeoutMqParam;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.Optional;

@Component
@Slf4j
@RequiredArgsConstructor
public class ScpOrderPayTimeoutListener implements DelayTaskHandler<ScpDemandOrderPayTimeoutMqParam> {

    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpDemandOrderRepo scpDemandOrderRepo;
    private final ScpDemandOrderService scpDemandOrderService;

    @Override
    public String[] supportType() {
        return new String[]{ScpDemandOrderPayTimeoutMqParam.SCP_ORDER_PAY_TIMEOUT_CHANNEL};
    }

    /**
     * 处理倒计时到期事件
     */
    @Override
    public boolean execute(TaskInfo<ScpDemandOrderPayTimeoutMqParam> taskInfo) {
        log.info("订单支付更新关联单据状态参数:{}", JSONUtil.toJsonStr(taskInfo));
        ScpDemandOrderPayTimeoutMqParam param = taskInfo.getPayload();
        Long orderId = param.getDocId();
        String targetStatus = param.getTargetStatus();
        try {
            Optional<ScpDemandOrderDO> demandOrderDO = scpDemandOrderRepo.findById(orderId);
            if (demandOrderDO.isEmpty()) {
                log.info("订单 {} 不存在，无需处理倒计时", orderId);
                return true;
            }
            ScpDemandOrderDO scpDemandOrderDO = demandOrderDO.get();
            String payStatus = scpDemandOrderDO.getPayStatus();
            String docStatus = scpDemandOrderDO.getDocStatus();
            // 只处理待支付,并且未取消的单据
            if (payStatus != null
                    && (Objects.equals(payStatus, ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode()))
                    && docStatus != null
                    && !Objects.equals(docStatus, ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode())
            ) {
                // 执行状态更新
                scpDemandOrderRepoProc.updateOrderStatusById(orderId, targetStatus, null);
                log.info("订单 {} 倒计时结束，状态已更新为 {}", orderId, targetStatus);
                // 0910改动，订单支付超时，取消订单
                scpDemandOrderService.close(orderId, "SYSTEM");
            }
        } catch (Exception e) {
            log.error("处理订单 {} 失败", orderId, e);
        }
        return true;
    }
}
