package com.elitesland.scp.application.facade.vo.param.mrp;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("物料需求计划明细导入")
@ExcelIgnoreUnannotated
public class ScpMrpDImportEntity implements Serializable {

    private static final long serialVersionUID = 4840751240475165446L;

    public Integer rowNo;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("mrp批次")
    private String mrpLotNo;

    @ApiModelProperty("预测批次")
    private String predLotNo;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("预测安全库存")
    private BigDecimal predSafetyQty;

    @ApiModelProperty("预测目标库存")
    private BigDecimal predTargetQty;

    @ApiModelProperty("在库数")
    private BigDecimal invQty;

    @ApiModelProperty("毛需求")
    private BigDecimal grossDemand;

    @ApiModelProperty("采购在途数量")
    private BigDecimal purTransitQty;

    @ApiModelProperty("最小起订量")
    private BigDecimal moq;

    @ApiModelProperty("采购提前期")
    private BigDecimal purLeadTime;

    @ApiModelProperty("预期到货日期")
    private LocalDateTime expectArriveDate;

    @ApiModelProperty("库存周转率")
    private BigDecimal invTurnover;

    @ApiModelProperty("标准库存周转率")
    private BigDecimal stdInvTurnover;

    @ApiModelProperty("净需求")
    private BigDecimal netDemand;

    @ApiModelProperty("采购公司Id")
    private Long purOuId;

    @ApiModelProperty("采购公司编码")
    private String purOuCode;

    @ApiModelProperty("采购公司名称")
    private String purOuName;

    @ApiModelProperty("供应商Id")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("采购计划数量")
    private BigDecimal purQty;

    @ApiModelProperty("采购计划单位")
    private String purUom;
    private String purUomName;

}
