package com.elitesland.scp.application.facade.vo.save.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel(value = "订单集保存参数")
public class ScpDemandSetSaveVO implements Serializable {
    private static final long serialVersionUID = 2310302359745458378L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "类型", required = true)
    @NotBlank(message = "订单集类型不能为空")
    private String type;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty(value = "订货集名称", required = true)
    @NotBlank(message = "订货集名称不能为空")
    private String demandName;

    @ApiModelProperty(value = "需求日期", required = true)
    @NotNull(message = "需求日期不能为空")
    private LocalDateTime demandDate;

    @ApiModelProperty("状态")
    private Boolean status;

    @ApiModelProperty("订货截止时间点，格式：HH:mm:ss")
    private String expireTimeStr;

    private LocalDateTime expireTime;
}
