package com.elitesland.scp.application.facade.vo.whnet;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 20日 16:27
 * @version: 1.0
 */
@Data
@ApiModel("仓网关系返回结果")
public class ScpWhNetRelationResultVO implements Serializable {

    @ApiModelProperty(value = "供应仓库结果")
    private List<ScpWhNetRelationResultVO.ResultVO> successList;

    @ApiModelProperty(value = "供应仓库失败结果")
    private List<ScpWhNetRelationResultVO.ResultVO> failList;

    @Data
    public static class ResultVO implements Serializable {

        @ApiModelProperty(value = "供应仓库id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long supplyWhId;

        @ApiModelProperty(value = "供应仓库编码")
        private String supplyWhCode;

        @ApiModelProperty(value = "供应仓库名称")
        private String supplyWhName;

        @ApiModelProperty(value = "类型")
        private String type;

        @ApiModelProperty(value = "需求门店id/门店仓库id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long demandWhStId;

        @ApiModelProperty(value = "需求仓库编码/门店编码")
        private String demandWhStCode;

        @ApiModelProperty(value = "需求仓库名称/门店名称")
        private String demandWhStName;

        @ApiModelProperty(value = "商品品类编码")
        private String itemCateCode;

        @ApiModelProperty(value = "商品品类名称")
        private String itemCateName;

        @ApiModelProperty(value = "商品id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty(value = "商品编码")
        private String itemCode;

        @ApiModelProperty(value = "商品名称")
        private String itemName;

        @ApiModelProperty(value = "转移提前期")
        private BigDecimal transferLeadTime;

        @ApiModelProperty(value = "供应百分比")
        private BigDecimal supplyPercentage;

        @ApiModelProperty(value = "行号")
        private int lineNo;

    }
}
